/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSeg.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGPathSegConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPathSegConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegPathSegType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGPathSegPathSegTypeAsLetter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGPathSegPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPathSegPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegPrototype>(vm.heap)) JSSVGPathSegPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegPrototype, JSSVGPathSegPrototype::Base);

using JSSVGPathSegConstructor = JSDOMConstructorNotConstructable<JSSVGPathSeg>;

/* Hash table for constructor */

static const HashTableValue JSSVGPathSegConstructorTableValues[] =
{
    { "PATHSEG_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "PATHSEG_CLOSEPATH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PATHSEG_MOVETO_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "PATHSEG_MOVETO_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "PATHSEG_LINETO_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "PATHSEG_LINETO_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "PATHSEG_CURVETO_CUBIC_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "PATHSEG_CURVETO_CUBIC_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "PATHSEG_CURVETO_QUADRATIC_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "PATHSEG_CURVETO_QUADRATIC_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "PATHSEG_ARC_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "PATHSEG_ARC_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "PATHSEG_LINETO_HORIZONTAL_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "PATHSEG_LINETO_HORIZONTAL_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "PATHSEG_LINETO_VERTICAL_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "PATHSEG_LINETO_VERTICAL_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(19) } },
};

static_assert(SVGPathSeg::PATHSEG_UNKNOWN == 0, "PATHSEG_UNKNOWN in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CLOSEPATH == 1, "PATHSEG_CLOSEPATH in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_MOVETO_ABS == 2, "PATHSEG_MOVETO_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_MOVETO_REL == 3, "PATHSEG_MOVETO_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_ABS == 4, "PATHSEG_LINETO_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_REL == 5, "PATHSEG_LINETO_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_CUBIC_ABS == 6, "PATHSEG_CURVETO_CUBIC_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_CUBIC_REL == 7, "PATHSEG_CURVETO_CUBIC_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_ABS == 8, "PATHSEG_CURVETO_QUADRATIC_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_REL == 9, "PATHSEG_CURVETO_QUADRATIC_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_ARC_ABS == 10, "PATHSEG_ARC_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_ARC_REL == 11, "PATHSEG_ARC_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_ABS == 12, "PATHSEG_LINETO_HORIZONTAL_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_REL == 13, "PATHSEG_LINETO_HORIZONTAL_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_VERTICAL_ABS == 14, "PATHSEG_LINETO_VERTICAL_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_VERTICAL_REL == 15, "PATHSEG_LINETO_VERTICAL_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_ABS == 16, "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_REL == 17, "PATHSEG_CURVETO_CUBIC_SMOOTH_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS == 18, "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL == 19, "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL in SVGPathSeg does not match value from IDL");

template<> JSValue JSSVGPathSegConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGPathSegConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSeg::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGPathSeg"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSSVGPathSeg::info(), JSSVGPathSegConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGPathSegConstructor::s_info = { "SVGPathSeg", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegConstructor) } },
    { "pathSegType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegPathSegType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pathSegTypeAsLetter", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegPathSegTypeAsLetter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "PATHSEG_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "PATHSEG_CLOSEPATH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PATHSEG_MOVETO_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "PATHSEG_MOVETO_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "PATHSEG_LINETO_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "PATHSEG_LINETO_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "PATHSEG_CURVETO_CUBIC_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "PATHSEG_CURVETO_CUBIC_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "PATHSEG_CURVETO_QUADRATIC_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "PATHSEG_CURVETO_QUADRATIC_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "PATHSEG_ARC_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "PATHSEG_ARC_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "PATHSEG_LINETO_HORIZONTAL_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "PATHSEG_LINETO_HORIZONTAL_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "PATHSEG_LINETO_VERTICAL_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "PATHSEG_LINETO_VERTICAL_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(19) } },
};

const ClassInfo JSSVGPathSegPrototype::s_info = { "SVGPathSegPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegPrototype) };

void JSSVGPathSegPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSeg::info(), JSSVGPathSegPrototypeTableValues, *this);
}

const ClassInfo JSSVGPathSeg::s_info = { "SVGPathSeg", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSeg) };

JSSVGPathSeg::JSSVGPathSeg(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSeg>&& impl)
    : JSDOMWrapper<SVGPathSeg>(structure, globalObject, WTFMove(impl))
{
}

void JSSVGPathSeg::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGPathSeg>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGPathSeg::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSegPrototype::create(vm, &globalObject, JSSVGPathSegPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSVGPathSeg::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPathSeg>(vm, globalObject);
}

JSValue JSSVGPathSeg::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGPathSeg::destroy(JSC::JSCell* cell)
{
    JSSVGPathSeg* thisObject = static_cast<JSSVGPathSeg*>(cell);
    thisObject->JSSVGPathSeg::~JSSVGPathSeg();
}

template<> inline JSSVGPathSeg* IDLAttribute<JSSVGPathSeg>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGPathSeg*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGPathSegConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPathSeg::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGPathSegConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGPathSegPathSegTypeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSeg& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.pathSegType());
    return result;
}

EncodedJSValue jsSVGPathSegPathSegType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPathSeg>::get<jsSVGPathSegPathSegTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pathSegType");
}

static inline JSValue jsSVGPathSegPathSegTypeAsLetterGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSeg& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.pathSegTypeAsLetter());
    return result;
}

EncodedJSValue jsSVGPathSegPathSegTypeAsLetter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPathSeg>::get<jsSVGPathSegPathSegTypeAsLetterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pathSegTypeAsLetter");
}

void JSSVGPathSeg::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPathSeg*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGPathSegOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGPathSegOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGPathSeg = static_cast<JSSVGPathSeg*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGPathSeg->wrapped(), jsSVGPathSeg);
}

SVGPathSeg* JSSVGPathSeg::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGPathSeg*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
