/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothRel.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegCurvetoQuadraticSmoothRelX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPathSegCurvetoQuadraticSmoothRelX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegCurvetoQuadraticSmoothRelY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPathSegCurvetoQuadraticSmoothRelY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGPathSegCurvetoQuadraticSmoothRelPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPathSegCurvetoQuadraticSmoothRelPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegCurvetoQuadraticSmoothRelPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegCurvetoQuadraticSmoothRelPrototype>(vm.heap)) JSSVGPathSegCurvetoQuadraticSmoothRelPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegCurvetoQuadraticSmoothRelPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegCurvetoQuadraticSmoothRelPrototype, JSSVGPathSegCurvetoQuadraticSmoothRelPrototype::Base);

using JSSVGPathSegCurvetoQuadraticSmoothRelConstructor = JSDOMConstructorNotConstructable<JSSVGPathSegCurvetoQuadraticSmoothRel>;

template<> JSValue JSSVGPathSegCurvetoQuadraticSmoothRelConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSeg::getConstructor(vm, &globalObject);
}

template<> void JSSVGPathSegCurvetoQuadraticSmoothRelConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSegCurvetoQuadraticSmoothRel::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGPathSegCurvetoQuadraticSmoothRel"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSVGPathSegCurvetoQuadraticSmoothRelConstructor::s_info = { "SVGPathSegCurvetoQuadraticSmoothRel", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoQuadraticSmoothRelConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegCurvetoQuadraticSmoothRelPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoQuadraticSmoothRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegCurvetoQuadraticSmoothRelConstructor) } },
    { "x", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoQuadraticSmoothRelX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegCurvetoQuadraticSmoothRelX) } },
    { "y", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoQuadraticSmoothRelY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegCurvetoQuadraticSmoothRelY) } },
};

const ClassInfo JSSVGPathSegCurvetoQuadraticSmoothRelPrototype::s_info = { "SVGPathSegCurvetoQuadraticSmoothRelPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoQuadraticSmoothRelPrototype) };

void JSSVGPathSegCurvetoQuadraticSmoothRelPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSegCurvetoQuadraticSmoothRel::info(), JSSVGPathSegCurvetoQuadraticSmoothRelPrototypeTableValues, *this);
}

const ClassInfo JSSVGPathSegCurvetoQuadraticSmoothRel::s_info = { "SVGPathSegCurvetoQuadraticSmoothRel", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoQuadraticSmoothRel) };

JSSVGPathSegCurvetoQuadraticSmoothRel::JSSVGPathSegCurvetoQuadraticSmoothRel(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSegCurvetoQuadraticSmoothRel>&& impl)
    : JSSVGPathSeg(structure, globalObject, WTFMove(impl))
{
}

void JSSVGPathSegCurvetoQuadraticSmoothRel::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGPathSegCurvetoQuadraticSmoothRel>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGPathSegCurvetoQuadraticSmoothRel::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSegCurvetoQuadraticSmoothRelPrototype::create(vm, &globalObject, JSSVGPathSegCurvetoQuadraticSmoothRelPrototype::createStructure(vm, &globalObject, JSSVGPathSeg::prototype(vm, globalObject)));
}

JSObject* JSSVGPathSegCurvetoQuadraticSmoothRel::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPathSegCurvetoQuadraticSmoothRel>(vm, globalObject);
}

JSValue JSSVGPathSegCurvetoQuadraticSmoothRel::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegCurvetoQuadraticSmoothRelConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGPathSegCurvetoQuadraticSmoothRel* IDLAttribute<JSSVGPathSegCurvetoQuadraticSmoothRel>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGPathSegCurvetoQuadraticSmoothRel*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegCurvetoQuadraticSmoothRelPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPathSegCurvetoQuadraticSmoothRel::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegCurvetoQuadraticSmoothRelPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGPathSegCurvetoQuadraticSmoothRelXGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticSmoothRel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.x());
    return result;
}

EncodedJSValue jsSVGPathSegCurvetoQuadraticSmoothRelX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticSmoothRel>::get<jsSVGPathSegCurvetoQuadraticSmoothRelXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "x");
}

static inline bool setJSSVGPathSegCurvetoQuadraticSmoothRelXSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticSmoothRel& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setX(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGPathSegCurvetoQuadraticSmoothRelX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticSmoothRel>::set<setJSSVGPathSegCurvetoQuadraticSmoothRelXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "x");
}

static inline JSValue jsSVGPathSegCurvetoQuadraticSmoothRelYGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticSmoothRel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.y());
    return result;
}

EncodedJSValue jsSVGPathSegCurvetoQuadraticSmoothRelY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticSmoothRel>::get<jsSVGPathSegCurvetoQuadraticSmoothRelYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "y");
}

static inline bool setJSSVGPathSegCurvetoQuadraticSmoothRelYSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoQuadraticSmoothRel& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setY(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGPathSegCurvetoQuadraticSmoothRelY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGPathSegCurvetoQuadraticSmoothRel>::set<setJSSVGPathSegCurvetoQuadraticSmoothRelYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "y");
}

void JSSVGPathSegCurvetoQuadraticSmoothRel::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPathSegCurvetoQuadraticSmoothRel*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
