/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSegMovetoAbs.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGPathSegMovetoAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPathSegMovetoAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegMovetoAbsX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPathSegMovetoAbsX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegMovetoAbsY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPathSegMovetoAbsY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGPathSegMovetoAbsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPathSegMovetoAbsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegMovetoAbsPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegMovetoAbsPrototype>(vm.heap)) JSSVGPathSegMovetoAbsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegMovetoAbsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegMovetoAbsPrototype, JSSVGPathSegMovetoAbsPrototype::Base);

using JSSVGPathSegMovetoAbsConstructor = JSDOMConstructorNotConstructable<JSSVGPathSegMovetoAbs>;

template<> JSValue JSSVGPathSegMovetoAbsConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSeg::getConstructor(vm, &globalObject);
}

template<> void JSSVGPathSegMovetoAbsConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSegMovetoAbs::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGPathSegMovetoAbs"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSVGPathSegMovetoAbsConstructor::s_info = { "SVGPathSegMovetoAbs", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegMovetoAbsConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegMovetoAbsPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegMovetoAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegMovetoAbsConstructor) } },
    { "x", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegMovetoAbsX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegMovetoAbsX) } },
    { "y", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegMovetoAbsY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegMovetoAbsY) } },
};

const ClassInfo JSSVGPathSegMovetoAbsPrototype::s_info = { "SVGPathSegMovetoAbsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegMovetoAbsPrototype) };

void JSSVGPathSegMovetoAbsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSegMovetoAbs::info(), JSSVGPathSegMovetoAbsPrototypeTableValues, *this);
}

const ClassInfo JSSVGPathSegMovetoAbs::s_info = { "SVGPathSegMovetoAbs", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegMovetoAbs) };

JSSVGPathSegMovetoAbs::JSSVGPathSegMovetoAbs(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSegMovetoAbs>&& impl)
    : JSSVGPathSeg(structure, globalObject, WTFMove(impl))
{
}

void JSSVGPathSegMovetoAbs::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGPathSegMovetoAbs>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGPathSegMovetoAbs::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSegMovetoAbsPrototype::create(vm, &globalObject, JSSVGPathSegMovetoAbsPrototype::createStructure(vm, &globalObject, JSSVGPathSeg::prototype(vm, globalObject)));
}

JSObject* JSSVGPathSegMovetoAbs::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPathSegMovetoAbs>(vm, globalObject);
}

JSValue JSSVGPathSegMovetoAbs::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegMovetoAbsConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGPathSegMovetoAbs* IDLAttribute<JSSVGPathSegMovetoAbs>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGPathSegMovetoAbs*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGPathSegMovetoAbsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegMovetoAbsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPathSegMovetoAbs::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGPathSegMovetoAbsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegMovetoAbsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGPathSegMovetoAbsXGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegMovetoAbs& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.x());
    return result;
}

EncodedJSValue jsSVGPathSegMovetoAbsX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPathSegMovetoAbs>::get<jsSVGPathSegMovetoAbsXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "x");
}

static inline bool setJSSVGPathSegMovetoAbsXSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegMovetoAbs& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setX(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGPathSegMovetoAbsX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGPathSegMovetoAbs>::set<setJSSVGPathSegMovetoAbsXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "x");
}

static inline JSValue jsSVGPathSegMovetoAbsYGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegMovetoAbs& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.y());
    return result;
}

EncodedJSValue jsSVGPathSegMovetoAbsY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPathSegMovetoAbs>::get<jsSVGPathSegMovetoAbsYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "y");
}

static inline bool setJSSVGPathSegMovetoAbsYSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegMovetoAbs& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setY(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGPathSegMovetoAbsY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGPathSegMovetoAbs>::set<setJSSVGPathSegMovetoAbsYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "y");
}

void JSSVGPathSegMovetoAbs::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPathSegMovetoAbs*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
