/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPolygonElement.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGPointList.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGPolygonElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPolygonElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPolygonElementPoints(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGPolygonElementAnimatedPoints(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGPolygonElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPolygonElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPolygonElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPolygonElementPrototype>(vm.heap)) JSSVGPolygonElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPolygonElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPolygonElementPrototype, JSSVGPolygonElementPrototype::Base);

using JSSVGPolygonElementConstructor = JSDOMConstructorNotConstructable<JSSVGPolygonElement>;

template<> JSValue JSSVGPolygonElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGGeometryElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGPolygonElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPolygonElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGPolygonElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSVGPolygonElementConstructor::s_info = { "SVGPolygonElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPolygonElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPolygonElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPolygonElementConstructor) } },
    { "points", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementPoints), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "animatedPoints", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementAnimatedPoints), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGPolygonElementPrototype::s_info = { "SVGPolygonElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPolygonElementPrototype) };

void JSSVGPolygonElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPolygonElement::info(), JSSVGPolygonElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGPolygonElement::s_info = { "SVGPolygonElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPolygonElement) };

JSSVGPolygonElement::JSSVGPolygonElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPolygonElement>&& impl)
    : JSSVGGeometryElement(structure, globalObject, WTFMove(impl))
{
}

void JSSVGPolygonElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGPolygonElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGPolygonElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGPolygonElementPrototype::create(vm, &globalObject, JSSVGPolygonElementPrototype::createStructure(vm, &globalObject, JSSVGGeometryElement::prototype(vm, globalObject)));
}

JSObject* JSSVGPolygonElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPolygonElement>(vm, globalObject);
}

JSValue JSSVGPolygonElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPolygonElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGPolygonElement* IDLAttribute<JSSVGPolygonElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGPolygonElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGPolygonElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPolygonElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPolygonElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGPolygonElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPolygonElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGPolygonElementPointsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPolygonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGPointList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.points());
    return result;
}

EncodedJSValue jsSVGPolygonElementPoints(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPolygonElement>::get<jsSVGPolygonElementPointsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "points");
}

static inline JSValue jsSVGPolygonElementAnimatedPointsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPolygonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGPointList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.animatedPoints());
    return result;
}

EncodedJSValue jsSVGPolygonElementAnimatedPoints(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPolygonElement>::get<jsSVGPolygonElementAnimatedPointsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "animatedPoints");
}

void JSSVGPolygonElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPolygonElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
