/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGTextPathElement.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGTextPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGTextPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGTextPathElementStartOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGTextPathElementMethod(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGTextPathElementSpacing(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGTextPathElementHref(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGTextPathElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGTextPathElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGTextPathElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGTextPathElementPrototype>(vm.heap)) JSSVGTextPathElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGTextPathElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGTextPathElementPrototype, JSSVGTextPathElementPrototype::Base);

using JSSVGTextPathElementConstructor = JSDOMConstructorNotConstructable<JSSVGTextPathElement>;

/* Hash table for constructor */

static const HashTableValue JSSVGTextPathElementConstructorTableValues[] =
{
    { "TEXTPATH_METHODTYPE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "TEXTPATH_METHODTYPE_ALIGN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "TEXTPATH_METHODTYPE_STRETCH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TEXTPATH_SPACINGTYPE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "TEXTPATH_SPACINGTYPE_AUTO", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "TEXTPATH_SPACINGTYPE_EXACT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

static_assert(SVGTextPathElement::TEXTPATH_METHODTYPE_UNKNOWN == 0, "TEXTPATH_METHODTYPE_UNKNOWN in SVGTextPathElement does not match value from IDL");
static_assert(SVGTextPathElement::TEXTPATH_METHODTYPE_ALIGN == 1, "TEXTPATH_METHODTYPE_ALIGN in SVGTextPathElement does not match value from IDL");
static_assert(SVGTextPathElement::TEXTPATH_METHODTYPE_STRETCH == 2, "TEXTPATH_METHODTYPE_STRETCH in SVGTextPathElement does not match value from IDL");
static_assert(SVGTextPathElement::TEXTPATH_SPACINGTYPE_UNKNOWN == 0, "TEXTPATH_SPACINGTYPE_UNKNOWN in SVGTextPathElement does not match value from IDL");
static_assert(SVGTextPathElement::TEXTPATH_SPACINGTYPE_AUTO == 1, "TEXTPATH_SPACINGTYPE_AUTO in SVGTextPathElement does not match value from IDL");
static_assert(SVGTextPathElement::TEXTPATH_SPACINGTYPE_EXACT == 2, "TEXTPATH_SPACINGTYPE_EXACT in SVGTextPathElement does not match value from IDL");

template<> JSValue JSSVGTextPathElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGTextContentElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGTextPathElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGTextPathElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGTextPathElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSSVGTextPathElement::info(), JSSVGTextPathElementConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGTextPathElementConstructor::s_info = { "SVGTextPathElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTextPathElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGTextPathElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGTextPathElementConstructor) } },
    { "startOffset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementStartOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "method", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementMethod), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "spacing", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementSpacing), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "href", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementHref), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "TEXTPATH_METHODTYPE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "TEXTPATH_METHODTYPE_ALIGN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "TEXTPATH_METHODTYPE_STRETCH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TEXTPATH_SPACINGTYPE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "TEXTPATH_SPACINGTYPE_AUTO", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "TEXTPATH_SPACINGTYPE_EXACT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

const ClassInfo JSSVGTextPathElementPrototype::s_info = { "SVGTextPathElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTextPathElementPrototype) };

void JSSVGTextPathElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGTextPathElement::info(), JSSVGTextPathElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGTextPathElement::s_info = { "SVGTextPathElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTextPathElement) };

JSSVGTextPathElement::JSSVGTextPathElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGTextPathElement>&& impl)
    : JSSVGTextContentElement(structure, globalObject, WTFMove(impl))
{
}

void JSSVGTextPathElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGTextPathElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGTextPathElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGTextPathElementPrototype::create(vm, &globalObject, JSSVGTextPathElementPrototype::createStructure(vm, &globalObject, JSSVGTextContentElement::prototype(vm, globalObject)));
}

JSObject* JSSVGTextPathElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGTextPathElement>(vm, globalObject);
}

JSValue JSSVGTextPathElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTextPathElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGTextPathElement* IDLAttribute<JSSVGTextPathElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGTextPathElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGTextPathElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGTextPathElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGTextPathElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGTextPathElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGTextPathElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGTextPathElementStartOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextPathElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.startOffsetAnimated());
    return result;
}

EncodedJSValue jsSVGTextPathElementStartOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGTextPathElement>::get<jsSVGTextPathElementStartOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "startOffset");
}

static inline JSValue jsSVGTextPathElementMethodGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextPathElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.methodAnimated());
    return result;
}

EncodedJSValue jsSVGTextPathElementMethod(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGTextPathElement>::get<jsSVGTextPathElementMethodGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "method");
}

static inline JSValue jsSVGTextPathElementSpacingGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextPathElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.spacingAnimated());
    return result;
}

EncodedJSValue jsSVGTextPathElementSpacing(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGTextPathElement>::get<jsSVGTextPathElementSpacingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "spacing");
}

static inline JSValue jsSVGTextPathElementHrefGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextPathElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.hrefAnimated());
    return result;
}

EncodedJSValue jsSVGTextPathElementHref(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGTextPathElement>::get<jsSVGTextPathElementHrefGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "href");
}

void JSSVGTextPathElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGTextPathElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
