/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGViewSpec.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGElement.h"
#include "JSSVGTransformList.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGViewSpecConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGViewSpecConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGViewSpecTransform(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecViewTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecViewBoxString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecPreserveAspectRatioString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecTransformString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecViewTargetString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecViewBox(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecPreserveAspectRatio(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGViewSpecZoomAndPan(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGViewSpecZoomAndPan(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGViewSpecPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGViewSpecPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGViewSpecPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGViewSpecPrototype>(vm.heap)) JSSVGViewSpecPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGViewSpecPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGViewSpecPrototype, JSSVGViewSpecPrototype::Base);

using JSSVGViewSpecConstructor = JSDOMConstructorNotConstructable<JSSVGViewSpec>;

/* Hash table for constructor */

static const HashTableValue JSSVGViewSpecConstructorTableValues[] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_ZOOMANDPAN_DISABLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_ZOOMANDPAN_MAGNIFY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

static_assert(SVGViewSpec::SVG_ZOOMANDPAN_UNKNOWN == 0, "SVG_ZOOMANDPAN_UNKNOWN in SVGViewSpec does not match value from IDL");
static_assert(SVGViewSpec::SVG_ZOOMANDPAN_DISABLE == 1, "SVG_ZOOMANDPAN_DISABLE in SVGViewSpec does not match value from IDL");
static_assert(SVGViewSpec::SVG_ZOOMANDPAN_MAGNIFY == 2, "SVG_ZOOMANDPAN_MAGNIFY in SVGViewSpec does not match value from IDL");

template<> JSValue JSSVGViewSpecConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGViewSpecConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGViewSpec::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGViewSpec"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSSVGViewSpec::info(), JSSVGViewSpecConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGViewSpecConstructor::s_info = { "SVGViewSpec", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGViewSpecConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGViewSpecPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGViewSpecConstructor) } },
    { "transform", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecTransform), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "viewTarget", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "viewBoxString", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewBoxString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "preserveAspectRatioString", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecPreserveAspectRatioString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "transformString", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecTransformString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "viewTargetString", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewTargetString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "viewBox", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewBox), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "preserveAspectRatio", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecPreserveAspectRatio), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "zoomAndPan", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecZoomAndPan), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGViewSpecZoomAndPan) } },
    { "SVG_ZOOMANDPAN_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_ZOOMANDPAN_DISABLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_ZOOMANDPAN_MAGNIFY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

const ClassInfo JSSVGViewSpecPrototype::s_info = { "SVGViewSpecPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGViewSpecPrototype) };

void JSSVGViewSpecPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGViewSpec::info(), JSSVGViewSpecPrototypeTableValues, *this);
}

const ClassInfo JSSVGViewSpec::s_info = { "SVGViewSpec", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGViewSpec) };

JSSVGViewSpec::JSSVGViewSpec(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGViewSpec>&& impl)
    : JSDOMWrapper<SVGViewSpec>(structure, globalObject, WTFMove(impl))
{
}

void JSSVGViewSpec::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGViewSpec>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGViewSpec::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGViewSpecPrototype::create(vm, &globalObject, JSSVGViewSpecPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSVGViewSpec::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGViewSpec>(vm, globalObject);
}

JSValue JSSVGViewSpec::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGViewSpecConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGViewSpec::destroy(JSC::JSCell* cell)
{
    JSSVGViewSpec* thisObject = static_cast<JSSVGViewSpec*>(cell);
    thisObject->JSSVGViewSpec::~JSSVGViewSpec();
}

template<> inline JSSVGViewSpec* IDLAttribute<JSSVGViewSpec>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGViewSpec*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGViewSpecConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGViewSpecPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGViewSpec::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGViewSpecConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGViewSpecPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGViewSpecTransformGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGTransformList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.transform());
    return result;
}

EncodedJSValue jsSVGViewSpecTransform(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpecTransformGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "transform");
}

static inline JSValue jsSVGViewSpecViewTargetGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.viewTarget());
    return result;
}

EncodedJSValue jsSVGViewSpecViewTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpecViewTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "viewTarget");
}

static inline JSValue jsSVGViewSpecViewBoxStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.viewBoxString());
    return result;
}

EncodedJSValue jsSVGViewSpecViewBoxString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpecViewBoxStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "viewBoxString");
}

static inline JSValue jsSVGViewSpecPreserveAspectRatioStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.preserveAspectRatioString());
    return result;
}

EncodedJSValue jsSVGViewSpecPreserveAspectRatioString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpecPreserveAspectRatioStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "preserveAspectRatioString");
}

static inline JSValue jsSVGViewSpecTransformStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.transformString());
    return result;
}

EncodedJSValue jsSVGViewSpecTransformString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpecTransformStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "transformString");
}

static inline JSValue jsSVGViewSpecViewTargetStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.viewTargetString());
    return result;
}

EncodedJSValue jsSVGViewSpecViewTargetString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpecViewTargetStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "viewTargetString");
}

static inline JSValue jsSVGViewSpecViewBoxGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedRect>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.viewBoxAnimated());
    return result;
}

EncodedJSValue jsSVGViewSpecViewBox(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpecViewBoxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "viewBox");
}

static inline JSValue jsSVGViewSpecPreserveAspectRatioGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedPreserveAspectRatio>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.preserveAspectRatioAnimated());
    return result;
}

EncodedJSValue jsSVGViewSpecPreserveAspectRatio(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpecPreserveAspectRatioGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "preserveAspectRatio");
}

static inline JSValue jsSVGViewSpecZoomAndPanGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.zoomAndPan());
    return result;
}

EncodedJSValue jsSVGViewSpecZoomAndPan(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpecZoomAndPanGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "zoomAndPan");
}

static inline bool setJSSVGViewSpecZoomAndPanSetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedShort>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setZoomAndPan(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGViewSpecZoomAndPan(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGViewSpec>::set<setJSSVGViewSpecZoomAndPanSetter>(*lexicalGlobalObject, thisValue, encodedValue, "zoomAndPan");
}

void JSSVGViewSpec::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSSVGViewSpec*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSSVGViewSpec::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSSVGViewSpec*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSSVGViewSpec::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGViewSpec*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGViewSpecOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGViewSpecOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGViewSpec = static_cast<JSSVGViewSpec*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGViewSpec->wrapped(), jsSVGViewSpec);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGViewSpec>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SVGViewSpec.
    static_assert(!std::is_polymorphic<SVGViewSpec>::value, "SVGViewSpec is polymorphic but the IDL claims it is not");
    return createWrapper<SVGViewSpec>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGViewSpec& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGViewSpec* JSSVGViewSpec::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGViewSpec*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
