/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerClients.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSServiceWorkerClientType.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> ServiceWorkerClients::ClientQueryOptions convertDictionary<ServiceWorkerClients::ClientQueryOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ServiceWorkerClients::ClientQueryOptions result;
    JSValue includeUncontrolledValue;
    if (isNullOrUndefined)
        includeUncontrolledValue = jsUndefined();
    else {
        includeUncontrolledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "includeUncontrolled"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!includeUncontrolledValue.isUndefined()) {
        result.includeUncontrolled = convert<IDLBoolean>(lexicalGlobalObject, includeUncontrolledValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.includeUncontrolled = false;
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<ServiceWorkerClientType>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.type = ServiceWorkerClientType::Window;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientsPrototypeFunctionGet(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientsPrototypeFunctionMatchAll(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientsPrototypeFunctionOpenWindow(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientsPrototypeFunctionClaim(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsServiceWorkerClientsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerClientsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSServiceWorkerClientsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerClientsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerClientsPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerClientsPrototype>(vm.heap)) JSServiceWorkerClientsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerClientsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerClientsPrototype, JSServiceWorkerClientsPrototype::Base);

using JSServiceWorkerClientsConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerClients>;

template<> JSValue JSServiceWorkerClientsConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSServiceWorkerClientsConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSServiceWorkerClients::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Clients"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSServiceWorkerClientsConstructor::s_info = { "Clients", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerClientsConstructor) };

/* Hash table for prototype */

static const HashTableValue JSServiceWorkerClientsPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerClientsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerClientsConstructor) } },
    { "get", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerClientsPrototypeFunctionGet), (intptr_t) (1) } },
    { "matchAll", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerClientsPrototypeFunctionMatchAll), (intptr_t) (0) } },
    { "openWindow", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerClientsPrototypeFunctionOpenWindow), (intptr_t) (1) } },
    { "claim", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerClientsPrototypeFunctionClaim), (intptr_t) (0) } },
};

const ClassInfo JSServiceWorkerClientsPrototype::s_info = { "ClientsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerClientsPrototype) };

void JSServiceWorkerClientsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerClients::info(), JSServiceWorkerClientsPrototypeTableValues, *this);
}

const ClassInfo JSServiceWorkerClients::s_info = { "Clients", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerClients) };

JSServiceWorkerClients::JSServiceWorkerClients(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerClients>&& impl)
    : JSDOMWrapper<ServiceWorkerClients>(structure, globalObject, WTFMove(impl))
{
}

void JSServiceWorkerClients::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ServiceWorkerClients>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSServiceWorkerClients::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSServiceWorkerClientsPrototype::create(vm, &globalObject, JSServiceWorkerClientsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSServiceWorkerClients::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerClients>(vm, globalObject);
}

JSValue JSServiceWorkerClients::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerClientsConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSServiceWorkerClients::destroy(JSC::JSCell* cell)
{
    JSServiceWorkerClients* thisObject = static_cast<JSServiceWorkerClients*>(cell);
    thisObject->JSServiceWorkerClients::~JSServiceWorkerClients();
}

template<> inline JSServiceWorkerClients* IDLOperation<JSServiceWorkerClients>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSServiceWorkerClients*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsServiceWorkerClientsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerClientsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerClients::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSServiceWorkerClientsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerClientsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsServiceWorkerClientsPrototypeFunctionGetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerClients>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto id = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.get(*context, WTFMove(id), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientsPrototypeFunctionGet(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerClients>::call<jsServiceWorkerClientsPrototypeFunctionGetBody>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsServiceWorkerClientsPrototypeFunctionMatchAllBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerClients>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto options = convert<IDLDictionary<ServiceWorkerClients::ClientQueryOptions>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.matchAll(*context, WTFMove(options), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientsPrototypeFunctionMatchAll(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerClients>::call<jsServiceWorkerClientsPrototypeFunctionMatchAllBody>(*lexicalGlobalObject, *callFrame, "matchAll");
}

static inline JSC::EncodedJSValue jsServiceWorkerClientsPrototypeFunctionOpenWindowBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerClients>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.openWindow(*context, WTFMove(url), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientsPrototypeFunctionOpenWindow(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerClients>::call<jsServiceWorkerClientsPrototypeFunctionOpenWindowBody>(*lexicalGlobalObject, *callFrame, "openWindow");
}

static inline JSC::EncodedJSValue jsServiceWorkerClientsPrototypeFunctionClaimBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerClients>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    impl.claim(*context, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientsPrototypeFunctionClaim(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerClients>::call<jsServiceWorkerClientsPrototypeFunctionClaimBody>(*lexicalGlobalObject, *callFrame, "claim");
}

void JSServiceWorkerClients::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerClients*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSServiceWorkerClientsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsServiceWorkerClients = jsCast<JSServiceWorkerClients*>(handle.slot()->asCell());
    ServiceWorkerClients* root = &jsServiceWorkerClients->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from ServiceWorkerClients";
    return visitor.containsOpaqueRoot(root);
}

void JSServiceWorkerClientsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsServiceWorkerClients = static_cast<JSServiceWorkerClients*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsServiceWorkerClients->wrapped(), jsServiceWorkerClients);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ServiceWorkerClients>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to ServiceWorkerClients.
    static_assert(!std::is_polymorphic<ServiceWorkerClients>::value, "ServiceWorkerClients is polymorphic but the IDL claims it is not");
    return createWrapper<ServiceWorkerClients>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ServiceWorkerClients& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ServiceWorkerClients* JSServiceWorkerClients::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSServiceWorkerClients*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SERVICE_WORKER)
