/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerGlobalScope.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSServiceWorkerClients.h"
#include "JSServiceWorkerRegistration.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include "ServiceWorkerGlobalScope.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(SERVICE_WORKER)
#include "JSExtendableEvent.h"
#include "JSExtendableMessageEvent.h"
#include "JSFetchEvent.h"
#include "JSServiceWorker.h"
#include "JSServiceWorkerClient.h"
#include "JSServiceWorkerContainer.h"
#include "JSServiceWorkerGlobalScope.h"
#include "JSServiceWorkerWindowClient.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerGlobalScopeInstanceFunctionSkipWaiting(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsServiceWorkerGlobalScopeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerGlobalScopeClients(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerGlobalScopeRegistration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerGlobalScopeOninstall(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeOninstall(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerGlobalScopeOnactivate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeOnactivate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerGlobalScopeOnfetch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeOnfetch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerGlobalScopeOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerGlobalScopeOnmessageerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeOnmessageerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeExtendableEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeExtendableEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeExtendableMessageEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeExtendableMessageEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeFetchEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeFetchEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeServiceWorkerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeServiceWorkerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeClientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeClientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeClientsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeClientsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeServiceWorkerContainerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeServiceWorkerContainerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeServiceWorkerRegistrationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeServiceWorkerRegistrationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsServiceWorkerGlobalScopeWindowClientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerGlobalScopeWindowClientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif

using JSServiceWorkerGlobalScopeConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerGlobalScope>;

/* Hash table */

static const struct CompactHashIndex JSServiceWorkerGlobalScopeTableIndex[17] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 6, -1 },
    { 5, -1 },
    { 1, -1 },
    { -1, -1 },
    { 0, 16 },
    { 3, -1 },
    { -1, -1 },
    { -1, -1 },
    { 7, -1 },
    { 2, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 4, -1 },
};


static const HashTableValue JSServiceWorkerGlobalScopeTableValues[] =
{
    { "clients", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerGlobalScopeClients), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "registration", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerGlobalScopeRegistration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "oninstall", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerGlobalScopeOninstall), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerGlobalScopeOninstall) } },
    { "onactivate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerGlobalScopeOnactivate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerGlobalScopeOnactivate) } },
    { "onfetch", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerGlobalScopeOnfetch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerGlobalScopeOnfetch) } },
    { "onmessage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerGlobalScopeOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerGlobalScopeOnmessage) } },
    { "onmessageerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerGlobalScopeOnmessageerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerGlobalScopeOnmessageerror) } },
    { "skipWaiting", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerGlobalScopeInstanceFunctionSkipWaiting), (intptr_t) (0) } },
};

static const HashTable JSServiceWorkerGlobalScopeTable = { 8, 15, true, JSServiceWorkerGlobalScope::info(), JSServiceWorkerGlobalScopeTableValues, JSServiceWorkerGlobalScopeTableIndex };
template<> JSValue JSServiceWorkerGlobalScopeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWorkerGlobalScope::getConstructor(vm, &globalObject);
}

template<> void JSServiceWorkerGlobalScopeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, globalObject.getPrototypeDirect(vm), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ServiceWorkerGlobalScope"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSServiceWorkerGlobalScopeConstructor::s_info = { "ServiceWorkerGlobalScope", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerGlobalScopeConstructor) };

/* Hash table for prototype */

static const struct CompactHashIndex JSServiceWorkerGlobalScopePrototypeTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSServiceWorkerGlobalScopePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerGlobalScopeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerGlobalScopeConstructor) } },
};

static const HashTable JSServiceWorkerGlobalScopePrototypeTable = { 1, 1, true, JSServiceWorkerGlobalScope::info(), JSServiceWorkerGlobalScopePrototypeTableValues, JSServiceWorkerGlobalScopePrototypeTableIndex };
const ClassInfo JSServiceWorkerGlobalScopePrototype::s_info = { "ServiceWorkerGlobalScopePrototype", &Base::s_info, &JSServiceWorkerGlobalScopePrototypeTable, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerGlobalScopePrototype) };

const ClassInfo JSServiceWorkerGlobalScope::s_info = { "ServiceWorkerGlobalScope", &Base::s_info, &JSServiceWorkerGlobalScopeTable, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerGlobalScope) };

JSServiceWorkerGlobalScope::JSServiceWorkerGlobalScope(VM& vm, Structure* structure, Ref<ServiceWorkerGlobalScope>&& impl)
    : JSWorkerGlobalScope(vm, structure, WTFMove(impl))
{
}

void JSServiceWorkerGlobalScope::finishCreation(VM& vm, JSProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    static_assert(!std::is_base_of<ActiveDOMObject, ServiceWorkerGlobalScope>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

#if ENABLE(SERVICE_WORKER)
    if (RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ExtendableEventPublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeExtendableEventConstructor, setJSServiceWorkerGlobalScopeExtendableEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if (RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ExtendableMessageEventPublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeExtendableMessageEventConstructor, setJSServiceWorkerGlobalScopeExtendableMessageEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if (RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().FetchEventPublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeFetchEventConstructor, setJSServiceWorkerGlobalScopeFetchEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ServiceWorkerPublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeServiceWorkerConstructor, setJSServiceWorkerGlobalScopeServiceWorkerConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if (RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ClientPublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeClientConstructor, setJSServiceWorkerGlobalScopeClientConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if (RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ClientsPublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeClientsConstructor, setJSServiceWorkerGlobalScopeClientsConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ServiceWorkerContainerPublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeServiceWorkerContainerConstructor, setJSServiceWorkerGlobalScopeServiceWorkerContainerConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if (RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ServiceWorkerGlobalScopePublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructor, setJSServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ServiceWorkerRegistrationPublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeServiceWorkerRegistrationConstructor, setJSServiceWorkerGlobalScopeServiceWorkerRegistrationConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if (RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().WindowClientPublicName(), CustomGetterSetter::create(vm, jsServiceWorkerGlobalScopeWindowClientConstructor, setJSServiceWorkerGlobalScopeWindowClientConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
}

JSValue JSServiceWorkerGlobalScope::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerGlobalScopeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSServiceWorkerGlobalScope* IDLAttribute<JSServiceWorkerGlobalScope>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto decodedThisValue = JSValue::decode(thisValue);
    if (decodedThisValue.isUndefinedOrNull())
        decodedThisValue = JSValue(&lexicalGlobalObject).toThis(&lexicalGlobalObject, NotStrictMode);
    return toJSServiceWorkerGlobalScope(vm, decodedThisValue);
}

template<> inline JSServiceWorkerGlobalScope* IDLOperation<JSServiceWorkerGlobalScope>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return toJSServiceWorkerGlobalScope(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue().toThis(&lexicalGlobalObject, NotStrictMode));
}

EncodedJSValue jsServiceWorkerGlobalScopeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerGlobalScopePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerGlobalScope::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSServiceWorkerGlobalScopeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerGlobalScopePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsServiceWorkerGlobalScopeClientsGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<ServiceWorkerClients>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.clients());
    return result;
}

EncodedJSValue jsServiceWorkerGlobalScopeClients(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeClientsGetter>(*lexicalGlobalObject, thisValue, "clients");
}

static inline JSValue jsServiceWorkerGlobalScopeRegistrationGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<ServiceWorkerRegistration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.registration());
    return result;
}

EncodedJSValue jsServiceWorkerGlobalScopeRegistration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeRegistrationGetter>(*lexicalGlobalObject, thisValue, "registration");
}

static inline JSValue jsServiceWorkerGlobalScopeOninstallGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().installEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsServiceWorkerGlobalScopeOninstall(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeOninstallGetter>(*lexicalGlobalObject, thisValue, "oninstall");
}

static inline bool setJSServiceWorkerGlobalScopeOninstallSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().installEvent, value);
    return true;
}

bool setJSServiceWorkerGlobalScopeOninstall(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeOninstallSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oninstall");
}

static inline JSValue jsServiceWorkerGlobalScopeOnactivateGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().activateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsServiceWorkerGlobalScopeOnactivate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeOnactivateGetter>(*lexicalGlobalObject, thisValue, "onactivate");
}

static inline bool setJSServiceWorkerGlobalScopeOnactivateSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().activateEvent, value);
    return true;
}

bool setJSServiceWorkerGlobalScopeOnactivate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeOnactivateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onactivate");
}

static inline JSValue jsServiceWorkerGlobalScopeOnfetchGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().fetchEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsServiceWorkerGlobalScopeOnfetch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeOnfetchGetter>(*lexicalGlobalObject, thisValue, "onfetch");
}

static inline bool setJSServiceWorkerGlobalScopeOnfetchSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().fetchEvent, value);
    return true;
}

bool setJSServiceWorkerGlobalScopeOnfetch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeOnfetchSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfetch");
}

static inline JSValue jsServiceWorkerGlobalScopeOnmessageGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsServiceWorkerGlobalScopeOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeOnmessageGetter>(*lexicalGlobalObject, thisValue, "onmessage");
}

static inline bool setJSServiceWorkerGlobalScopeOnmessageSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().messageEvent, value);
    return true;
}

bool setJSServiceWorkerGlobalScopeOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeOnmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmessage");
}

static inline JSValue jsServiceWorkerGlobalScopeOnmessageerrorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageerrorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsServiceWorkerGlobalScopeOnmessageerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeOnmessageerrorGetter>(*lexicalGlobalObject, thisValue, "onmessageerror");
}

static inline bool setJSServiceWorkerGlobalScopeOnmessageerrorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().messageerrorEvent, value);
    return true;
}

bool setJSServiceWorkerGlobalScopeOnmessageerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeOnmessageerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmessageerror");
}

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeExtendableEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSExtendableEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeExtendableEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeExtendableEventConstructorGetter>(*lexicalGlobalObject, thisValue, "ExtendableEvent");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeExtendableEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ExtendableEvent"), strlen("ExtendableEvent")), value);
}

bool setJSServiceWorkerGlobalScopeExtendableEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeExtendableEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ExtendableEvent");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeExtendableMessageEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSExtendableMessageEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeExtendableMessageEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeExtendableMessageEventConstructorGetter>(*lexicalGlobalObject, thisValue, "ExtendableMessageEvent");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeExtendableMessageEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ExtendableMessageEvent"), strlen("ExtendableMessageEvent")), value);
}

bool setJSServiceWorkerGlobalScopeExtendableMessageEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeExtendableMessageEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ExtendableMessageEvent");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeFetchEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFetchEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeFetchEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeFetchEventConstructorGetter>(*lexicalGlobalObject, thisValue, "FetchEvent");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeFetchEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("FetchEvent"), strlen("FetchEvent")), value);
}

bool setJSServiceWorkerGlobalScopeFetchEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeFetchEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "FetchEvent");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeServiceWorkerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorker::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeServiceWorkerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeServiceWorkerConstructorGetter>(*lexicalGlobalObject, thisValue, "ServiceWorker");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeServiceWorkerConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ServiceWorker"), strlen("ServiceWorker")), value);
}

bool setJSServiceWorkerGlobalScopeServiceWorkerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeServiceWorkerConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ServiceWorker");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeClientConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorkerClient::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeClientConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeClientConstructorGetter>(*lexicalGlobalObject, thisValue, "Client");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeClientConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Client"), strlen("Client")), value);
}

bool setJSServiceWorkerGlobalScopeClientConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeClientConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Client");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeClientsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorkerClients::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeClientsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeClientsConstructorGetter>(*lexicalGlobalObject, thisValue, "Clients");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeClientsConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Clients"), strlen("Clients")), value);
}

bool setJSServiceWorkerGlobalScopeClientsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeClientsConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Clients");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeServiceWorkerContainerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorkerContainer::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeServiceWorkerContainerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeServiceWorkerContainerConstructorGetter>(*lexicalGlobalObject, thisValue, "ServiceWorkerContainer");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeServiceWorkerContainerConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ServiceWorkerContainer"), strlen("ServiceWorkerContainer")), value);
}

bool setJSServiceWorkerGlobalScopeServiceWorkerContainerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeServiceWorkerContainerConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ServiceWorkerContainer");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorkerGlobalScope::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructorGetter>(*lexicalGlobalObject, thisValue, "ServiceWorkerGlobalScope");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ServiceWorkerGlobalScope"), strlen("ServiceWorkerGlobalScope")), value);
}

bool setJSServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeServiceWorkerGlobalScopeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ServiceWorkerGlobalScope");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeServiceWorkerRegistrationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorkerRegistration::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeServiceWorkerRegistrationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeServiceWorkerRegistrationConstructorGetter>(*lexicalGlobalObject, thisValue, "ServiceWorkerRegistration");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeServiceWorkerRegistrationConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ServiceWorkerRegistration"), strlen("ServiceWorkerRegistration")), value);
}

bool setJSServiceWorkerGlobalScopeServiceWorkerRegistrationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeServiceWorkerRegistrationConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ServiceWorkerRegistration");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsServiceWorkerGlobalScopeWindowClientConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSServiceWorkerWindowClient::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsServiceWorkerGlobalScopeWindowClientConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::get<jsServiceWorkerGlobalScopeWindowClientConstructorGetter>(*lexicalGlobalObject, thisValue, "WindowClient");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline bool setJSServiceWorkerGlobalScopeWindowClientConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("WindowClient"), strlen("WindowClient")), value);
}

bool setJSServiceWorkerGlobalScopeWindowClientConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSServiceWorkerGlobalScope>::set<setJSServiceWorkerGlobalScopeWindowClientConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "WindowClient");
}

#endif

static inline JSC::EncodedJSValue jsServiceWorkerGlobalScopeInstanceFunctionSkipWaitingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerGlobalScope>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.skipWaiting(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerGlobalScopeInstanceFunctionSkipWaiting(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSServiceWorkerGlobalScope>::call<jsServiceWorkerGlobalScopeInstanceFunctionSkipWaitingBody>(*lexicalGlobalObject, *callFrame, "skipWaiting");
}

JSC::IsoSubspace* JSServiceWorkerGlobalScope::subspaceForImpl(JSC::VM& vm)
{
    return &static_cast<JSVMClientData*>(vm.clientData)->subspaceForJSServiceWorkerGlobalScope();
}

void JSServiceWorkerGlobalScope::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSServiceWorkerGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSServiceWorkerGlobalScope::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSServiceWorkerGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSServiceWorkerGlobalScope::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerGlobalScope*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(SERVICE_WORKER)
