/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesis.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSpeechSynthesisUtterance.h"
#include "JSSpeechSynthesisVoice.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionSpeak(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionCancel(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionPause(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionResume(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionGetVoices(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsSpeechSynthesisPending(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSpeechSynthesisSpeaking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSpeechSynthesisPaused(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSpeechSynthesisPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSpeechSynthesisPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSpeechSynthesisPrototype* ptr = new (NotNull, JSC::allocateCell<JSSpeechSynthesisPrototype>(vm.heap)) JSSpeechSynthesisPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSpeechSynthesisPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechSynthesisPrototype, JSSpeechSynthesisPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSSpeechSynthesisPrototypeTableValues[] =
{
    { "pending", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisPending), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "speaking", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisSpeaking), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "paused", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisPaused), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "speak", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSpeechSynthesisPrototypeFunctionSpeak), (intptr_t) (1) } },
    { "cancel", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSpeechSynthesisPrototypeFunctionCancel), (intptr_t) (0) } },
    { "pause", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSpeechSynthesisPrototypeFunctionPause), (intptr_t) (0) } },
    { "resume", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSpeechSynthesisPrototypeFunctionResume), (intptr_t) (0) } },
    { "getVoices", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSpeechSynthesisPrototypeFunctionGetVoices), (intptr_t) (0) } },
};

const ClassInfo JSSpeechSynthesisPrototype::s_info = { "SpeechSynthesisPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesisPrototype) };

void JSSpeechSynthesisPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSpeechSynthesis::info(), JSSpeechSynthesisPrototypeTableValues, *this);
}

const ClassInfo JSSpeechSynthesis::s_info = { "SpeechSynthesis", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesis) };

JSSpeechSynthesis::JSSpeechSynthesis(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SpeechSynthesis>&& impl)
    : JSDOMWrapper<SpeechSynthesis>(structure, globalObject, WTFMove(impl))
{
}

void JSSpeechSynthesis::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SpeechSynthesis>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSpeechSynthesis::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSpeechSynthesisPrototype::create(vm, &globalObject, JSSpeechSynthesisPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSpeechSynthesis::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSpeechSynthesis>(vm, globalObject);
}

void JSSpeechSynthesis::destroy(JSC::JSCell* cell)
{
    JSSpeechSynthesis* thisObject = static_cast<JSSpeechSynthesis*>(cell);
    thisObject->JSSpeechSynthesis::~JSSpeechSynthesis();
}

template<> inline JSSpeechSynthesis* IDLAttribute<JSSpeechSynthesis>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSpeechSynthesis*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSSpeechSynthesis* IDLOperation<JSSpeechSynthesis>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSSpeechSynthesis*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsSpeechSynthesisPendingGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesis& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.pending());
    return result;
}

EncodedJSValue jsSpeechSynthesisPending(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesis>::get<jsSpeechSynthesisPendingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pending");
}

static inline JSValue jsSpeechSynthesisSpeakingGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesis& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.speaking());
    return result;
}

EncodedJSValue jsSpeechSynthesisSpeaking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesis>::get<jsSpeechSynthesisSpeakingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "speaking");
}

static inline JSValue jsSpeechSynthesisPausedGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesis& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.paused());
    return result;
}

EncodedJSValue jsSpeechSynthesisPaused(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesis>::get<jsSpeechSynthesisPausedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "paused");
}

static inline JSC::EncodedJSValue jsSpeechSynthesisPrototypeFunctionSpeakBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSpeechSynthesis>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto utterance = convert<IDLInterface<SpeechSynthesisUtterance>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "utterance", "SpeechSynthesis", "speak", "SpeechSynthesisUtterance"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.speak(*utterance);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionSpeak(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSpeechSynthesis>::call<jsSpeechSynthesisPrototypeFunctionSpeakBody>(*lexicalGlobalObject, *callFrame, "speak");
}

static inline JSC::EncodedJSValue jsSpeechSynthesisPrototypeFunctionCancelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSpeechSynthesis>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.cancel();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionCancel(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSpeechSynthesis>::call<jsSpeechSynthesisPrototypeFunctionCancelBody>(*lexicalGlobalObject, *callFrame, "cancel");
}

static inline JSC::EncodedJSValue jsSpeechSynthesisPrototypeFunctionPauseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSpeechSynthesis>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.pause();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionPause(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSpeechSynthesis>::call<jsSpeechSynthesisPrototypeFunctionPauseBody>(*lexicalGlobalObject, *callFrame, "pause");
}

static inline JSC::EncodedJSValue jsSpeechSynthesisPrototypeFunctionResumeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSpeechSynthesis>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.resume();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionResume(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSpeechSynthesis>::call<jsSpeechSynthesisPrototypeFunctionResumeBody>(*lexicalGlobalObject, *callFrame, "resume");
}

static inline JSC::EncodedJSValue jsSpeechSynthesisPrototypeFunctionGetVoicesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSpeechSynthesis>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<SpeechSynthesisVoice>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getVoices()));
}

EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionGetVoices(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSpeechSynthesis>::call<jsSpeechSynthesisPrototypeFunctionGetVoicesBody>(*lexicalGlobalObject, *callFrame, "getVoices");
}

void JSSpeechSynthesis::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSpeechSynthesis*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSpeechSynthesisOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSpeechSynthesisOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSpeechSynthesis = static_cast<JSSpeechSynthesis*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSpeechSynthesis->wrapped(), jsSpeechSynthesis);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechSynthesis@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15SpeechSynthesisE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SpeechSynthesis>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7SpeechSynthesis@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15SpeechSynthesisE[2];
#endif

    // If this fails SpeechSynthesis does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<SpeechSynthesis>::value, "SpeechSynthesis is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // SpeechSynthesis has subclasses. If SpeechSynthesis has subclasses that get passed
    // to toJS() we currently require SpeechSynthesis you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<SpeechSynthesis>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SpeechSynthesis& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SpeechSynthesis* JSSpeechSynthesis::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSpeechSynthesis*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SPEECH_SYNTHESIS)
