/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesisUtterance.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSSpeechSynthesisVoice.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSpeechSynthesisUtteranceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceLang(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceLang(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceVoice(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceVoice(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceVolume(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceVolume(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtterancePitch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtterancePitch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceOnstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceOnstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceOnend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceOnend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceOnpause(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceOnpause(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceOnresume(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceOnresume(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceOnmark(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceOnmark(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSpeechSynthesisUtteranceOnboundary(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSpeechSynthesisUtteranceOnboundary(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSpeechSynthesisUtterancePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSpeechSynthesisUtterancePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSpeechSynthesisUtterancePrototype* ptr = new (NotNull, JSC::allocateCell<JSSpeechSynthesisUtterancePrototype>(vm.heap)) JSSpeechSynthesisUtterancePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSpeechSynthesisUtterancePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechSynthesisUtterancePrototype, JSSpeechSynthesisUtterancePrototype::Base);

using JSSpeechSynthesisUtteranceConstructor = JSDOMConstructor<JSSpeechSynthesisUtterance>;

template<> EncodedJSValue JSC_HOST_CALL JSSpeechSynthesisUtteranceConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSSpeechSynthesisUtteranceConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "SpeechSynthesisUtterance");
    auto text = callFrame->argument(0).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = SpeechSynthesisUtterance::create(*context, WTFMove(text));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<SpeechSynthesisUtterance>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSSpeechSynthesisUtteranceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSSpeechSynthesisUtteranceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSpeechSynthesisUtterance::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SpeechSynthesisUtterance"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSpeechSynthesisUtteranceConstructor::s_info = { "SpeechSynthesisUtterance", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesisUtteranceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSpeechSynthesisUtterancePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceConstructor) } },
    { "text", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceText) } },
    { "lang", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceLang), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceLang) } },
    { "voice", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceVoice), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceVoice) } },
    { "volume", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceVolume), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceVolume) } },
    { "rate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceRate) } },
    { "pitch", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtterancePitch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtterancePitch) } },
    { "onstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceOnstart) } },
    { "onend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceOnend) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceOnerror) } },
    { "onpause", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnpause), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceOnpause) } },
    { "onresume", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnresume), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceOnresume) } },
    { "onmark", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnmark), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceOnmark) } },
    { "onboundary", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnboundary), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSpeechSynthesisUtteranceOnboundary) } },
};

const ClassInfo JSSpeechSynthesisUtterancePrototype::s_info = { "SpeechSynthesisUtterancePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesisUtterancePrototype) };

void JSSpeechSynthesisUtterancePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSpeechSynthesisUtterance::info(), JSSpeechSynthesisUtterancePrototypeTableValues, *this);
}

const ClassInfo JSSpeechSynthesisUtterance::s_info = { "SpeechSynthesisUtterance", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesisUtterance) };

JSSpeechSynthesisUtterance::JSSpeechSynthesisUtterance(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SpeechSynthesisUtterance>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSSpeechSynthesisUtterance::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SpeechSynthesisUtterance>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSpeechSynthesisUtterance::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSpeechSynthesisUtterancePrototype::create(vm, &globalObject, JSSpeechSynthesisUtterancePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSSpeechSynthesisUtterance::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSpeechSynthesisUtterance>(vm, globalObject);
}

JSValue JSSpeechSynthesisUtterance::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSpeechSynthesisUtteranceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSpeechSynthesisUtterance* IDLAttribute<JSSpeechSynthesisUtterance>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSpeechSynthesisUtterance*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSpeechSynthesisUtteranceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSpeechSynthesisUtterancePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSpeechSynthesisUtterance::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSpeechSynthesisUtteranceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSpeechSynthesisUtterancePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSpeechSynthesisUtteranceTextGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.text());
    return result;
}

EncodedJSValue jsSpeechSynthesisUtteranceText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "text");
}

static inline bool setJSSpeechSynthesisUtteranceTextSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setText(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSpeechSynthesisUtteranceText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, "text");
}

static inline JSValue jsSpeechSynthesisUtteranceLangGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.lang());
    return result;
}

EncodedJSValue jsSpeechSynthesisUtteranceLang(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceLangGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lang");
}

static inline bool setJSSpeechSynthesisUtteranceLangSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLang(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSpeechSynthesisUtteranceLang(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceLangSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lang");
}

static inline JSValue jsSpeechSynthesisUtteranceVoiceGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<SpeechSynthesisVoice>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.voice());
    return result;
}

EncodedJSValue jsSpeechSynthesisUtteranceVoice(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceVoiceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "voice");
}

static inline bool setJSSpeechSynthesisUtteranceVoiceSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<SpeechSynthesisVoice>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "SpeechSynthesisUtterance", "voice", "SpeechSynthesisVoice"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setVoice(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSpeechSynthesisUtteranceVoice(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceVoiceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "voice");
}

static inline JSValue jsSpeechSynthesisUtteranceVolumeGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.volume());
    return result;
}

EncodedJSValue jsSpeechSynthesisUtteranceVolume(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceVolumeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "volume");
}

static inline bool setJSSpeechSynthesisUtteranceVolumeSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setVolume(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSpeechSynthesisUtteranceVolume(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceVolumeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "volume");
}

static inline JSValue jsSpeechSynthesisUtteranceRateGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.rate());
    return result;
}

EncodedJSValue jsSpeechSynthesisUtteranceRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rate");
}

static inline bool setJSSpeechSynthesisUtteranceRateSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setRate(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSpeechSynthesisUtteranceRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "rate");
}

static inline JSValue jsSpeechSynthesisUtterancePitchGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.pitch());
    return result;
}

EncodedJSValue jsSpeechSynthesisUtterancePitch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtterancePitchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pitch");
}

static inline bool setJSSpeechSynthesisUtterancePitchSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPitch(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSpeechSynthesisUtterancePitch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtterancePitchSetter>(*lexicalGlobalObject, thisValue, encodedValue, "pitch");
}

static inline JSValue jsSpeechSynthesisUtteranceOnstartGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().startEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSpeechSynthesisUtteranceOnstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceOnstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onstart");
}

static inline bool setJSSpeechSynthesisUtteranceOnstartSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().startEvent, value);
    return true;
}

bool setJSSpeechSynthesisUtteranceOnstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceOnstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onstart");
}

static inline JSValue jsSpeechSynthesisUtteranceOnendGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSpeechSynthesisUtteranceOnend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceOnendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onend");
}

static inline bool setJSSpeechSynthesisUtteranceOnendSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().endEvent, value);
    return true;
}

bool setJSSpeechSynthesisUtteranceOnend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceOnendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onend");
}

static inline JSValue jsSpeechSynthesisUtteranceOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSpeechSynthesisUtteranceOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSSpeechSynthesisUtteranceOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSSpeechSynthesisUtteranceOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsSpeechSynthesisUtteranceOnpauseGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pauseEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSpeechSynthesisUtteranceOnpause(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceOnpauseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpause");
}

static inline bool setJSSpeechSynthesisUtteranceOnpauseSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pauseEvent, value);
    return true;
}

bool setJSSpeechSynthesisUtteranceOnpause(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceOnpauseSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpause");
}

static inline JSValue jsSpeechSynthesisUtteranceOnresumeGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resumeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSpeechSynthesisUtteranceOnresume(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceOnresumeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onresume");
}

static inline bool setJSSpeechSynthesisUtteranceOnresumeSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resumeEvent, value);
    return true;
}

bool setJSSpeechSynthesisUtteranceOnresume(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceOnresumeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onresume");
}

static inline JSValue jsSpeechSynthesisUtteranceOnmarkGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().markEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSpeechSynthesisUtteranceOnmark(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceOnmarkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmark");
}

static inline bool setJSSpeechSynthesisUtteranceOnmarkSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().markEvent, value);
    return true;
}

bool setJSSpeechSynthesisUtteranceOnmark(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceOnmarkSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmark");
}

static inline JSValue jsSpeechSynthesisUtteranceOnboundaryGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().boundaryEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsSpeechSynthesisUtteranceOnboundary(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::get<jsSpeechSynthesisUtteranceOnboundaryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onboundary");
}

static inline bool setJSSpeechSynthesisUtteranceOnboundarySetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisUtterance& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().boundaryEvent, value);
    return true;
}

bool setJSSpeechSynthesisUtteranceOnboundary(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSpeechSynthesisUtterance>::set<setJSSpeechSynthesisUtteranceOnboundarySetter>(*lexicalGlobalObject, thisValue, encodedValue, "onboundary");
}

void JSSpeechSynthesisUtterance::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSpeechSynthesisUtterance*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechSynthesisUtterance@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24SpeechSynthesisUtteranceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SpeechSynthesisUtterance>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7SpeechSynthesisUtterance@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore24SpeechSynthesisUtteranceE[2];
#endif

    // If this fails SpeechSynthesisUtterance does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<SpeechSynthesisUtterance>::value, "SpeechSynthesisUtterance is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // SpeechSynthesisUtterance has subclasses. If SpeechSynthesisUtterance has subclasses that get passed
    // to toJS() we currently require SpeechSynthesisUtterance you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<SpeechSynthesisUtterance>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SpeechSynthesisUtterance& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SpeechSynthesisUtterance* JSSpeechSynthesisUtterance::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSpeechSynthesisUtterance*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SPEECH_SYNTHESIS)
