/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesisVoice.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSpeechSynthesisVoiceVoiceURI(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSpeechSynthesisVoiceName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSpeechSynthesisVoiceLang(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSpeechSynthesisVoiceLocalService(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSpeechSynthesisVoiceDefault(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSpeechSynthesisVoicePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSpeechSynthesisVoicePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSpeechSynthesisVoicePrototype* ptr = new (NotNull, JSC::allocateCell<JSSpeechSynthesisVoicePrototype>(vm.heap)) JSSpeechSynthesisVoicePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSpeechSynthesisVoicePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechSynthesisVoicePrototype, JSSpeechSynthesisVoicePrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSSpeechSynthesisVoicePrototypeTableValues[] =
{
    { "voiceURI", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceVoiceURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lang", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceLang), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "localService", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceLocalService), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "default", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceDefault), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSpeechSynthesisVoicePrototype::s_info = { "SpeechSynthesisVoicePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesisVoicePrototype) };

void JSSpeechSynthesisVoicePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSpeechSynthesisVoice::info(), JSSpeechSynthesisVoicePrototypeTableValues, *this);
}

const ClassInfo JSSpeechSynthesisVoice::s_info = { "SpeechSynthesisVoice", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesisVoice) };

JSSpeechSynthesisVoice::JSSpeechSynthesisVoice(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SpeechSynthesisVoice>&& impl)
    : JSDOMWrapper<SpeechSynthesisVoice>(structure, globalObject, WTFMove(impl))
{
}

void JSSpeechSynthesisVoice::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SpeechSynthesisVoice>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSpeechSynthesisVoice::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSpeechSynthesisVoicePrototype::create(vm, &globalObject, JSSpeechSynthesisVoicePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSpeechSynthesisVoice::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSpeechSynthesisVoice>(vm, globalObject);
}

void JSSpeechSynthesisVoice::destroy(JSC::JSCell* cell)
{
    JSSpeechSynthesisVoice* thisObject = static_cast<JSSpeechSynthesisVoice*>(cell);
    thisObject->JSSpeechSynthesisVoice::~JSSpeechSynthesisVoice();
}

template<> inline JSSpeechSynthesisVoice* IDLAttribute<JSSpeechSynthesisVoice>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSpeechSynthesisVoice*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

static inline JSValue jsSpeechSynthesisVoiceVoiceURIGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisVoice& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.voiceURI());
    return result;
}

EncodedJSValue jsSpeechSynthesisVoiceVoiceURI(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisVoice>::get<jsSpeechSynthesisVoiceVoiceURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "voiceURI");
}

static inline JSValue jsSpeechSynthesisVoiceNameGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisVoice& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name());
    return result;
}

EncodedJSValue jsSpeechSynthesisVoiceName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisVoice>::get<jsSpeechSynthesisVoiceNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline JSValue jsSpeechSynthesisVoiceLangGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisVoice& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.lang());
    return result;
}

EncodedJSValue jsSpeechSynthesisVoiceLang(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisVoice>::get<jsSpeechSynthesisVoiceLangGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lang");
}

static inline JSValue jsSpeechSynthesisVoiceLocalServiceGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisVoice& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.localService());
    return result;
}

EncodedJSValue jsSpeechSynthesisVoiceLocalService(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisVoice>::get<jsSpeechSynthesisVoiceLocalServiceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "localService");
}

static inline JSValue jsSpeechSynthesisVoiceDefaultGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisVoice& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isDefault());
    return result;
}

EncodedJSValue jsSpeechSynthesisVoiceDefault(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSpeechSynthesisVoice>::get<jsSpeechSynthesisVoiceDefaultGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "default");
}

void JSSpeechSynthesisVoice::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSpeechSynthesisVoice*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSpeechSynthesisVoiceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSpeechSynthesisVoiceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSpeechSynthesisVoice = static_cast<JSSpeechSynthesisVoice*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSpeechSynthesisVoice->wrapped(), jsSpeechSynthesisVoice);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechSynthesisVoice@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20SpeechSynthesisVoiceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SpeechSynthesisVoice>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7SpeechSynthesisVoice@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore20SpeechSynthesisVoiceE[2];
#endif

    // If this fails SpeechSynthesisVoice does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<SpeechSynthesisVoice>::value, "SpeechSynthesisVoice is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // SpeechSynthesisVoice has subclasses. If SpeechSynthesisVoice has subclasses that get passed
    // to toJS() we currently require SpeechSynthesisVoice you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<SpeechSynthesisVoice>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SpeechSynthesisVoice& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SpeechSynthesisVoice* JSSpeechSynthesisVoice::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSpeechSynthesisVoice*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SPEECH_SYNTHESIS)
