/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStaticRange.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> StaticRange::Init convertDictionary<StaticRange::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    StaticRange::Init result;
    JSValue endContainerValue;
    if (isNullOrUndefined)
        endContainerValue = jsUndefined();
    else {
        endContainerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endContainer"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!endContainerValue.isUndefined()) {
        result.endContainer = convert<IDLInterface<Node>>(lexicalGlobalObject, endContainerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "endContainer", "StaticRangeInit", "Node");
        return { };
    }
    JSValue endOffsetValue;
    if (isNullOrUndefined)
        endOffsetValue = jsUndefined();
    else {
        endOffsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endOffset"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!endOffsetValue.isUndefined()) {
        result.endOffset = convert<IDLUnsignedLong>(lexicalGlobalObject, endOffsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "endOffset", "StaticRangeInit", "unsigned long");
        return { };
    }
    JSValue startContainerValue;
    if (isNullOrUndefined)
        startContainerValue = jsUndefined();
    else {
        startContainerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "startContainer"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!startContainerValue.isUndefined()) {
        result.startContainer = convert<IDLInterface<Node>>(lexicalGlobalObject, startContainerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "startContainer", "StaticRangeInit", "Node");
        return { };
    }
    JSValue startOffsetValue;
    if (isNullOrUndefined)
        startOffsetValue = jsUndefined();
    else {
        startOffsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "startOffset"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!startOffsetValue.isUndefined()) {
        result.startOffset = convert<IDLUnsignedLong>(lexicalGlobalObject, startOffsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "startOffset", "StaticRangeInit", "unsigned long");
        return { };
    }
    return result;
}

// Attributes

JSC::EncodedJSValue jsStaticRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSStaticRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsStaticRangeStartOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStaticRangeEndOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStaticRangeStartContainer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStaticRangeEndContainer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStaticRangeCollapsed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSStaticRangePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStaticRangePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStaticRangePrototype* ptr = new (NotNull, JSC::allocateCell<JSStaticRangePrototype>(vm.heap)) JSStaticRangePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStaticRangePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStaticRangePrototype, JSStaticRangePrototype::Base);

using JSStaticRangeConstructor = JSDOMConstructor<JSStaticRange>;

template<> EncodedJSValue JSC_HOST_CALL JSStaticRangeConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSStaticRangeConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto staticRangeInitDict = convert<IDLDictionary<StaticRange::Init>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = StaticRange::create(WTFMove(staticRangeInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<StaticRange>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSStaticRangeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSStaticRangeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSStaticRange::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("StaticRange"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSStaticRangeConstructor::s_info = { "StaticRange", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStaticRangeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSStaticRangePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStaticRangeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSStaticRangeConstructor) } },
    { "startOffset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStaticRangeStartOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "endOffset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStaticRangeEndOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "startContainer", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStaticRangeStartContainer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "endContainer", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStaticRangeEndContainer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "collapsed", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStaticRangeCollapsed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSStaticRangePrototype::s_info = { "StaticRangePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStaticRangePrototype) };

void JSStaticRangePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStaticRange::info(), JSStaticRangePrototypeTableValues, *this);
}

const ClassInfo JSStaticRange::s_info = { "StaticRange", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStaticRange) };

JSStaticRange::JSStaticRange(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StaticRange>&& impl)
    : JSDOMWrapper<StaticRange>(structure, globalObject, WTFMove(impl))
{
}

void JSStaticRange::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, StaticRange>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSStaticRange::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSStaticRangePrototype::create(vm, &globalObject, JSStaticRangePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSStaticRange::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStaticRange>(vm, globalObject);
}

JSValue JSStaticRange::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStaticRangeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSStaticRange::destroy(JSC::JSCell* cell)
{
    JSStaticRange* thisObject = static_cast<JSStaticRange*>(cell);
    thisObject->JSStaticRange::~JSStaticRange();
}

template<> inline JSStaticRange* IDLAttribute<JSStaticRange>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSStaticRange*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsStaticRangeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStaticRangePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStaticRange::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSStaticRangeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStaticRangePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsStaticRangeStartOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSStaticRange& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.startOffset());
    return result;
}

EncodedJSValue jsStaticRangeStartOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStaticRange>::get<jsStaticRangeStartOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "startOffset");
}

static inline JSValue jsStaticRangeEndOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSStaticRange& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.endOffset());
    return result;
}

EncodedJSValue jsStaticRangeEndOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStaticRange>::get<jsStaticRangeEndOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "endOffset");
}

static inline JSValue jsStaticRangeStartContainerGetter(JSGlobalObject& lexicalGlobalObject, JSStaticRange& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.startContainer());
    return result;
}

EncodedJSValue jsStaticRangeStartContainer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStaticRange>::get<jsStaticRangeStartContainerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "startContainer");
}

static inline JSValue jsStaticRangeEndContainerGetter(JSGlobalObject& lexicalGlobalObject, JSStaticRange& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.endContainer());
    return result;
}

EncodedJSValue jsStaticRangeEndContainer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStaticRange>::get<jsStaticRangeEndContainerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "endContainer");
}

static inline JSValue jsStaticRangeCollapsedGetter(JSGlobalObject& lexicalGlobalObject, JSStaticRange& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.collapsed());
    return result;
}

EncodedJSValue jsStaticRangeCollapsed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStaticRange>::get<jsStaticRangeCollapsedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "collapsed");
}

void JSStaticRange::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStaticRange*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSStaticRangeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSStaticRangeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsStaticRange = static_cast<JSStaticRange*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsStaticRange->wrapped(), jsStaticRange);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StaticRange>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to StaticRange.
    static_assert(!std::is_polymorphic<StaticRange>::value, "StaticRange is polymorphic but the IDL claims it is not");
    return createWrapper<StaticRange>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StaticRange& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

StaticRange* JSStaticRange::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSStaticRange*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
