/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStorageEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSStorage.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> StorageEvent::Init convertDictionary<StorageEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    StorageEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue keyValue;
    if (isNullOrUndefined)
        keyValue = jsUndefined();
    else {
        keyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "key"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!keyValue.isUndefined()) {
        result.key = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, keyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.key = String();
    JSValue newValueValue;
    if (isNullOrUndefined)
        newValueValue = jsUndefined();
    else {
        newValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "newValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!newValueValue.isUndefined()) {
        result.newValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, newValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.newValue = String();
    JSValue oldValueValue;
    if (isNullOrUndefined)
        oldValueValue = jsUndefined();
    else {
        oldValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "oldValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!oldValueValue.isUndefined()) {
        result.oldValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, oldValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.oldValue = String();
    JSValue storageAreaValue;
    if (isNullOrUndefined)
        storageAreaValue = jsUndefined();
    else {
        storageAreaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "storageArea"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!storageAreaValue.isUndefined()) {
        result.storageArea = convert<IDLNullable<IDLInterface<Storage>>>(lexicalGlobalObject, storageAreaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.storageArea = nullptr;
    JSValue urlValue;
    if (isNullOrUndefined)
        urlValue = jsUndefined();
    else {
        urlValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "url"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!urlValue.isUndefined()) {
        result.url = convert<IDLUSVString>(lexicalGlobalObject, urlValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.url = emptyString();
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsStorageEventPrototypeFunctionInitStorageEvent(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsStorageEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSStorageEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsStorageEventKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageEventOldValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageEventNewValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageEventUrl(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageEventStorageArea(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSStorageEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStorageEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStorageEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSStorageEventPrototype>(vm.heap)) JSStorageEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStorageEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStorageEventPrototype, JSStorageEventPrototype::Base);

using JSStorageEventConstructor = JSDOMConstructor<JSStorageEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSStorageEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSStorageEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<StorageEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = StorageEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<StorageEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSStorageEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSStorageEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSStorageEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("StorageEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSStorageEventConstructor::s_info = { "StorageEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSStorageEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSStorageEventConstructor) } },
    { "key", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "oldValue", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventOldValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "newValue", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventNewValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "url", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventUrl), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "storageArea", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventStorageArea), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initStorageEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsStorageEventPrototypeFunctionInitStorageEvent), (intptr_t) (0) } },
};

const ClassInfo JSStorageEventPrototype::s_info = { "StorageEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageEventPrototype) };

void JSStorageEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStorageEvent::info(), JSStorageEventPrototypeTableValues, *this);
}

const ClassInfo JSStorageEvent::s_info = { "StorageEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageEvent) };

JSStorageEvent::JSStorageEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StorageEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSStorageEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, StorageEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSStorageEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSStorageEventPrototype::create(vm, &globalObject, JSStorageEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSStorageEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStorageEvent>(vm, globalObject);
}

JSValue JSStorageEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStorageEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSStorageEvent* IDLAttribute<JSStorageEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSStorageEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSStorageEvent* IDLOperation<JSStorageEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSStorageEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsStorageEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStorageEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStorageEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSStorageEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStorageEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsStorageEventKeyGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.key());
    return result;
}

EncodedJSValue jsStorageEventKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEventKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "key");
}

static inline JSValue jsStorageEventOldValueGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.oldValue());
    return result;
}

EncodedJSValue jsStorageEventOldValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEventOldValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oldValue");
}

static inline JSValue jsStorageEventNewValueGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.newValue());
    return result;
}

EncodedJSValue jsStorageEventNewValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEventNewValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "newValue");
}

static inline JSValue jsStorageEventUrlGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url());
    return result;
}

EncodedJSValue jsStorageEventUrl(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEventUrlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "url");
}

static inline JSValue jsStorageEventStorageAreaGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Storage>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.storageArea());
    return result;
}

EncodedJSValue jsStorageEventStorageArea(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEventStorageAreaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "storageArea");
}

static inline JSC::EncodedJSValue jsStorageEventPrototypeFunctionInitStorageEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStorageEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto typeArg = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto canBubbleArg = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cancelableArg = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto keyArg = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto oldValueArg = callFrame->argument(4).isUndefined() ? String() : convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto newValueArg = callFrame->argument(5).isUndefined() ? String() : convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto urlArg = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->argument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto storageAreaArg = convert<IDLNullable<IDLInterface<Storage>>>(*lexicalGlobalObject, callFrame->argument(7), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 7, "storageAreaArg", "StorageEvent", "initStorageEvent", "Storage"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.initStorageEvent(WTFMove(typeArg), WTFMove(canBubbleArg), WTFMove(cancelableArg), WTFMove(keyArg), WTFMove(oldValueArg), WTFMove(newValueArg), WTFMove(urlArg), WTFMove(storageAreaArg));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsStorageEventPrototypeFunctionInitStorageEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSStorageEvent>::call<jsStorageEventPrototypeFunctionInitStorageEventBody>(*lexicalGlobalObject, *callFrame, "initStorageEvent");
}

void JSStorageEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStorageEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7StorageEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12StorageEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StorageEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7StorageEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12StorageEventE[2];
#endif

    // If this fails StorageEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<StorageEvent>::value, "StorageEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // StorageEvent has subclasses. If StorageEvent has subclasses that get passed
    // to toJS() we currently require StorageEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<StorageEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StorageEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
