/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStringCallback.h"

#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "ScriptExecutionContext.h"


namespace WebCore {
using namespace JSC;

JSStringCallback::JSStringCallback(JSObject* callback, JSDOMGlobalObject* globalObject)
    : StringCallback(globalObject->scriptExecutionContext())
    , m_data(new JSCallbackDataStrong(callback, globalObject, this))
{
}

JSStringCallback::~JSStringCallback()
{
    ScriptExecutionContext* context = scriptExecutionContext();
    // When the context is destroyed, all tasks with a reference to a callback
    // should be deleted. So if the context is 0, we are on the context thread.
    if (!context || context->isContextThread())
        delete m_data;
    else
        context->postTask(DeleteCallbackDataTask(m_data));
#ifndef NDEBUG
    m_data = nullptr;
#endif
}

CallbackResult<typename IDLVoid::ImplementationType> JSStringCallback::handleEvent(typename IDLDOMString::ParameterType data)
{
    if (!canInvokeCallback())
        return CallbackResultType::UnableToExecute;

    Ref<JSStringCallback> protectedThis(*this);

    auto& globalObject = *m_data->globalObject();
    auto& vm = globalObject.vm();

    JSLockHolder lock(vm);
    auto& lexicalGlobalObject = globalObject;
    JSValue thisValue = jsUndefined();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLDOMString>(lexicalGlobalObject, data));
    ASSERT(!args.hasOverflowed());

    NakedPtr<JSC::Exception> returnedException;
    m_data->invokeCallback(thisValue, args, JSCallbackData::CallbackType::Function, Identifier(), returnedException);
    if (returnedException) {
        reportException(&lexicalGlobalObject, returnedException);
        return CallbackResultType::ExceptionThrown;
     }

    return { };
}

JSC::JSValue toJS(StringCallback& impl)
{
    if (!static_cast<JSStringCallback&>(impl).callbackData())
        return jsNull();

    return static_cast<JSStringCallback&>(impl).callbackData()->callback();
}

} // namespace WebCore
