/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_TYPED_OM)

#include "JSStylePropertyMapReadOnly.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSTypedOMCSSStyleValue.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsStylePropertyMapReadOnlyPrototypeFunctionGet(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsStylePropertyMapReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSStylePropertyMapReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSStylePropertyMapReadOnlyPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStylePropertyMapReadOnlyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStylePropertyMapReadOnlyPrototype* ptr = new (NotNull, JSC::allocateCell<JSStylePropertyMapReadOnlyPrototype>(vm.heap)) JSStylePropertyMapReadOnlyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStylePropertyMapReadOnlyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStylePropertyMapReadOnlyPrototype, JSStylePropertyMapReadOnlyPrototype::Base);

using JSStylePropertyMapReadOnlyConstructor = JSDOMConstructorNotConstructable<JSStylePropertyMapReadOnly>;

template<> JSValue JSStylePropertyMapReadOnlyConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSStylePropertyMapReadOnlyConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSStylePropertyMapReadOnly::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("StylePropertyMapReadOnly"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSStylePropertyMapReadOnlyConstructor::s_info = { "StylePropertyMapReadOnly", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStylePropertyMapReadOnlyConstructor) };

/* Hash table for prototype */

static const HashTableValue JSStylePropertyMapReadOnlyPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStylePropertyMapReadOnlyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSStylePropertyMapReadOnlyConstructor) } },
    { "get", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsStylePropertyMapReadOnlyPrototypeFunctionGet), (intptr_t) (1) } },
};

const ClassInfo JSStylePropertyMapReadOnlyPrototype::s_info = { "StylePropertyMapReadOnlyPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStylePropertyMapReadOnlyPrototype) };

void JSStylePropertyMapReadOnlyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStylePropertyMapReadOnly::info(), JSStylePropertyMapReadOnlyPrototypeTableValues, *this);
}

const ClassInfo JSStylePropertyMapReadOnly::s_info = { "StylePropertyMapReadOnly", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStylePropertyMapReadOnly) };

JSStylePropertyMapReadOnly::JSStylePropertyMapReadOnly(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StylePropertyMapReadOnly>&& impl)
    : JSDOMWrapper<StylePropertyMapReadOnly>(structure, globalObject, WTFMove(impl))
{
}

void JSStylePropertyMapReadOnly::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, StylePropertyMapReadOnly>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSStylePropertyMapReadOnly::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSStylePropertyMapReadOnlyPrototype::create(vm, &globalObject, JSStylePropertyMapReadOnlyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSStylePropertyMapReadOnly::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStylePropertyMapReadOnly>(vm, globalObject);
}

JSValue JSStylePropertyMapReadOnly::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStylePropertyMapReadOnlyConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSStylePropertyMapReadOnly::destroy(JSC::JSCell* cell)
{
    JSStylePropertyMapReadOnly* thisObject = static_cast<JSStylePropertyMapReadOnly*>(cell);
    thisObject->JSStylePropertyMapReadOnly::~JSStylePropertyMapReadOnly();
}

template<> inline JSStylePropertyMapReadOnly* IDLOperation<JSStylePropertyMapReadOnly>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSStylePropertyMapReadOnly*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsStylePropertyMapReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStylePropertyMapReadOnlyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStylePropertyMapReadOnly::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSStylePropertyMapReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStylePropertyMapReadOnlyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsStylePropertyMapReadOnlyPrototypeFunctionGetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStylePropertyMapReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto property = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<TypedOMCSSStyleValue>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.get(WTFMove(property))));
}

EncodedJSValue JSC_HOST_CALL jsStylePropertyMapReadOnlyPrototypeFunctionGet(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSStylePropertyMapReadOnly>::call<jsStylePropertyMapReadOnlyPrototypeFunctionGetBody>(*lexicalGlobalObject, *callFrame, "get");
}

void JSStylePropertyMapReadOnly::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStylePropertyMapReadOnly*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSStylePropertyMapReadOnlyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSStylePropertyMapReadOnlyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsStylePropertyMapReadOnly = static_cast<JSStylePropertyMapReadOnly*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsStylePropertyMapReadOnly->wrapped(), jsStylePropertyMapReadOnly);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StylePropertyMapReadOnly>&& impl)
{
    return createWrapper<StylePropertyMapReadOnly>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StylePropertyMapReadOnly& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

StylePropertyMapReadOnly* JSStylePropertyMapReadOnly::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSStylePropertyMapReadOnly*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(CSS_TYPED_OM)
