/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTextDecoder.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

template<> TextDecoder::Options convertDictionary<TextDecoder::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    TextDecoder::Options result;
    JSValue fatalValue;
    if (isNullOrUndefined)
        fatalValue = jsUndefined();
    else {
        fatalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fatal"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fatalValue.isUndefined()) {
        result.fatal = convert<IDLBoolean>(lexicalGlobalObject, fatalValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.fatal = false;
    JSValue ignoreBOMValue;
    if (isNullOrUndefined)
        ignoreBOMValue = jsUndefined();
    else {
        ignoreBOMValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignoreBOM"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ignoreBOMValue.isUndefined()) {
        result.ignoreBOM = convert<IDLBoolean>(lexicalGlobalObject, ignoreBOMValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ignoreBOM = false;
    return result;
}

template<> TextDecoder::DecodeOptions convertDictionary<TextDecoder::DecodeOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    TextDecoder::DecodeOptions result;
    JSValue streamValue;
    if (isNullOrUndefined)
        streamValue = jsUndefined();
    else {
        streamValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stream"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!streamValue.isUndefined()) {
        result.stream = convert<IDLBoolean>(lexicalGlobalObject, streamValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stream = false;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTextDecoderPrototypeFunctionDecode(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsTextDecoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTextDecoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextDecoderEncoding(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextDecoderFatal(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextDecoderIgnoreBOM(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSTextDecoderPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTextDecoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextDecoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextDecoderPrototype>(vm.heap)) JSTextDecoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextDecoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextDecoderPrototype, JSTextDecoderPrototype::Base);

using JSTextDecoderConstructor = JSDOMConstructor<JSTextDecoder>;

template<> EncodedJSValue JSC_HOST_CALL JSTextDecoderConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSTextDecoderConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto label = callFrame->argument(0).isUndefined() ? "utf-8"_s : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<TextDecoder::Options>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = TextDecoder::create(WTFMove(label), WTFMove(options));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<TextDecoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSTextDecoderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTextDecoderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTextDecoder::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("TextDecoder"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTextDecoderConstructor::s_info = { "TextDecoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextDecoderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTextDecoderPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextDecoderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextDecoderConstructor) } },
    { "encoding", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextDecoderEncoding), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "fatal", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextDecoderFatal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ignoreBOM", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextDecoderIgnoreBOM), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "decode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTextDecoderPrototypeFunctionDecode), (intptr_t) (0) } },
};

const ClassInfo JSTextDecoderPrototype::s_info = { "TextDecoderPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextDecoderPrototype) };

void JSTextDecoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextDecoder::info(), JSTextDecoderPrototypeTableValues, *this);
}

const ClassInfo JSTextDecoder::s_info = { "TextDecoder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextDecoder) };

JSTextDecoder::JSTextDecoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextDecoder>&& impl)
    : JSDOMWrapper<TextDecoder>(structure, globalObject, WTFMove(impl))
{
}

void JSTextDecoder::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TextDecoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTextDecoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTextDecoderPrototype::create(vm, &globalObject, JSTextDecoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSTextDecoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTextDecoder>(vm, globalObject);
}

JSValue JSTextDecoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextDecoderConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTextDecoder::destroy(JSC::JSCell* cell)
{
    JSTextDecoder* thisObject = static_cast<JSTextDecoder*>(cell);
    thisObject->JSTextDecoder::~JSTextDecoder();
}

template<> inline JSTextDecoder* IDLAttribute<JSTextDecoder>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSTextDecoder*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSTextDecoder* IDLOperation<JSTextDecoder>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSTextDecoder*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsTextDecoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextDecoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTextDecoder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTextDecoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextDecoderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsTextDecoderEncodingGetter(JSGlobalObject& lexicalGlobalObject, JSTextDecoder& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.encoding());
    return result;
}

EncodedJSValue jsTextDecoderEncoding(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextDecoder>::get<jsTextDecoderEncodingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "encoding");
}

static inline JSValue jsTextDecoderFatalGetter(JSGlobalObject& lexicalGlobalObject, JSTextDecoder& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.fatal());
    return result;
}

EncodedJSValue jsTextDecoderFatal(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextDecoder>::get<jsTextDecoderFatalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fatal");
}

static inline JSValue jsTextDecoderIgnoreBOMGetter(JSGlobalObject& lexicalGlobalObject, JSTextDecoder& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ignoreBOM());
    return result;
}

EncodedJSValue jsTextDecoderIgnoreBOM(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextDecoder>::get<jsTextDecoderIgnoreBOMGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ignoreBOM");
}

static inline JSC::EncodedJSValue jsTextDecoderPrototypeFunctionDecodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextDecoder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto input = callFrame->argument(0).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<TextDecoder::DecodeOptions>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.decode(WTFMove(input), WTFMove(options))));
}

EncodedJSValue JSC_HOST_CALL jsTextDecoderPrototypeFunctionDecode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTextDecoder>::call<jsTextDecoderPrototypeFunctionDecodeBody>(*lexicalGlobalObject, *callFrame, "decode");
}

void JSTextDecoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTextDecoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSTextDecoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTextDecoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextDecoder = static_cast<JSTextDecoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextDecoder->wrapped(), jsTextDecoder);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TextDecoder>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TextDecoder.
    static_assert(!std::is_polymorphic<TextDecoder>::value, "TextDecoder is polymorphic but the IDL claims it is not");
    return createWrapper<TextDecoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TextDecoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TextDecoder* JSTextDecoder::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextDecoder*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
