/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSTextTrackCue.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocumentFragment.h"
#include "JSEventListener.h"
#include "JSTextTrack.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackCuePrototypeFunctionGetCueAsHTML(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsTextTrackCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTextTrackCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackCueTrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextTrackCueId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTextTrackCueId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackCueStartTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTextTrackCueStartTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackCueEndTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTextTrackCueEndTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackCuePauseOnExit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTextTrackCuePauseOnExit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackCueOnenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTextTrackCueOnenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackCueOnexit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTextTrackCueOnexit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTextTrackCuePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTextTrackCuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextTrackCuePrototype* ptr = new (NotNull, JSC::allocateCell<JSTextTrackCuePrototype>(vm.heap)) JSTextTrackCuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextTrackCuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextTrackCuePrototype, JSTextTrackCuePrototype::Base);

using JSTextTrackCueConstructor = JSDOMConstructor<JSTextTrackCue>;

template<> EncodedJSValue JSC_HOST_CALL JSTextTrackCueConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSTextTrackCueConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())->settings().genericCueAPIEnabled()) {
        throwTypeError(lexicalGlobalObject, throwScope, "Illegal constructor"_s);
        return JSValue::encode(jsNull());
    }
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "TextTrackCue");
    auto startTime = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endTime = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cueNode = convert<IDLInterface<DocumentFragment>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "cueNode", "TextTrackCue", nullptr, "DocumentFragment"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = TextTrackCue::create(*context, WTFMove(startTime), WTFMove(endTime), *cueNode);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<TextTrackCue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSTextTrackCueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSTextTrackCueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTextTrackCue::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("TextTrackCue"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    int constructorLength = 3;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settings().genericCueAPIEnabled())
        constructorLength = 0;
    putDirect(vm, vm.propertyNames->length, jsNumber(constructorLength), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTextTrackCueConstructor::s_info = { "TextTrackCue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackCueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTextTrackCuePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackCueConstructor) } },
    { "track", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueTrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackCueId) } },
    { "startTime", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueStartTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackCueStartTime) } },
    { "endTime", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueEndTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackCueEndTime) } },
    { "pauseOnExit", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCuePauseOnExit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackCuePauseOnExit) } },
    { "onenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueOnenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackCueOnenter) } },
    { "onexit", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueOnexit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackCueOnexit) } },
    { "getCueAsHTML", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTextTrackCuePrototypeFunctionGetCueAsHTML), (intptr_t) (0) } },
};

const ClassInfo JSTextTrackCuePrototype::s_info = { "TextTrackCuePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackCuePrototype) };

void JSTextTrackCuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextTrackCue::info(), JSTextTrackCuePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().genericCueAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("getCueAsHTML"), strlen("getCueAsHTML"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSTextTrackCue::s_info = { "TextTrackCue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackCue) };

JSTextTrackCue::JSTextTrackCue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextTrackCue>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSTextTrackCue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TextTrackCue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTextTrackCue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTextTrackCuePrototype::create(vm, &globalObject, JSTextTrackCuePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSTextTrackCue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTextTrackCue>(vm, globalObject);
}

JSValue JSTextTrackCue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextTrackCueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSTextTrackCue* IDLAttribute<JSTextTrackCue>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSTextTrackCue*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSTextTrackCue* IDLOperation<JSTextTrackCue>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSTextTrackCue*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsTextTrackCueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextTrackCuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTextTrackCue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTextTrackCueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextTrackCuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsTextTrackCueTrackGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TextTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.track());
    return result;
}

EncodedJSValue jsTextTrackCueTrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCueTrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "track");
}

static inline JSValue jsTextTrackCueIdGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsTextTrackCueId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCueIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline bool setJSTextTrackCueIdSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setId(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTextTrackCueId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCueIdSetter>(*lexicalGlobalObject, thisValue, encodedValue, "id");
}

static inline JSValue jsTextTrackCueStartTimeGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.startTime());
    return result;
}

EncodedJSValue jsTextTrackCueStartTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCueStartTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "startTime");
}

static inline bool setJSTextTrackCueStartTimeSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setStartTime(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTextTrackCueStartTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCueStartTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "startTime");
}

static inline JSValue jsTextTrackCueEndTimeGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.endTime());
    return result;
}

EncodedJSValue jsTextTrackCueEndTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCueEndTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "endTime");
}

static inline bool setJSTextTrackCueEndTimeSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setEndTime(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTextTrackCueEndTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCueEndTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "endTime");
}

static inline JSValue jsTextTrackCuePauseOnExitGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.pauseOnExit());
    return result;
}

EncodedJSValue jsTextTrackCuePauseOnExit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCuePauseOnExitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pauseOnExit");
}

static inline bool setJSTextTrackCuePauseOnExitSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPauseOnExit(WTFMove(nativeValue));
    });
    return true;
}

bool setJSTextTrackCuePauseOnExit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCuePauseOnExitSetter>(*lexicalGlobalObject, thisValue, encodedValue, "pauseOnExit");
}

static inline JSValue jsTextTrackCueOnenterGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().enterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsTextTrackCueOnenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCueOnenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onenter");
}

static inline bool setJSTextTrackCueOnenterSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().enterEvent, value);
    return true;
}

bool setJSTextTrackCueOnenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCueOnenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onenter");
}

static inline JSValue jsTextTrackCueOnexitGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().exitEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsTextTrackCueOnexit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCueOnexitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onexit");
}

static inline bool setJSTextTrackCueOnexitSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().exitEvent, value);
    return true;
}

bool setJSTextTrackCueOnexit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCueOnexitSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onexit");
}

static inline JSC::EncodedJSValue jsTextTrackCuePrototypeFunctionGetCueAsHTMLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextTrackCue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DocumentFragment>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getCueAsHTML()));
}

EncodedJSValue JSC_HOST_CALL jsTextTrackCuePrototypeFunctionGetCueAsHTML(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTextTrackCue>::call<jsTextTrackCuePrototypeFunctionGetCueAsHTMLBody>(*lexicalGlobalObject, *callFrame, "getCueAsHTML");
}

void JSTextTrackCue::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSTextTrackCue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSTextTrackCue::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSTextTrackCue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSTextTrackCue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTextTrackCue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSTextTrackCueOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextTrackCue = static_cast<JSTextTrackCue*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextTrackCue->wrapped(), jsTextTrackCue);
}

TextTrackCue* JSTextTrackCue::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextTrackCue*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
