/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(VIDEO_TRACK)

#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "TextTrackCue.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSTextTrackCue : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = TextTrackCue;
    static JSTextTrackCue* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<TextTrackCue>&& impl)
    {
        JSTextTrackCue* ptr = new (NotNull, JSC::allocateCell<JSTextTrackCue>(globalObject->vm().heap)) JSTextTrackCue(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static TextTrackCue* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);
    void visitAdditionalChildren(JSC::SlotVisitor&);

    static void visitOutputConstraints(JSCell*, JSC::SlotVisitor&);
    template<typename, JSC::SubspaceAccess> static JSC::CompleteSubspace* subspaceFor(JSC::VM& vm) { return outputConstraintSubspaceFor(vm); }
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    TextTrackCue& wrapped() const
    {
        return static_cast<TextTrackCue&>(Base::wrapped());
    }
protected:
    JSTextTrackCue(JSC::Structure*, JSDOMGlobalObject&, Ref<TextTrackCue>&&);

    void finishCreation(JSC::VM&);
};

class JSTextTrackCueOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, TextTrackCue*)
{
    static NeverDestroyed<JSTextTrackCueOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(TextTrackCue* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, TextTrackCue&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TextTrackCue* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<TextTrackCue>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<TextTrackCue>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<TextTrackCue> {
    using WrapperClass = JSTextTrackCue;
    using ToWrappedReturnType = TextTrackCue*;
};

} // namespace WebCore

#endif // ENABLE(VIDEO_TRACK)
