/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouchEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSTouchList.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> TouchEvent::Init convertDictionary<TouchEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    TouchEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detailValue.isUndefined()) {
        result.detail = convert<IDLLong>(lexicalGlobalObject, detailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detail = 0;
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.view = nullptr;
    JSValue changedTouchesValue;
    if (isNullOrUndefined)
        changedTouchesValue = jsUndefined();
    else {
        changedTouchesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "changedTouches"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!changedTouchesValue.isUndefined()) {
        result.changedTouches = convert<IDLNullable<IDLInterface<TouchList>>>(lexicalGlobalObject, changedTouchesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.changedTouches = nullptr;
    JSValue targetTouchesValue;
    if (isNullOrUndefined)
        targetTouchesValue = jsUndefined();
    else {
        targetTouchesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetTouches"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetTouchesValue.isUndefined()) {
        result.targetTouches = convert<IDLNullable<IDLInterface<TouchList>>>(lexicalGlobalObject, targetTouchesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.targetTouches = nullptr;
    JSValue touchesValue;
    if (isNullOrUndefined)
        touchesValue = jsUndefined();
    else {
        touchesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "touches"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!touchesValue.isUndefined()) {
        result.touches = convert<IDLNullable<IDLInterface<TouchList>>>(lexicalGlobalObject, touchesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.touches = nullptr;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTouchEventPrototypeFunctionInitTouchEvent(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsTouchEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTouchEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTouchEventTouches(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventTargetTouches(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventChangedTouches(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventCtrlKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventShiftKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventAltKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchEventMetaKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSTouchEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTouchEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTouchEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSTouchEventPrototype>(vm.heap)) JSTouchEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTouchEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTouchEventPrototype, JSTouchEventPrototype::Base);

using JSTouchEventConstructor = JSDOMConstructor<JSTouchEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSTouchEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSTouchEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<TouchEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = TouchEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<TouchEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSTouchEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSTouchEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTouchEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("TouchEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTouchEventConstructor::s_info = { "TouchEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTouchEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTouchEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTouchEventConstructor) } },
    { "touches", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventTouches), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "targetTouches", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventTargetTouches), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "changedTouches", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventChangedTouches), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ctrlKey", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventCtrlKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shiftKey", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventShiftKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "altKey", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventAltKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "metaKey", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventMetaKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initTouchEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTouchEventPrototypeFunctionInitTouchEvent), (intptr_t) (0) } },
};

const ClassInfo JSTouchEventPrototype::s_info = { "TouchEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTouchEventPrototype) };

void JSTouchEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTouchEvent::info(), JSTouchEventPrototypeTableValues, *this);
}

const ClassInfo JSTouchEvent::s_info = { "TouchEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTouchEvent) };

JSTouchEvent::JSTouchEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TouchEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

void JSTouchEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TouchEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTouchEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTouchEventPrototype::create(vm, &globalObject, JSTouchEventPrototype::createStructure(vm, &globalObject, JSUIEvent::prototype(vm, globalObject)));
}

JSObject* JSTouchEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTouchEvent>(vm, globalObject);
}

JSValue JSTouchEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSTouchEvent* IDLAttribute<JSTouchEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSTouchEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSTouchEvent* IDLOperation<JSTouchEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSTouchEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsTouchEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTouchEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTouchEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTouchEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTouchEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsTouchEventTouchesGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TouchList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.touches());
    return result;
}

EncodedJSValue jsTouchEventTouches(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEventTouchesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "touches");
}

static inline JSValue jsTouchEventTargetTouchesGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TouchList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.targetTouches());
    return result;
}

EncodedJSValue jsTouchEventTargetTouches(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEventTargetTouchesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "targetTouches");
}

static inline JSValue jsTouchEventChangedTouchesGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TouchList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.changedTouches());
    return result;
}

EncodedJSValue jsTouchEventChangedTouches(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEventChangedTouchesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "changedTouches");
}

static inline JSValue jsTouchEventCtrlKeyGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ctrlKey());
    return result;
}

EncodedJSValue jsTouchEventCtrlKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEventCtrlKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ctrlKey");
}

static inline JSValue jsTouchEventShiftKeyGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.shiftKey());
    return result;
}

EncodedJSValue jsTouchEventShiftKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEventShiftKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shiftKey");
}

static inline JSValue jsTouchEventAltKeyGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.altKey());
    return result;
}

EncodedJSValue jsTouchEventAltKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEventAltKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "altKey");
}

static inline JSValue jsTouchEventMetaKeyGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.metaKey());
    return result;
}

EncodedJSValue jsTouchEventMetaKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEventMetaKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "metaKey");
}

static inline JSC::EncodedJSValue jsTouchEventPrototypeFunctionInitTouchEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTouchEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto touches = convert<IDLNullable<IDLInterface<TouchList>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "touches", "TouchEvent", "initTouchEvent", "TouchList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto targetTouches = convert<IDLNullable<IDLInterface<TouchList>>>(*lexicalGlobalObject, callFrame->argument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "targetTouches", "TouchEvent", "initTouchEvent", "TouchList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto changedTouches = convert<IDLNullable<IDLInterface<TouchList>>>(*lexicalGlobalObject, callFrame->argument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "changedTouches", "TouchEvent", "initTouchEvent", "TouchList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto view = convert<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, callFrame->argument(4), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 4, "view", "TouchEvent", "initTouchEvent", "WindowProxy"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto screenX = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto screenY = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto clientX = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto clientY = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto ctrlKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto altKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(10));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto shiftKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(11));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto metaKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(12));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.initTouchEvent(WTFMove(touches), WTFMove(targetTouches), WTFMove(changedTouches), WTFMove(type), WTFMove(view), WTFMove(screenX), WTFMove(screenY), WTFMove(clientX), WTFMove(clientY), WTFMove(ctrlKey), WTFMove(altKey), WTFMove(shiftKey), WTFMove(metaKey));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTouchEventPrototypeFunctionInitTouchEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTouchEvent>::call<jsTouchEventPrototypeFunctionInitTouchEventBody>(*lexicalGlobalObject, *callFrame, "initTouchEvent");
}

void JSTouchEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTouchEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TouchEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10TouchEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TouchEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7TouchEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10TouchEventE[2];
#endif

    // If this fails TouchEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<TouchEvent>::value, "TouchEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // TouchEvent has subclasses. If TouchEvent has subclasses that get passed
    // to toJS() we currently require TouchEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<TouchEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TouchEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(TOUCH_EVENTS)
