/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_TYPED_OM)

#include "JSTypedOMCSSImageValue.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsTypedOMCSSImageValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypedOMCSSImageValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTypedOMCSSImageValuePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTypedOMCSSImageValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTypedOMCSSImageValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSTypedOMCSSImageValuePrototype>(vm.heap)) JSTypedOMCSSImageValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTypedOMCSSImageValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTypedOMCSSImageValuePrototype, JSTypedOMCSSImageValuePrototype::Base);

using JSTypedOMCSSImageValueConstructor = JSDOMConstructorNotConstructable<JSTypedOMCSSImageValue>;

template<> JSValue JSTypedOMCSSImageValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSTypedOMCSSStyleValue::getConstructor(vm, &globalObject);
}

template<> void JSTypedOMCSSImageValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTypedOMCSSImageValue::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSImageValue"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTypedOMCSSImageValueConstructor::s_info = { "CSSImageValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSImageValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTypedOMCSSImageValuePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypedOMCSSImageValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypedOMCSSImageValueConstructor) } },
};

const ClassInfo JSTypedOMCSSImageValuePrototype::s_info = { "CSSImageValuePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSImageValuePrototype) };

void JSTypedOMCSSImageValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTypedOMCSSImageValue::info(), JSTypedOMCSSImageValuePrototypeTableValues, *this);
}

const ClassInfo JSTypedOMCSSImageValue::s_info = { "CSSImageValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSImageValue) };

JSTypedOMCSSImageValue::JSTypedOMCSSImageValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TypedOMCSSImageValue>&& impl)
    : JSTypedOMCSSStyleValue(structure, globalObject, WTFMove(impl))
{
}

void JSTypedOMCSSImageValue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TypedOMCSSImageValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTypedOMCSSImageValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTypedOMCSSImageValuePrototype::create(vm, &globalObject, JSTypedOMCSSImageValuePrototype::createStructure(vm, &globalObject, JSTypedOMCSSStyleValue::prototype(vm, globalObject)));
}

JSObject* JSTypedOMCSSImageValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTypedOMCSSImageValue>(vm, globalObject);
}

JSValue JSTypedOMCSSImageValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTypedOMCSSImageValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue jsTypedOMCSSImageValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSImageValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTypedOMCSSImageValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTypedOMCSSImageValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSImageValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSTypedOMCSSImageValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTypedOMCSSImageValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

TypedOMCSSImageValue* JSTypedOMCSSImageValue::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTypedOMCSSImageValue*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(CSS_TYPED_OM)
