/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_TYPED_OM)

#include "JSTypedOMCSSStyleValue.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTypedOMCSSStyleValuePrototypeFunctionToString(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsTypedOMCSSStyleValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypedOMCSSStyleValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTypedOMCSSStyleValuePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTypedOMCSSStyleValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTypedOMCSSStyleValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSTypedOMCSSStyleValuePrototype>(vm.heap)) JSTypedOMCSSStyleValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTypedOMCSSStyleValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTypedOMCSSStyleValuePrototype, JSTypedOMCSSStyleValuePrototype::Base);

using JSTypedOMCSSStyleValueConstructor = JSDOMConstructorNotConstructable<JSTypedOMCSSStyleValue>;

template<> JSValue JSTypedOMCSSStyleValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTypedOMCSSStyleValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTypedOMCSSStyleValue::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSStyleValue"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTypedOMCSSStyleValueConstructor::s_info = { "CSSStyleValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSStyleValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTypedOMCSSStyleValuePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypedOMCSSStyleValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypedOMCSSStyleValueConstructor) } },
    { "toString", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTypedOMCSSStyleValuePrototypeFunctionToString), (intptr_t) (0) } },
};

const ClassInfo JSTypedOMCSSStyleValuePrototype::s_info = { "CSSStyleValuePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSStyleValuePrototype) };

void JSTypedOMCSSStyleValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTypedOMCSSStyleValue::info(), JSTypedOMCSSStyleValuePrototypeTableValues, *this);
}

const ClassInfo JSTypedOMCSSStyleValue::s_info = { "CSSStyleValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSStyleValue) };

JSTypedOMCSSStyleValue::JSTypedOMCSSStyleValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TypedOMCSSStyleValue>&& impl)
    : JSDOMWrapper<TypedOMCSSStyleValue>(structure, globalObject, WTFMove(impl))
{
}

void JSTypedOMCSSStyleValue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TypedOMCSSStyleValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTypedOMCSSStyleValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTypedOMCSSStyleValuePrototype::create(vm, &globalObject, JSTypedOMCSSStyleValuePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSTypedOMCSSStyleValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTypedOMCSSStyleValue>(vm, globalObject);
}

JSValue JSTypedOMCSSStyleValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTypedOMCSSStyleValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTypedOMCSSStyleValue::destroy(JSC::JSCell* cell)
{
    JSTypedOMCSSStyleValue* thisObject = static_cast<JSTypedOMCSSStyleValue*>(cell);
    thisObject->JSTypedOMCSSStyleValue::~JSTypedOMCSSStyleValue();
}

template<> inline JSTypedOMCSSStyleValue* IDLOperation<JSTypedOMCSSStyleValue>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSTypedOMCSSStyleValue*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsTypedOMCSSStyleValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSStyleValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTypedOMCSSStyleValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTypedOMCSSStyleValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSStyleValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsTypedOMCSSStyleValuePrototypeFunctionToStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTypedOMCSSStyleValue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.toString()));
}

EncodedJSValue JSC_HOST_CALL jsTypedOMCSSStyleValuePrototypeFunctionToString(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSTypedOMCSSStyleValue>::call<jsTypedOMCSSStyleValuePrototypeFunctionToStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

void JSTypedOMCSSStyleValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTypedOMCSSStyleValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSTypedOMCSSStyleValueOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTypedOMCSSStyleValueOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTypedOMCSSStyleValue = static_cast<JSTypedOMCSSStyleValue*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTypedOMCSSStyleValue->wrapped(), jsTypedOMCSSStyleValue);
}

TypedOMCSSStyleValue* JSTypedOMCSSStyleValue::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTypedOMCSSStyleValue*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(CSS_TYPED_OM)
