/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_TYPED_OM)

#include "JSTypedOMCSSUnparsedValue.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(CSS_TYPED_OM)
#include "JSDOMConvertStrings.h"
#endif


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsTypedOMCSSUnparsedValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTypedOMCSSUnparsedValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTypedOMCSSUnparsedValuePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTypedOMCSSUnparsedValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTypedOMCSSUnparsedValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSTypedOMCSSUnparsedValuePrototype>(vm.heap)) JSTypedOMCSSUnparsedValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTypedOMCSSUnparsedValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTypedOMCSSUnparsedValuePrototype, JSTypedOMCSSUnparsedValuePrototype::Base);

using JSTypedOMCSSUnparsedValueConstructor = JSDOMConstructor<JSTypedOMCSSUnparsedValue>;

template<> EncodedJSValue JSC_HOST_CALL JSTypedOMCSSUnparsedValueConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSTypedOMCSSUnparsedValueConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto serializedValue = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = TypedOMCSSUnparsedValue::create(WTFMove(serializedValue));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<TypedOMCSSUnparsedValue>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSTypedOMCSSUnparsedValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSTypedOMCSSStyleValue::getConstructor(vm, &globalObject);
}

template<> void JSTypedOMCSSUnparsedValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTypedOMCSSUnparsedValue::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSUnparsedValue"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSTypedOMCSSUnparsedValueConstructor::s_info = { "CSSUnparsedValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSUnparsedValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTypedOMCSSUnparsedValuePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypedOMCSSUnparsedValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTypedOMCSSUnparsedValueConstructor) } },
};

const ClassInfo JSTypedOMCSSUnparsedValuePrototype::s_info = { "CSSUnparsedValuePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSUnparsedValuePrototype) };

void JSTypedOMCSSUnparsedValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTypedOMCSSUnparsedValue::info(), JSTypedOMCSSUnparsedValuePrototypeTableValues, *this);
}

const ClassInfo JSTypedOMCSSUnparsedValue::s_info = { "CSSUnparsedValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTypedOMCSSUnparsedValue) };

JSTypedOMCSSUnparsedValue::JSTypedOMCSSUnparsedValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TypedOMCSSUnparsedValue>&& impl)
    : JSTypedOMCSSStyleValue(structure, globalObject, WTFMove(impl))
{
}

void JSTypedOMCSSUnparsedValue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TypedOMCSSUnparsedValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTypedOMCSSUnparsedValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTypedOMCSSUnparsedValuePrototype::create(vm, &globalObject, JSTypedOMCSSUnparsedValuePrototype::createStructure(vm, &globalObject, JSTypedOMCSSStyleValue::prototype(vm, globalObject)));
}

JSObject* JSTypedOMCSSUnparsedValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTypedOMCSSUnparsedValue>(vm, globalObject);
}

JSValue JSTypedOMCSSUnparsedValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTypedOMCSSUnparsedValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue jsTypedOMCSSUnparsedValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSUnparsedValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTypedOMCSSUnparsedValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSTypedOMCSSUnparsedValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTypedOMCSSUnparsedValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSTypedOMCSSUnparsedValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTypedOMCSSUnparsedValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TypedOMCSSUnparsedValue@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23TypedOMCSSUnparsedValueE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TypedOMCSSUnparsedValue>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7TypedOMCSSUnparsedValue@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore23TypedOMCSSUnparsedValueE[2];
#endif

    // If this fails TypedOMCSSUnparsedValue does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<TypedOMCSSUnparsedValue>::value, "TypedOMCSSUnparsedValue is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // TypedOMCSSUnparsedValue has subclasses. If TypedOMCSSUnparsedValue has subclasses that get passed
    // to toJS() we currently require TypedOMCSSUnparsedValue you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<TypedOMCSSUnparsedValue>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TypedOMCSSUnparsedValue& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(CSS_TYPED_OM)
