/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSUndoItem.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSVoidCallback.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> UndoItem::Init convertDictionary<UndoItem::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    UndoItem::Init result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLDOMString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "label", "UndoItemInit", "DOMString");
        return { };
    }
    JSValue redoValue;
    if (isNullOrUndefined)
        redoValue = jsUndefined();
    else {
        redoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "redo"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!redoValue.isUndefined()) {
        result.redo = convert<IDLCallbackFunction<JSVoidCallback>>(lexicalGlobalObject, redoValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "redo", "UndoItemInit", "VoidCallback");
        return { };
    }
    JSValue undoValue;
    if (isNullOrUndefined)
        undoValue = jsUndefined();
    else {
        undoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "undo"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!undoValue.isUndefined()) {
        result.undo = convert<IDLCallbackFunction<JSVoidCallback>>(lexicalGlobalObject, undoValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "undo", "UndoItemInit", "VoidCallback");
        return { };
    }
    return result;
}

// Attributes

JSC::EncodedJSValue jsUndoItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSUndoItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsUndoItemLabel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSUndoItemPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSUndoItemPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSUndoItemPrototype* ptr = new (NotNull, JSC::allocateCell<JSUndoItemPrototype>(vm.heap)) JSUndoItemPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSUndoItemPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUndoItemPrototype, JSUndoItemPrototype::Base);

using JSUndoItemConstructor = JSDOMConstructor<JSUndoItem>;

template<> EncodedJSValue JSC_HOST_CALL JSUndoItemConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSUndoItemConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto initDict = convert<IDLDictionary<UndoItem::Init>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = UndoItem::create(WTFMove(initDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<UndoItem>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSUndoItemConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSUndoItemConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSUndoItem::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("UndoItem"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSUndoItemConstructor::s_info = { "UndoItem", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoItemConstructor) };

/* Hash table for prototype */

static const HashTableValue JSUndoItemPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUndoItemConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSUndoItemConstructor) } },
    { "label", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUndoItemLabel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSUndoItemPrototype::s_info = { "UndoItemPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoItemPrototype) };

void JSUndoItemPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSUndoItem::info(), JSUndoItemPrototypeTableValues, *this);
}

const ClassInfo JSUndoItem::s_info = { "UndoItem", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoItem) };

JSUndoItem::JSUndoItem(Structure* structure, JSDOMGlobalObject& globalObject, Ref<UndoItem>&& impl)
    : JSDOMWrapper<UndoItem>(structure, globalObject, WTFMove(impl))
{
}

void JSUndoItem::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, UndoItem>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSUndoItem::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSUndoItemPrototype::create(vm, &globalObject, JSUndoItemPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSUndoItem::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSUndoItem>(vm, globalObject);
}

JSValue JSUndoItem::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUndoItemConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSUndoItem::destroy(JSC::JSCell* cell)
{
    JSUndoItem* thisObject = static_cast<JSUndoItem*>(cell);
    thisObject->JSUndoItem::~JSUndoItem();
}

template<> inline JSUndoItem* IDLAttribute<JSUndoItem>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSUndoItem*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsUndoItemConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUndoItemPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSUndoItem::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSUndoItemConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUndoItemPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsUndoItemLabelGetter(JSGlobalObject& lexicalGlobalObject, JSUndoItem& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label());
    return result;
}

EncodedJSValue jsUndoItemLabel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSUndoItem>::get<jsUndoItemLabelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "label");
}

void JSUndoItem::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSUndoItem*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSUndoItem::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSUndoItem*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSUndoItem::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSUndoItem*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSUndoItemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsUndoItem = static_cast<JSUndoItem*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsUndoItem->wrapped(), jsUndoItem);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<UndoItem>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to UndoItem.
    static_assert(!std::is_polymorphic<UndoItem>::value, "UndoItem is polymorphic but the IDL claims it is not");
    return createWrapper<UndoItem>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, UndoItem& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

UndoItem* JSUndoItem::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSUndoItem*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
