/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSVTTCue.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocumentFragment.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(VTTCue::AutoKeyword enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("auto"),
    };
    static_assert(static_cast<size_t>(VTTCue::AutoKeyword::Auto) == 0, "VTTCue::AutoKeyword::Auto is not 0 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, VTTCue::AutoKeyword enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<VTTCue::AutoKeyword> parseEnumeration<VTTCue::AutoKeyword>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "auto")
        return VTTCue::AutoKeyword::Auto;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<VTTCue::AutoKeyword>()
{
    return "\"auto\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsVTTCuePrototypeFunctionGetCueAsHTML(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsVTTCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueVertical(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTCueVertical(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueSnapToLines(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTCueSnapToLines(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueLine(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTCueLine(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCuePosition(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTCuePosition(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTCueSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTCueAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTCueText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTCueRegionId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVTTCueRegionId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSVTTCuePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVTTCuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVTTCuePrototype* ptr = new (NotNull, JSC::allocateCell<JSVTTCuePrototype>(vm.heap)) JSVTTCuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVTTCuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVTTCuePrototype, JSVTTCuePrototype::Base);

using JSVTTCueConstructor = JSDOMConstructor<JSVTTCue>;

template<> EncodedJSValue JSC_HOST_CALL JSVTTCueConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSVTTCueConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "VTTCue");
    auto startTime = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endTime = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = VTTCue::create(*context, WTFMove(startTime), WTFMove(endTime), WTFMove(text));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<VTTCue>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSVTTCueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSTextTrackCue::getConstructor(vm, &globalObject);
}

template<> void JSVTTCueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSVTTCue::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("VTTCue"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(3), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSVTTCueConstructor::s_info = { "VTTCue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVTTCueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSVTTCuePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueConstructor) } },
    { "vertical", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueVertical), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueVertical) } },
    { "snapToLines", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueSnapToLines), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueSnapToLines) } },
    { "line", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueLine), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueLine) } },
    { "position", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCuePosition), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCuePosition) } },
    { "size", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueSize) } },
    { "align", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueAlign), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueAlign) } },
    { "text", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueText) } },
    { "regionId", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTCueRegionId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTCueRegionId) } },
    { "getCueAsHTML", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsVTTCuePrototypeFunctionGetCueAsHTML), (intptr_t) (0) } },
};

const ClassInfo JSVTTCuePrototype::s_info = { "VTTCuePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVTTCuePrototype) };

void JSVTTCuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVTTCue::info(), JSVTTCuePrototypeTableValues, *this);
}

const ClassInfo JSVTTCue::s_info = { "VTTCue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVTTCue) };

JSVTTCue::JSVTTCue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VTTCue>&& impl)
    : JSTextTrackCue(structure, globalObject, WTFMove(impl))
{
}

void JSVTTCue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, VTTCue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSVTTCue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSVTTCuePrototype::create(vm, &globalObject, JSVTTCuePrototype::createStructure(vm, &globalObject, JSTextTrackCue::prototype(vm, globalObject)));
}

JSObject* JSVTTCue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVTTCue>(vm, globalObject);
}

JSValue JSVTTCue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVTTCueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSVTTCue* IDLAttribute<JSVTTCue>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSVTTCue*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSVTTCue* IDLOperation<JSVTTCue>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSVTTCue*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsVTTCueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVTTCuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVTTCue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSVTTCueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVTTCuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsVTTCueVerticalGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.vertical());
    return result;
}

EncodedJSValue jsVTTCueVertical(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCueVerticalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "vertical");
}

static inline bool setJSVTTCueVerticalSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setVertical(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTCueVertical(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCueVerticalSetter>(*lexicalGlobalObject, thisValue, encodedValue, "vertical");
}

static inline JSValue jsVTTCueSnapToLinesGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.snapToLines());
    return result;
}

EncodedJSValue jsVTTCueSnapToLines(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCueSnapToLinesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "snapToLines");
}

static inline bool setJSVTTCueSnapToLinesSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSnapToLines(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTCueSnapToLines(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCueSnapToLinesSetter>(*lexicalGlobalObject, thisValue, encodedValue, "snapToLines");
}

static inline JSValue jsVTTCueLineGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.line());
    return result;
}

EncodedJSValue jsVTTCueLine(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCueLineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "line");
}

static inline bool setJSVTTCueLineSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLine(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTCueLine(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCueLineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "line");
}

static inline JSValue jsVTTCuePositionGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDouble, IDLEnumeration<VTTCue::AutoKeyword>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.position());
    return result;
}

EncodedJSValue jsVTTCuePosition(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCuePositionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "position");
}

static inline bool setJSVTTCuePositionSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDouble, IDLEnumeration<VTTCue::AutoKeyword>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPosition(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTCuePosition(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCuePositionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "position");
}

static inline JSValue jsVTTCueSizeGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.size());
    return result;
}

EncodedJSValue jsVTTCueSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCueSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "size");
}

static inline bool setJSVTTCueSizeSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSize(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTCueSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCueSizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "size");
}

static inline JSValue jsVTTCueAlignGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.align());
    return result;
}

EncodedJSValue jsVTTCueAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCueAlignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "align");
}

static inline bool setJSVTTCueAlignSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlign(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTCueAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCueAlignSetter>(*lexicalGlobalObject, thisValue, encodedValue, "align");
}

static inline JSValue jsVTTCueTextGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.text());
    return result;
}

EncodedJSValue jsVTTCueText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCueTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "text");
}

static inline bool setJSVTTCueTextSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setText(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTCueText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCueTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, "text");
}

static inline JSValue jsVTTCueRegionIdGetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.regionId());
    return result;
}

EncodedJSValue jsVTTCueRegionId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVTTCue>::get<jsVTTCueRegionIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "regionId");
}

static inline bool setJSVTTCueRegionIdSetter(JSGlobalObject& lexicalGlobalObject, JSVTTCue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setRegionId(WTFMove(nativeValue));
    });
    return true;
}

bool setJSVTTCueRegionId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVTTCue>::set<setJSVTTCueRegionIdSetter>(*lexicalGlobalObject, thisValue, encodedValue, "regionId");
}

static inline JSC::EncodedJSValue jsVTTCuePrototypeFunctionGetCueAsHTMLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSVTTCue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DocumentFragment>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getCueAsHTML()));
}

EncodedJSValue JSC_HOST_CALL jsVTTCuePrototypeFunctionGetCueAsHTML(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSVTTCue>::call<jsVTTCuePrototypeFunctionGetCueAsHTMLBody>(*lexicalGlobalObject, *callFrame, "getCueAsHTML");
}

void JSVTTCue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVTTCue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VTTCue@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore6VTTCueE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VTTCue>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7VTTCue@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore6VTTCueE[2];
#endif

    // If this fails VTTCue does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<VTTCue>::value, "VTTCue is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // VTTCue has subclasses. If VTTCue has subclasses that get passed
    // to toJS() we currently require VTTCue you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<VTTCue>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VTTCue& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VTTCue* JSVTTCue::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVTTCue*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
