/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoPlaybackQuality.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsVideoPlaybackQualityCreationTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoPlaybackQualityTotalVideoFrames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoPlaybackQualityDroppedVideoFrames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoPlaybackQualityCorruptedVideoFrames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoPlaybackQualityDisplayCompositedVideoFrames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVideoPlaybackQualityTotalFrameDelay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSVideoPlaybackQualityPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVideoPlaybackQualityPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoPlaybackQualityPrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoPlaybackQualityPrototype>(vm.heap)) JSVideoPlaybackQualityPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVideoPlaybackQualityPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoPlaybackQualityPrototype, JSVideoPlaybackQualityPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSVideoPlaybackQualityPrototypeTableValues[] =
{
    { "creationTime", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityCreationTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "totalVideoFrames", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityTotalVideoFrames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "droppedVideoFrames", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityDroppedVideoFrames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "corruptedVideoFrames", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityCorruptedVideoFrames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "displayCompositedVideoFrames", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityDisplayCompositedVideoFrames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "totalFrameDelay", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoPlaybackQualityTotalFrameDelay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSVideoPlaybackQualityPrototype::s_info = { "VideoPlaybackQualityPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoPlaybackQualityPrototype) };

void JSVideoPlaybackQualityPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVideoPlaybackQuality::info(), JSVideoPlaybackQualityPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().videoQualityIncludesDisplayCompositingEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("displayCompositedVideoFrames"), strlen("displayCompositedVideoFrames"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSVideoPlaybackQuality::s_info = { "VideoPlaybackQuality", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoPlaybackQuality) };

JSVideoPlaybackQuality::JSVideoPlaybackQuality(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VideoPlaybackQuality>&& impl)
    : JSDOMWrapper<VideoPlaybackQuality>(structure, globalObject, WTFMove(impl))
{
}

void JSVideoPlaybackQuality::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, VideoPlaybackQuality>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSVideoPlaybackQuality::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSVideoPlaybackQualityPrototype::create(vm, &globalObject, JSVideoPlaybackQualityPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSVideoPlaybackQuality::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVideoPlaybackQuality>(vm, globalObject);
}

void JSVideoPlaybackQuality::destroy(JSC::JSCell* cell)
{
    JSVideoPlaybackQuality* thisObject = static_cast<JSVideoPlaybackQuality*>(cell);
    thisObject->JSVideoPlaybackQuality::~JSVideoPlaybackQuality();
}

template<> inline JSVideoPlaybackQuality* IDLAttribute<JSVideoPlaybackQuality>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSVideoPlaybackQuality*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

static inline JSValue jsVideoPlaybackQualityCreationTimeGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.creationTime());
    return result;
}

EncodedJSValue jsVideoPlaybackQualityCreationTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQualityCreationTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "creationTime");
}

static inline JSValue jsVideoPlaybackQualityTotalVideoFramesGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.totalVideoFrames());
    return result;
}

EncodedJSValue jsVideoPlaybackQualityTotalVideoFrames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQualityTotalVideoFramesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "totalVideoFrames");
}

static inline JSValue jsVideoPlaybackQualityDroppedVideoFramesGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.droppedVideoFrames());
    return result;
}

EncodedJSValue jsVideoPlaybackQualityDroppedVideoFrames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQualityDroppedVideoFramesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "droppedVideoFrames");
}

static inline JSValue jsVideoPlaybackQualityCorruptedVideoFramesGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.corruptedVideoFrames());
    return result;
}

EncodedJSValue jsVideoPlaybackQualityCorruptedVideoFrames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQualityCorruptedVideoFramesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "corruptedVideoFrames");
}

static inline JSValue jsVideoPlaybackQualityDisplayCompositedVideoFramesGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.displayCompositedVideoFrames());
    return result;
}

EncodedJSValue jsVideoPlaybackQualityDisplayCompositedVideoFrames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQualityDisplayCompositedVideoFramesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "displayCompositedVideoFrames");
}

static inline JSValue jsVideoPlaybackQualityTotalFrameDelayGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.totalFrameDelay());
    return result;
}

EncodedJSValue jsVideoPlaybackQualityTotalFrameDelay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQualityTotalFrameDelayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "totalFrameDelay");
}

void JSVideoPlaybackQuality::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVideoPlaybackQuality*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSVideoPlaybackQualityOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSVideoPlaybackQualityOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVideoPlaybackQuality = static_cast<JSVideoPlaybackQuality*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsVideoPlaybackQuality->wrapped(), jsVideoPlaybackQuality);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VideoPlaybackQuality>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to VideoPlaybackQuality.
    static_assert(!std::is_polymorphic<VideoPlaybackQuality>::value, "VideoPlaybackQuality is polymorphic but the IDL claims it is not");
    return createWrapper<VideoPlaybackQuality>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VideoPlaybackQuality& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VideoPlaybackQuality* JSVideoPlaybackQuality::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVideoPlaybackQuality*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
