/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSVisualViewport.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsVisualViewportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVisualViewportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVisualViewportOffsetLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVisualViewportOffsetTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVisualViewportPageLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVisualViewportPageTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVisualViewportWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVisualViewportHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVisualViewportScale(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVisualViewportOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVisualViewportOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVisualViewportOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSVisualViewportOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSVisualViewportPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVisualViewportPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVisualViewportPrototype* ptr = new (NotNull, JSC::allocateCell<JSVisualViewportPrototype>(vm.heap)) JSVisualViewportPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVisualViewportPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVisualViewportPrototype, JSVisualViewportPrototype::Base);

using JSVisualViewportConstructor = JSDOMConstructorNotConstructable<JSVisualViewport>;

template<> JSValue JSVisualViewportConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSVisualViewportConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSVisualViewport::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("VisualViewport"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSVisualViewportConstructor::s_info = { "VisualViewport", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVisualViewportConstructor) };

/* Hash table for prototype */

static const HashTableValue JSVisualViewportPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVisualViewportConstructor) } },
    { "offsetLeft", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportOffsetLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetTop", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportOffsetTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pageLeft", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportPageLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pageTop", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportPageTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scale", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportScale), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onresize", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVisualViewportOnresize) } },
    { "onscroll", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVisualViewportOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVisualViewportOnscroll) } },
};

const ClassInfo JSVisualViewportPrototype::s_info = { "VisualViewportPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVisualViewportPrototype) };

void JSVisualViewportPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVisualViewport::info(), JSVisualViewportPrototypeTableValues, *this);
}

const ClassInfo JSVisualViewport::s_info = { "VisualViewport", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVisualViewport) };

JSVisualViewport::JSVisualViewport(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VisualViewport>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSVisualViewport::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, VisualViewport>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSVisualViewport::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSVisualViewportPrototype::create(vm, &globalObject, JSVisualViewportPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSVisualViewport::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVisualViewport>(vm, globalObject);
}

JSValue JSVisualViewport::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVisualViewportConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSVisualViewport* IDLAttribute<JSVisualViewport>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSVisualViewport*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsVisualViewportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVisualViewportPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVisualViewport::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSVisualViewportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVisualViewportPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsVisualViewportOffsetLeftGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.offsetLeft());
    return result;
}

EncodedJSValue jsVisualViewportOffsetLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewportOffsetLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "offsetLeft");
}

static inline JSValue jsVisualViewportOffsetTopGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.offsetTop());
    return result;
}

EncodedJSValue jsVisualViewportOffsetTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewportOffsetTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "offsetTop");
}

static inline JSValue jsVisualViewportPageLeftGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.pageLeft());
    return result;
}

EncodedJSValue jsVisualViewportPageLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewportPageLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pageLeft");
}

static inline JSValue jsVisualViewportPageTopGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.pageTop());
    return result;
}

EncodedJSValue jsVisualViewportPageTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewportPageTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pageTop");
}

static inline JSValue jsVisualViewportWidthGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.width());
    return result;
}

EncodedJSValue jsVisualViewportWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewportWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline JSValue jsVisualViewportHeightGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.height());
    return result;
}

EncodedJSValue jsVisualViewportHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewportHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline JSValue jsVisualViewportScaleGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.scale());
    return result;
}

EncodedJSValue jsVisualViewportScale(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewportScaleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scale");
}

static inline JSValue jsVisualViewportOnresizeGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsVisualViewportOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewportOnresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onresize");
}

static inline bool setJSVisualViewportOnresizeSetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resizeEvent, value);
    return true;
}

bool setJSVisualViewportOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVisualViewport>::set<setJSVisualViewportOnresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onresize");
}

static inline JSValue jsVisualViewportOnscrollGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsVisualViewportOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewportOnscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onscroll");
}

static inline bool setJSVisualViewportOnscrollSetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().scrollEvent, value);
    return true;
}

bool setJSVisualViewportOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSVisualViewport>::set<setJSVisualViewportOnscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onscroll");
}

void JSVisualViewport::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVisualViewport*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSVisualViewportOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsVisualViewport = jsCast<JSVisualViewport*>(handle.slot()->asCell());
    if (jsVisualViewport->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    auto* root = WTF::getPtr(jsVisualViewport->wrapped().window());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Window";
    return visitor.containsOpaqueRoot(root);
}

void JSVisualViewportOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVisualViewport = static_cast<JSVisualViewport*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsVisualViewport->wrapped(), jsVisualViewport);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VisualViewport@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14VisualViewportE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VisualViewport>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7VisualViewport@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14VisualViewportE[2];
#endif

    // If this fails VisualViewport does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<VisualViewport>::value, "VisualViewport is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // VisualViewport has subclasses. If VisualViewport has subclasses that get passed
    // to toJS() we currently require VisualViewport you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<VisualViewport>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VisualViewport& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VisualViewport* JSVisualViewport::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVisualViewport*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
