/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebAnimation.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "JSAnimationEffect.h"
#include "JSAnimationTimeline.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSWebAnimation.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(WebAnimation::PlayState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("idle"),
        MAKE_STATIC_STRING_IMPL("running"),
        MAKE_STATIC_STRING_IMPL("paused"),
        MAKE_STATIC_STRING_IMPL("finished"),
    };
    static_assert(static_cast<size_t>(WebAnimation::PlayState::Idle) == 0, "WebAnimation::PlayState::Idle is not 0 as expected");
    static_assert(static_cast<size_t>(WebAnimation::PlayState::Running) == 1, "WebAnimation::PlayState::Running is not 1 as expected");
    static_assert(static_cast<size_t>(WebAnimation::PlayState::Paused) == 2, "WebAnimation::PlayState::Paused is not 2 as expected");
    static_assert(static_cast<size_t>(WebAnimation::PlayState::Finished) == 3, "WebAnimation::PlayState::Finished is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, WebAnimation::PlayState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<WebAnimation::PlayState> parseEnumeration<WebAnimation::PlayState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "idle")
        return WebAnimation::PlayState::Idle;
    if (stringValue == "running")
        return WebAnimation::PlayState::Running;
    if (stringValue == "paused")
        return WebAnimation::PlayState::Paused;
    if (stringValue == "finished")
        return WebAnimation::PlayState::Finished;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<WebAnimation::PlayState>()
{
    return "\"idle\", \"running\", \"paused\", \"finished\"";
}

String convertEnumerationToString(WebAnimation::ReplaceState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("active"),
        MAKE_STATIC_STRING_IMPL("removed"),
        MAKE_STATIC_STRING_IMPL("persisted"),
    };
    static_assert(static_cast<size_t>(WebAnimation::ReplaceState::Active) == 0, "WebAnimation::ReplaceState::Active is not 0 as expected");
    static_assert(static_cast<size_t>(WebAnimation::ReplaceState::Removed) == 1, "WebAnimation::ReplaceState::Removed is not 1 as expected");
    static_assert(static_cast<size_t>(WebAnimation::ReplaceState::Persisted) == 2, "WebAnimation::ReplaceState::Persisted is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, WebAnimation::ReplaceState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<WebAnimation::ReplaceState> parseEnumeration<WebAnimation::ReplaceState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "active")
        return WebAnimation::ReplaceState::Active;
    if (stringValue == "removed")
        return WebAnimation::ReplaceState::Removed;
    if (stringValue == "persisted")
        return WebAnimation::ReplaceState::Persisted;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<WebAnimation::ReplaceState>()
{
    return "\"active\", \"removed\", \"persisted\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionCancel(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionFinish(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionPlay(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionPause(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionUpdatePlaybackRate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionReverse(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionPersist(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionCommitStyles(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsWebAnimationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationEffect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationEffect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationTimeline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationTimeline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationStartTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationStartTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationCurrentTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationCurrentTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationPlaybackRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationPlaybackRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationPlayState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebAnimationReplaceState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebAnimationPending(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebAnimationOnfinish(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationOnfinish(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationOncancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationOncancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationOnremove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebAnimationOnremove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebAnimationReady(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebAnimationFinished(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSWebAnimationPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebAnimationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebAnimationPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebAnimationPrototype>(vm.heap)) JSWebAnimationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebAnimationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebAnimationPrototype, JSWebAnimationPrototype::Base);

using JSWebAnimationConstructor = JSDOMConstructor<JSWebAnimation>;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSWebAnimationConstructor::construct(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    ASSERT(callFrame);
    return constructJSWebAnimation(lexicalGlobalObject, *callFrame);
}

template<> JSValue JSWebAnimationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWebAnimationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebAnimation::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Animation"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebAnimationConstructor::s_info = { "Animation", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebAnimationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebAnimationPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationConstructor) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationId) } },
    { "effect", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationEffect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationEffect) } },
    { "timeline", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationTimeline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationTimeline) } },
    { "startTime", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationStartTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationStartTime) } },
    { "currentTime", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationCurrentTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationCurrentTime) } },
    { "playbackRate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationPlaybackRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationPlaybackRate) } },
    { "playState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationPlayState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "replaceState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationReplaceState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pending", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationPending), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onfinish", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationOnfinish), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationOnfinish) } },
    { "oncancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationOncancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationOncancel) } },
    { "onremove", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationOnremove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebAnimationOnremove) } },
    { "ready", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationReady), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "finished", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebAnimationFinished), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "cancel", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebAnimationPrototypeFunctionCancel), (intptr_t) (0) } },
    { "finish", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebAnimationPrototypeFunctionFinish), (intptr_t) (0) } },
    { "play", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebAnimationPrototypeFunctionPlay), (intptr_t) (0) } },
    { "pause", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebAnimationPrototypeFunctionPause), (intptr_t) (0) } },
    { "updatePlaybackRate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebAnimationPrototypeFunctionUpdatePlaybackRate), (intptr_t) (1) } },
    { "reverse", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebAnimationPrototypeFunctionReverse), (intptr_t) (0) } },
    { "persist", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebAnimationPrototypeFunctionPersist), (intptr_t) (0) } },
    { "commitStyles", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebAnimationPrototypeFunctionCommitStyles), (intptr_t) (0) } },
};

const ClassInfo JSWebAnimationPrototype::s_info = { "AnimationPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebAnimationPrototype) };

void JSWebAnimationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebAnimation::info(), JSWebAnimationPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().webAnimationsMutableTimelinesEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("timeline"), strlen("timeline"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    // Adding back attribute, but as readonly, after removing the read-write variant above. 
    if (!RuntimeEnabledFeatures::sharedFeatures().webAnimationsMutableTimelinesEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().timelinePublicName(), CustomGetterSetter::create(vm, jsWebAnimationTimeline, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute)));
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSWebAnimation::s_info = { "Animation", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebAnimation) };

JSWebAnimation::JSWebAnimation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebAnimation>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSWebAnimation::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, WebAnimation>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSWebAnimation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebAnimationPrototype::create(vm, &globalObject, JSWebAnimationPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSWebAnimation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebAnimation>(vm, globalObject);
}

JSValue JSWebAnimation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebAnimationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSWebAnimation* IDLAttribute<JSWebAnimation>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWebAnimation*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSWebAnimation* IDLOperation<JSWebAnimation>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebAnimation*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebAnimationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebAnimationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebAnimation::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebAnimationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebAnimationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsWebAnimationIdGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsWebAnimationId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline bool setJSWebAnimationIdSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setId(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebAnimationId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimationIdSetter>(*lexicalGlobalObject, thisValue, encodedValue, "id");
}

static inline JSValue jsWebAnimationEffectGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<AnimationEffect>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.effect());
    return result;
}

EncodedJSValue jsWebAnimationEffect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationEffectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "effect");
}

static inline bool setJSWebAnimationEffectSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<AnimationEffect>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "Animation", "effect", "AnimationEffect"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setEffect(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebAnimationEffect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimationEffectSetter>(*lexicalGlobalObject, thisValue, encodedValue, "effect");
}

static inline JSValue jsWebAnimationTimelineGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<AnimationTimeline>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.timeline());
    return result;
}

EncodedJSValue jsWebAnimationTimeline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationTimelineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "timeline");
}

static inline bool setJSWebAnimationTimelineSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<AnimationTimeline>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "Animation", "timeline", "AnimationTimeline"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTimeline(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebAnimationTimeline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimationTimelineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "timeline");
}

static inline JSValue jsWebAnimationStartTimeGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, impl.startTime());
    return result;
}

EncodedJSValue jsWebAnimationStartTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationStartTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "startTime");
}

static inline bool setJSWebAnimationStartTimeSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setStartTime(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebAnimationStartTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimationStartTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "startTime");
}

static inline JSValue jsWebAnimationCurrentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, impl.bindingsCurrentTime());
    return result;
}

EncodedJSValue jsWebAnimationCurrentTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationCurrentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentTime");
}

static inline bool setJSWebAnimationCurrentTimeSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsCurrentTime(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebAnimationCurrentTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimationCurrentTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "currentTime");
}

static inline JSValue jsWebAnimationPlaybackRateGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.playbackRate());
    return result;
}

EncodedJSValue jsWebAnimationPlaybackRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationPlaybackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "playbackRate");
}

static inline bool setJSWebAnimationPlaybackRateSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPlaybackRate(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebAnimationPlaybackRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimationPlaybackRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "playbackRate");
}

static inline JSValue jsWebAnimationPlayStateGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<WebAnimation::PlayState>>(lexicalGlobalObject, throwScope, impl.bindingsPlayState());
    return result;
}

EncodedJSValue jsWebAnimationPlayState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationPlayStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "playState");
}

static inline JSValue jsWebAnimationReplaceStateGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<WebAnimation::ReplaceState>>(lexicalGlobalObject, throwScope, impl.bindingsReplaceState());
    return result;
}

EncodedJSValue jsWebAnimationReplaceState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationReplaceStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "replaceState");
}

static inline JSValue jsWebAnimationPendingGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.bindingsPending());
    return result;
}

EncodedJSValue jsWebAnimationPending(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationPendingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pending");
}

static inline JSValue jsWebAnimationOnfinishGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().finishEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsWebAnimationOnfinish(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationOnfinishGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfinish");
}

static inline bool setJSWebAnimationOnfinishSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().finishEvent, value);
    return true;
}

bool setJSWebAnimationOnfinish(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimationOnfinishSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfinish");
}

static inline JSValue jsWebAnimationOncancelGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsWebAnimationOncancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationOncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncancel");
}

static inline bool setJSWebAnimationOncancelSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().cancelEvent, value);
    return true;
}

bool setJSWebAnimationOncancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimationOncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncancel");
}

static inline JSValue jsWebAnimationOnremoveGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().removeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsWebAnimationOnremove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationOnremoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onremove");
}

static inline bool setJSWebAnimationOnremoveSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().removeEvent, value);
    return true;
}

bool setJSWebAnimationOnremove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimationOnremoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onremove");
}

static inline JSValue jsWebAnimationReadyGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLPromise<IDLInterface<WebAnimation>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsReady());
    return result;
}

EncodedJSValue jsWebAnimationReady(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationReadyGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, "ready");
}

static inline JSValue jsWebAnimationFinishedGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLPromise<IDLInterface<WebAnimation>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsFinished());
    return result;
}

EncodedJSValue jsWebAnimationFinished(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimationFinishedGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, "finished");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunctionCancelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.cancel();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionCancel(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunctionCancelBody>(*lexicalGlobalObject, *callFrame, "cancel");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunctionFinishBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.finish());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionFinish(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunctionFinishBody>(*lexicalGlobalObject, *callFrame, "finish");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunctionPlayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.bindingsPlay());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionPlay(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunctionPlayBody>(*lexicalGlobalObject, *callFrame, "play");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunctionPauseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.bindingsPause());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionPause(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunctionPauseBody>(*lexicalGlobalObject, *callFrame, "pause");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunctionUpdatePlaybackRateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto playbackRate = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.updatePlaybackRate(WTFMove(playbackRate));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionUpdatePlaybackRate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunctionUpdatePlaybackRateBody>(*lexicalGlobalObject, *callFrame, "updatePlaybackRate");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunctionReverseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.reverse());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionReverse(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunctionReverseBody>(*lexicalGlobalObject, *callFrame, "reverse");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunctionPersistBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.persist();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionPersist(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunctionPersistBody>(*lexicalGlobalObject, *callFrame, "persist");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunctionCommitStylesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.commitStyles());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebAnimationPrototypeFunctionCommitStyles(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunctionCommitStylesBody>(*lexicalGlobalObject, *callFrame, "commitStyles");
}

void JSWebAnimation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebAnimation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebAnimationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebAnimation = jsCast<JSWebAnimation*>(handle.slot()->asCell());
    if (jsWebAnimation->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsWebAnimation->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebAnimationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebAnimation = static_cast<JSWebAnimation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebAnimation->wrapped(), jsWebAnimation);
}

WebAnimation* JSWebAnimation::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebAnimation*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
