/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "WebAnimation.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSWebAnimation : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = WebAnimation;
    static JSWebAnimation* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<WebAnimation>&& impl)
    {
        JSWebAnimation* ptr = new (NotNull, JSC::allocateCell<JSWebAnimation>(globalObject->vm().heap)) JSWebAnimation(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static WebAnimation* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    WebAnimation& wrapped() const
    {
        return static_cast<WebAnimation&>(Base::wrapped());
    }
protected:
    JSWebAnimation(JSC::Structure*, JSDOMGlobalObject&, Ref<WebAnimation>&&);

    void finishCreation(JSC::VM&);
};

class JSWebAnimationOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, WebAnimation*)
{
    static NeverDestroyed<JSWebAnimationOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(WebAnimation* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, WebAnimation&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebAnimation* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<WebAnimation>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<WebAnimation>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

// Custom constructor
JSC::EncodedJSValue constructJSWebAnimation(JSC::JSGlobalObject*, JSC::CallFrame&);

template<> struct JSDOMWrapperConverterTraits<WebAnimation> {
    using WrapperClass = JSWebAnimation;
    using ToWrappedReturnType = WebAnimation*;
};
String convertEnumerationToString(WebAnimation::PlayState);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, WebAnimation::PlayState);

template<> Optional<WebAnimation::PlayState> parseEnumeration<WebAnimation::PlayState>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<WebAnimation::PlayState>();

String convertEnumerationToString(WebAnimation::ReplaceState);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, WebAnimation::ReplaceState);

template<> Optional<WebAnimation::ReplaceState> parseEnumeration<WebAnimation::ReplaceState>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<WebAnimation::ReplaceState>();


} // namespace WebCore
