/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL2)

#include "JSWebGL2RenderingContext.h"

#include "ActiveDOMObject.h"
#include "CallTracer.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertWebGL.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageBitmap.h"
#include "JSImageData.h"
#include "JSWebGLActiveInfo.h"
#include "JSWebGLBuffer.h"
#include "JSWebGLProgram.h"
#include "JSWebGLQuery.h"
#include "JSWebGLSampler.h"
#include "JSWebGLSync.h"
#include "JSWebGLTexture.h"
#include "JSWebGLTransformFeedback.h"
#include "JSWebGLUniformLocation.h"
#include "JSWebGLVertexArrayObject.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>

#if ENABLE(WEBGL)
#include "JSDOMConvertDictionary.h"
#include "JSWebGLContextAttributes.h"
#include "JSWebGLFramebuffer.h"
#include "JSWebGLRenderbuffer.h"
#include "JSWebGLShader.h"
#include "JSWebGLShaderPrecisionFormat.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBufferData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBufferSubData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCopyBufferSubData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetBufferSubData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlitFramebuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFramebufferTextureLayer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionInvalidateFramebuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionInvalidateSubFramebuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionReadBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetInternalformatParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorageMultisample(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexStorage2D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexStorage3D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexImage3D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage3D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetFragDataLocation(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1ui(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2ui(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3ui(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4ui(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1uiv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2uiv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3uiv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4uiv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x3fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x2fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x4fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x2fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x4fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x3fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4i(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4iv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4ui(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4uiv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribIPointer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribDivisor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawArraysInstanced(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawElementsInstanced(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawRangeElements(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawBuffers(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearBufferiv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearBufferuiv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearBufferfv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearBufferfi(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateQuery(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteQuery(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsQuery(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBeginQuery(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionEndQuery(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetQuery(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetQueryParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateSampler(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteSampler(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsSampler(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindSampler(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionSamplerParameteri(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionSamplerParameterf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetSamplerParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFenceSync(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsSync(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteSync(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClientWaitSync(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionWaitSync(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetSyncParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateTransformFeedback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteTransformFeedback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsTransformFeedback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindTransformFeedback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBeginTransformFeedback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionEndTransformFeedback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTransformFeedbackVaryings(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetTransformFeedbackVarying(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionPauseTransformFeedback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionResumeTransformFeedback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindBufferBase(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindBufferRange(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetIndexedParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetUniformIndices(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveUniforms(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetUniformBlockIndex(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockName(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformBlockBinding(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateVertexArray(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteVertexArray(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsVertexArray(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindVertexArray(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexImage2D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1iv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2iv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3iv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4iv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fv(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionReadPixels(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionActiveTexture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionAttachShader(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindAttribLocation(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindFramebuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindRenderbuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindTexture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendColor(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendEquation(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendEquationSeparate(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendFunc(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendFuncSeparate(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCheckFramebufferStatus(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClear(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearColor(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearDepth(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearStencil(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionColorMask(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompileShader(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCopyTexImage2D(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage2D(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateFramebuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateProgram(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateRenderbuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateShader(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateTexture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCullFace(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteFramebuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteProgram(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteRenderbuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteShader(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteTexture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDepthFunc(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDepthMask(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDepthRange(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDetachShader(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDisable(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDisableVertexAttribArray(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawArrays(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawElements(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionEnable(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionEnableVertexAttribArray(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFinish(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFlush(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFramebufferRenderbuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFramebufferTexture2D(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFrontFace(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGenerateMipmap(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveAttrib(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveUniform(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetAttachedShaders(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetAttribLocation(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetBufferParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetContextAttributes(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetError(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetSupportedExtensions(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetExtension(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetFramebufferAttachmentParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetProgramParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetProgramInfoLog(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetRenderbufferParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetShaderParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetShaderInfoLog(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetShaderPrecisionFormat(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetShaderSource(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetTexParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetUniform(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetUniformLocation(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetVertexAttrib(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetVertexAttribOffset(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionHint(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsContextLost(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsFramebuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsProgram(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsRenderbuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsShader(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsTexture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionLineWidth(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionLinkProgram(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionPixelStorei(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionPolygonOffset(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionReleaseShaderCompiler(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorage(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionSampleCoverage(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionScissor(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionShaderSource(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilFunc(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilFuncSeparate(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilMask(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilMaskSeparate(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilOp(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilOpSeparate(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexParameterf(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexParameteri(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1f(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2f(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3f(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4f(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1i(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2i(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3i(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4i(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUseProgram(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionValidateProgram(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1f(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2f(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3f(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4f(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1fv(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2fv(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3fv(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4fv(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribPointer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionViewport(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif

// Attributes

JSC::EncodedJSValue jsWebGL2RenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGL2RenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsWebGL2RenderingContextCanvas(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsWebGL2RenderingContextDrawingBufferWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsWebGL2RenderingContextDrawingBufferHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif

class JSWebGL2RenderingContextPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGL2RenderingContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGL2RenderingContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGL2RenderingContextPrototype>(vm.heap)) JSWebGL2RenderingContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGL2RenderingContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGL2RenderingContextPrototype, JSWebGL2RenderingContextPrototype::Base);

using JSWebGL2RenderingContextConstructor = JSDOMConstructorNotConstructable<JSWebGL2RenderingContext>;

/* Hash table for constructor */

static const HashTableValue JSWebGL2RenderingContextConstructorTableValues[] =
{
    { "READ_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C02) } },
    { "UNPACK_ROW_LENGTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0CF2) } },
    { "UNPACK_SKIP_ROWS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0CF3) } },
    { "UNPACK_SKIP_PIXELS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0CF4) } },
    { "PACK_ROW_LENGTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D02) } },
    { "PACK_SKIP_ROWS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D03) } },
    { "PACK_SKIP_PIXELS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D04) } },
    { "COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1800) } },
    { "DEPTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1801) } },
    { "STENCIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1802) } },
    { "RED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1903) } },
    { "RGB8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8051) } },
    { "RGBA8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8058) } },
    { "RGB10_A2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8059) } },
    { "TEXTURE_BINDING_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x806A) } },
    { "UNPACK_SKIP_IMAGES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x806D) } },
    { "UNPACK_IMAGE_HEIGHT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x806E) } },
    { "TEXTURE_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x806F) } },
    { "TEXTURE_WRAP_R", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8072) } },
    { "MAX_3D_TEXTURE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8073) } },
    { "UNSIGNED_INT_2_10_10_10_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8368) } },
    { "MAX_ELEMENTS_VERTICES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80E8) } },
    { "MAX_ELEMENTS_INDICES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80E9) } },
    { "TEXTURE_MIN_LOD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x813A) } },
    { "TEXTURE_MAX_LOD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x813B) } },
    { "TEXTURE_BASE_LEVEL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x813C) } },
    { "TEXTURE_MAX_LEVEL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x813D) } },
    { "MIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8007) } },
    { "MAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8008) } },
    { "DEPTH_COMPONENT24", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x81A6) } },
    { "MAX_TEXTURE_LOD_BIAS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84FD) } },
    { "TEXTURE_COMPARE_MODE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x884C) } },
    { "TEXTURE_COMPARE_FUNC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x884D) } },
    { "CURRENT_QUERY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8865) } },
    { "QUERY_RESULT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8866) } },
    { "QUERY_RESULT_AVAILABLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8867) } },
    { "STREAM_READ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E1) } },
    { "STREAM_COPY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E2) } },
    { "STATIC_READ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E5) } },
    { "STATIC_COPY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E6) } },
    { "DYNAMIC_READ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E9) } },
    { "DYNAMIC_COPY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88EA) } },
    { "MAX_DRAW_BUFFERS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8824) } },
    { "DRAW_BUFFER0", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8825) } },
    { "DRAW_BUFFER1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8826) } },
    { "DRAW_BUFFER2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8827) } },
    { "DRAW_BUFFER3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8828) } },
    { "DRAW_BUFFER4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8829) } },
    { "DRAW_BUFFER5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882A) } },
    { "DRAW_BUFFER6", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882B) } },
    { "DRAW_BUFFER7", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882C) } },
    { "DRAW_BUFFER8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882D) } },
    { "DRAW_BUFFER9", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882E) } },
    { "DRAW_BUFFER10", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882F) } },
    { "DRAW_BUFFER11", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8830) } },
    { "DRAW_BUFFER12", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8831) } },
    { "DRAW_BUFFER13", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8832) } },
    { "DRAW_BUFFER14", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8833) } },
    { "DRAW_BUFFER15", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8834) } },
    { "MAX_FRAGMENT_UNIFORM_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B49) } },
    { "MAX_VERTEX_UNIFORM_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4A) } },
    { "SAMPLER_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5F) } },
    { "SAMPLER_2D_SHADOW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B62) } },
    { "FRAGMENT_SHADER_DERIVATIVE_HINT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B8B) } },
    { "PIXEL_PACK_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88EB) } },
    { "PIXEL_UNPACK_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88EC) } },
    { "PIXEL_PACK_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88ED) } },
    { "PIXEL_UNPACK_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88EF) } },
    { "FLOAT_MAT2x3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B65) } },
    { "FLOAT_MAT2x4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B66) } },
    { "FLOAT_MAT3x2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B67) } },
    { "FLOAT_MAT3x4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B68) } },
    { "FLOAT_MAT4x2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B69) } },
    { "FLOAT_MAT4x3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B6A) } },
    { "SRGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C40) } },
    { "SRGB8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C41) } },
    { "SRGB8_ALPHA8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C43) } },
    { "COMPARE_REF_TO_TEXTURE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x884E) } },
    { "RGBA32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8814) } },
    { "RGB32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8815) } },
    { "RGBA16F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x881A) } },
    { "RGB16F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x881B) } },
    { "VERTEX_ATTRIB_ARRAY_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88FD) } },
    { "MAX_ARRAY_TEXTURE_LAYERS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88FF) } },
    { "MIN_PROGRAM_TEXEL_OFFSET", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8904) } },
    { "MAX_PROGRAM_TEXEL_OFFSET", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8905) } },
    { "MAX_VARYING_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4B) } },
    { "TEXTURE_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C1A) } },
    { "TEXTURE_BINDING_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C1D) } },
    { "R11F_G11F_B10F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C3A) } },
    { "UNSIGNED_INT_10F_11F_11F_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C3B) } },
    { "RGB9_E5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C3D) } },
    { "UNSIGNED_INT_5_9_9_9_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C3E) } },
    { "TRANSFORM_FEEDBACK_BUFFER_MODE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C7F) } },
    { "MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C80) } },
    { "TRANSFORM_FEEDBACK_VARYINGS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C83) } },
    { "TRANSFORM_FEEDBACK_BUFFER_START", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C84) } },
    { "TRANSFORM_FEEDBACK_BUFFER_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C85) } },
    { "TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C88) } },
    { "RASTERIZER_DISCARD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C89) } },
    { "MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8A) } },
    { "MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8B) } },
    { "INTERLEAVED_ATTRIBS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8C) } },
    { "SEPARATE_ATTRIBS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8D) } },
    { "TRANSFORM_FEEDBACK_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8E) } },
    { "TRANSFORM_FEEDBACK_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8F) } },
    { "RGBA32UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D70) } },
    { "RGB32UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D71) } },
    { "RGBA16UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D76) } },
    { "RGB16UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D77) } },
    { "RGBA8UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D7C) } },
    { "RGB8UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D7D) } },
    { "RGBA32I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D82) } },
    { "RGB32I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D83) } },
    { "RGBA16I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D88) } },
    { "RGB16I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D89) } },
    { "RGBA8I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D8E) } },
    { "RGB8I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D8F) } },
    { "RED_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D94) } },
    { "RGB_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D98) } },
    { "RGBA_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D99) } },
    { "SAMPLER_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC1) } },
    { "SAMPLER_2D_ARRAY_SHADOW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC4) } },
    { "SAMPLER_CUBE_SHADOW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC5) } },
    { "UNSIGNED_INT_VEC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC6) } },
    { "UNSIGNED_INT_VEC3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC7) } },
    { "UNSIGNED_INT_VEC4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC8) } },
    { "INT_SAMPLER_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DCA) } },
    { "INT_SAMPLER_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DCB) } },
    { "INT_SAMPLER_CUBE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DCC) } },
    { "INT_SAMPLER_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DCF) } },
    { "UNSIGNED_INT_SAMPLER_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DD2) } },
    { "UNSIGNED_INT_SAMPLER_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DD3) } },
    { "UNSIGNED_INT_SAMPLER_CUBE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DD4) } },
    { "UNSIGNED_INT_SAMPLER_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DD7) } },
    { "DEPTH_COMPONENT32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CAC) } },
    { "DEPTH32F_STENCIL8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CAD) } },
    { "FLOAT_32_UNSIGNED_INT_24_8_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DAD) } },
    { "FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8210) } },
    { "FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8211) } },
    { "FRAMEBUFFER_ATTACHMENT_RED_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8212) } },
    { "FRAMEBUFFER_ATTACHMENT_GREEN_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8213) } },
    { "FRAMEBUFFER_ATTACHMENT_BLUE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8214) } },
    { "FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8215) } },
    { "FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8216) } },
    { "FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8217) } },
    { "FRAMEBUFFER_DEFAULT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8218) } },
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x821A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84F9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "UNSIGNED_INT_24_8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84FA) } },
    { "DEPTH24_STENCIL8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88F0) } },
    { "UNSIGNED_NORMALIZED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C17) } },
    { "DRAW_FRAMEBUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA6) } },
    { "READ_FRAMEBUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA8) } },
    { "DRAW_FRAMEBUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA9) } },
    { "READ_FRAMEBUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CAA) } },
    { "RENDERBUFFER_SAMPLES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CAB) } },
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD4) } },
    { "MAX_COLOR_ATTACHMENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CDF) } },
    { "COLOR_ATTACHMENT1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE1) } },
    { "COLOR_ATTACHMENT2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE2) } },
    { "COLOR_ATTACHMENT3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE3) } },
    { "COLOR_ATTACHMENT4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE4) } },
    { "COLOR_ATTACHMENT5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE5) } },
    { "COLOR_ATTACHMENT6", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE6) } },
    { "COLOR_ATTACHMENT7", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE7) } },
    { "COLOR_ATTACHMENT8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE8) } },
    { "COLOR_ATTACHMENT9", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE9) } },
    { "COLOR_ATTACHMENT10", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEA) } },
    { "COLOR_ATTACHMENT11", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEB) } },
    { "COLOR_ATTACHMENT12", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEC) } },
    { "COLOR_ATTACHMENT13", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CED) } },
    { "COLOR_ATTACHMENT14", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEE) } },
    { "COLOR_ATTACHMENT15", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEF) } },
    { "FRAMEBUFFER_INCOMPLETE_MULTISAMPLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D56) } },
    { "MAX_SAMPLES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D57) } },
    { "HALF_FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x140B) } },
    { "RG", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8227) } },
    { "RG_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8228) } },
    { "R8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8229) } },
    { "RG8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x822B) } },
    { "R16F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x822D) } },
    { "R32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x822E) } },
    { "RG16F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x822F) } },
    { "RG32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8230) } },
    { "R8I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8231) } },
    { "R8UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8232) } },
    { "R16I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8233) } },
    { "R16UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8234) } },
    { "R32I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8235) } },
    { "R32UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8236) } },
    { "RG8I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8237) } },
    { "RG8UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8238) } },
    { "RG16I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8239) } },
    { "RG16UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x823A) } },
    { "RG32I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x823B) } },
    { "RG32UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x823C) } },
    { "VERTEX_ARRAY_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x85B5) } },
    { "R8_SNORM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F94) } },
    { "RG8_SNORM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F95) } },
    { "RGB8_SNORM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F96) } },
    { "RGBA8_SNORM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F97) } },
    { "SIGNED_NORMALIZED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F9C) } },
    { "COPY_READ_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F36) } },
    { "COPY_WRITE_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F37) } },
    { "COPY_READ_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F36) } },
    { "COPY_WRITE_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F37) } },
    { "UNIFORM_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A11) } },
    { "UNIFORM_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A28) } },
    { "UNIFORM_BUFFER_START", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A29) } },
    { "UNIFORM_BUFFER_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2A) } },
    { "MAX_VERTEX_UNIFORM_BLOCKS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2B) } },
    { "MAX_FRAGMENT_UNIFORM_BLOCKS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2D) } },
    { "MAX_COMBINED_UNIFORM_BLOCKS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2E) } },
    { "MAX_UNIFORM_BUFFER_BINDINGS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2F) } },
    { "MAX_UNIFORM_BLOCK_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A30) } },
    { "MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A31) } },
    { "MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A33) } },
    { "UNIFORM_BUFFER_OFFSET_ALIGNMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A34) } },
    { "ACTIVE_UNIFORM_BLOCKS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A36) } },
    { "UNIFORM_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A37) } },
    { "UNIFORM_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A38) } },
    { "UNIFORM_BLOCK_INDEX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3A) } },
    { "UNIFORM_OFFSET", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3B) } },
    { "UNIFORM_ARRAY_STRIDE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3C) } },
    { "UNIFORM_MATRIX_STRIDE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3D) } },
    { "UNIFORM_IS_ROW_MAJOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3E) } },
    { "UNIFORM_BLOCK_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3F) } },
    { "UNIFORM_BLOCK_DATA_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A40) } },
    { "UNIFORM_BLOCK_ACTIVE_UNIFORMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A42) } },
    { "UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A43) } },
    { "UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A44) } },
    { "UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A46) } },
    { "INVALID_INDEX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0xFFFFFFFF) } },
    { "MAX_VERTEX_OUTPUT_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9122) } },
    { "MAX_FRAGMENT_INPUT_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9125) } },
    { "MAX_SERVER_WAIT_TIMEOUT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9111) } },
    { "OBJECT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9112) } },
    { "SYNC_CONDITION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9113) } },
    { "SYNC_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9114) } },
    { "SYNC_FLAGS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9115) } },
    { "SYNC_FENCE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9116) } },
    { "SYNC_GPU_COMMANDS_COMPLETE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9117) } },
    { "UNSIGNALED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9118) } },
    { "SIGNALED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9119) } },
    { "ALREADY_SIGNALED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x911A) } },
    { "TIMEOUT_EXPIRED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x911B) } },
    { "CONDITION_SATISFIED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x911C) } },
    { "WAIT_FAILED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x911D) } },
    { "SYNC_FLUSH_COMMANDS_BIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00000001) } },
    { "VERTEX_ATTRIB_ARRAY_DIVISOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88FE) } },
    { "ANY_SAMPLES_PASSED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C2F) } },
    { "ANY_SAMPLES_PASSED_CONSERVATIVE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D6A) } },
    { "SAMPLER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8919) } },
    { "RGB10_A2UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x906F) } },
    { "INT_2_10_10_10_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D9F) } },
    { "TRANSFORM_FEEDBACK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8E22) } },
    { "TRANSFORM_FEEDBACK_PAUSED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8E23) } },
    { "TRANSFORM_FEEDBACK_ACTIVE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8E24) } },
    { "TRANSFORM_FEEDBACK_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8E25) } },
    { "TEXTURE_IMMUTABLE_FORMAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x912F) } },
    { "MAX_ELEMENT_INDEX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D6B) } },
    { "TEXTURE_IMMUTABLE_LEVELS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x82DF) } },
    { "TIMEOUT_IGNORED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(-1) } },
    { "MAX_CLIENT_WAIT_TIMEOUT_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9247) } },
#if ENABLE(WEBGL)
    { "DEPTH_BUFFER_BIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00000100) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BUFFER_BIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00000400) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_BUFFER_BIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00004000) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "POINTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0000) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0001) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINE_LOOP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0002) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINE_STRIP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0003) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0004) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLE_STRIP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0005) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLE_FAN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0006) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ZERO", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SRC_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0300) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_SRC_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0301) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SRC_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0302) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_SRC_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0303) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DST_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0304) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_DST_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0305) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DST_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0306) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_DST_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0307) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SRC_ALPHA_SATURATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0308) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_ADD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8006) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8009) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION_RGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8009) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x883D) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_SUBTRACT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x800A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_REVERSE_SUBTRACT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x800B) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_DST_RGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80C8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_SRC_RGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80C9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_DST_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80CA) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_SRC_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80CB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CONSTANT_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8001) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_CONSTANT_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8002) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CONSTANT_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8003) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_CONSTANT_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8004) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8005) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ARRAY_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8892) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ELEMENT_ARRAY_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8893) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ARRAY_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8894) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ELEMENT_ARRAY_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8895) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STREAM_DRAW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STATIC_DRAW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DYNAMIC_DRAW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BUFFER_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8764) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BUFFER_USAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8765) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CURRENT_VERTEX_ATTRIB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8626) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRONT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0404) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BACK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0405) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRONT_AND_BACK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0408) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0DE1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CULL_FACE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B44) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0BE2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DITHER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0BD0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_TEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B90) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_TEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B71) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SCISSOR_TEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C11) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_FILL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8037) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_ALPHA_TO_COVERAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x809E) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80A0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NO_ERROR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_ENUM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0500) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0501) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_OPERATION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0502) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "OUT_OF_MEMORY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0505) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0900) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CCW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0901) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINE_WIDTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B21) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALIASED_POINT_SIZE_RANGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x846D) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALIASED_LINE_WIDTH_RANGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x846E) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CULL_FACE_MODE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B45) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRONT_FACE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B46) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_RANGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B70) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_WRITEMASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B72) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_CLEAR_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B73) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_FUNC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B74) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_CLEAR_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B91) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_FUNC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B92) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_FAIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B94) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_PASS_DEPTH_FAIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B95) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_PASS_DEPTH_PASS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B96) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_REF", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B97) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_VALUE_MASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B93) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_WRITEMASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B98) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_FUNC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8800) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_FAIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8801) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_PASS_DEPTH_FAIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8802) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_PASS_DEPTH_PASS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8803) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_REF", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_VALUE_MASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_WRITEMASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VIEWPORT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0BA2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SCISSOR_BOX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C10) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_CLEAR_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C22) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_WRITEMASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C23) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_ALIGNMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0CF5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "PACK_ALIGNMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D05) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_TEXTURE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D33) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VIEWPORT_DIMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D3A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SUBPIXEL_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D50) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RED_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D52) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "GREEN_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D53) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLUE_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D54) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALPHA_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D55) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D56) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D57) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_UNITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2A00) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_FACTOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8038) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_BINDING_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8069) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_BUFFERS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80A8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80A9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80AA) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE_INVERT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80AB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COMPRESSED_TEXTURE_FORMATS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x86A3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DONT_CARE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1100) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FASTEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1101) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NICEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1102) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "GENERATE_MIPMAP_HINT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8192) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BYTE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1400) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_BYTE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1401) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SHORT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1402) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1403) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1404) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1405) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1406) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_COMPONENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1902) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1906) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1907) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGBA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1908) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LUMINANCE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1909) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LUMINANCE_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x190A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_4_4_4_4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8033) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_5_5_5_1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8034) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_5_6_5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8363) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAGMENT_SHADER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B30) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_SHADER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B31) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_ATTRIBS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8869) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_UNIFORM_VECTORS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DFB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VARYING_VECTORS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DFC) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_COMBINED_TEXTURE_IMAGE_UNITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4D) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_TEXTURE_IMAGE_UNITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4C) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_TEXTURE_IMAGE_UNITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8872) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_FRAGMENT_UNIFORM_VECTORS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DFD) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SHADER_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4F) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DELETE_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B80) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINK_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B82) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VALIDATE_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B83) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ATTACHED_SHADERS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B85) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_UNIFORMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B86) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_ATTRIBUTES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B89) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SHADING_LANGUAGE_VERSION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B8C) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CURRENT_PROGRAM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B8D) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NEVER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0200) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LESS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0201) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "EQUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0202) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LEQUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0203) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "GREATER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0204) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NOTEQUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0205) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "GEQUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0206) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALWAYS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0207) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "KEEP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1E00) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "REPLACE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1E01) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INCR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1E02) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DECR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1E03) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVERT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x150A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INCR_WRAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8507) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DECR_WRAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8508) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VENDOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1F00) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1F01) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERSION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1F02) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2600) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2601) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST_MIPMAP_NEAREST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2700) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR_MIPMAP_NEAREST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2701) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST_MIPMAP_LINEAR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2702) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR_MIPMAP_LINEAR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2703) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_MAG_FILTER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2800) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_MIN_FILTER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2801) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_WRAP_S", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2802) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_WRAP_T", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2803) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1702) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8513) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_BINDING_CUBE_MAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8514) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_X", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8515) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_X", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8516) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_Y", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8517) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_Y", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8518) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_Z", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8519) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_Z", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x851A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_CUBE_MAP_TEXTURE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x851C) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE0", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE6", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C6) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE7", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C7) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE9", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE10", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CA) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE11", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE12", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CC) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE13", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CD) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE14", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CE) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE15", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CF) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE16", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE17", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE18", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE19", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE20", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE21", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE22", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D6) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE23", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D7) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE24", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE25", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE26", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DA) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE27", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE28", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DC) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE29", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DD) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE30", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DE) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE31", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DF) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_TEXTURE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84E0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "REPEAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2901) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CLAMP_TO_EDGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x812F) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MIRRORED_REPEAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8370) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B50) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B51) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B52) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B53) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B54) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B55) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BOOL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B56) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B57) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B58) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B59) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5B) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5C) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLER_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5E) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLER_CUBE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B60) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_ENABLED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8622) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8623) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_STRIDE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8624) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8625) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_NORMALIZED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x886A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_POINTER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8645) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x889F) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "IMPLEMENTATION_COLOR_READ_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B9A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "IMPLEMENTATION_COLOR_READ_FORMAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B9B) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COMPILE_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B81) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LOW_FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MEDIUM_FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "HIGH_FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LOW_INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MEDIUM_INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "HIGH_INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D40) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D41) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGBA4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8056) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGB5_A1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8057) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGB565", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D62) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_COMPONENT16", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x81A5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_INDEX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1901) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_INDEX8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D48) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84F9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_WIDTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D42) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_HEIGHT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D43) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_INTERNAL_FORMAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D44) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_RED_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D50) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_GREEN_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D51) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_BLUE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D52) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_ALPHA_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D53) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_DEPTH_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D54) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_STENCIL_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D55) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_OBJECT_NAME", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_ATTACHMENT0", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D00) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D20) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x821A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_COMPLETE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD6) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD7) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_DIMENSIONS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_UNSUPPORTED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CDD) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA6) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA7) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_RENDERBUFFER_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84E8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_FRAMEBUFFER_OPERATION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0506) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_FLIP_Y_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9240) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_PREMULTIPLY_ALPHA_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9241) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CONTEXT_LOST_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9242) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_COLORSPACE_CONVERSION_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9243) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BROWSER_DEFAULT_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9244) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

template<> JSValue JSWebGL2RenderingContextConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGL2RenderingContextConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGL2RenderingContext::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WebGL2RenderingContext"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSWebGL2RenderingContext::info(), JSWebGL2RenderingContextConstructorTableValues, *this);
}

template<> const ClassInfo JSWebGL2RenderingContextConstructor::s_info = { "WebGL2RenderingContext", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGL2RenderingContextConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGL2RenderingContextPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGL2RenderingContextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGL2RenderingContextConstructor) } },
#if ENABLE(WEBGL)
    { "canvas", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGL2RenderingContextCanvas), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "drawingBufferWidth", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGL2RenderingContextDrawingBufferWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "drawingBufferHeight", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGL2RenderingContextDrawingBufferHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "bufferData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBufferData), (intptr_t) (3) } },
    { "bufferSubData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBufferSubData), (intptr_t) (3) } },
    { "copyBufferSubData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCopyBufferSubData), (intptr_t) (5) } },
    { "getBufferSubData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetBufferSubData), (intptr_t) (3) } },
    { "blitFramebuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBlitFramebuffer), (intptr_t) (10) } },
    { "framebufferTextureLayer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionFramebufferTextureLayer), (intptr_t) (5) } },
    { "invalidateFramebuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionInvalidateFramebuffer), (intptr_t) (2) } },
    { "invalidateSubFramebuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionInvalidateSubFramebuffer), (intptr_t) (6) } },
    { "readBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionReadBuffer), (intptr_t) (1) } },
    { "getInternalformatParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetInternalformatParameter), (intptr_t) (3) } },
    { "renderbufferStorageMultisample", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorageMultisample), (intptr_t) (5) } },
    { "texStorage2D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionTexStorage2D), (intptr_t) (5) } },
    { "texStorage3D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionTexStorage3D), (intptr_t) (6) } },
    { "texImage3D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionTexImage3D), (intptr_t) (10) } },
    { "texSubImage3D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D), (intptr_t) (11) } },
    { "copyTexSubImage3D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage3D), (intptr_t) (9) } },
    { "compressedTexImage3D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D), (intptr_t) (8) } },
    { "compressedTexSubImage3D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D), (intptr_t) (10) } },
    { "getFragDataLocation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetFragDataLocation), (intptr_t) (2) } },
    { "uniform1ui", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform1ui), (intptr_t) (2) } },
    { "uniform2ui", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform2ui), (intptr_t) (3) } },
    { "uniform3ui", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform3ui), (intptr_t) (4) } },
    { "uniform4ui", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform4ui), (intptr_t) (5) } },
    { "uniform1uiv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform1uiv), (intptr_t) (2) } },
    { "uniform2uiv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform2uiv), (intptr_t) (2) } },
    { "uniform3uiv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform3uiv), (intptr_t) (2) } },
    { "uniform4uiv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform4uiv), (intptr_t) (2) } },
    { "uniformMatrix2x3fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x3fv), (intptr_t) (3) } },
    { "uniformMatrix3x2fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x2fv), (intptr_t) (3) } },
    { "uniformMatrix2x4fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x4fv), (intptr_t) (3) } },
    { "uniformMatrix4x2fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x2fv), (intptr_t) (3) } },
    { "uniformMatrix3x4fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x4fv), (intptr_t) (3) } },
    { "uniformMatrix4x3fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x3fv), (intptr_t) (3) } },
    { "vertexAttribI4i", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4i), (intptr_t) (5) } },
    { "vertexAttribI4iv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4iv), (intptr_t) (2) } },
    { "vertexAttribI4ui", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4ui), (intptr_t) (5) } },
    { "vertexAttribI4uiv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4uiv), (intptr_t) (2) } },
    { "vertexAttribIPointer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttribIPointer), (intptr_t) (5) } },
    { "vertexAttribDivisor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttribDivisor), (intptr_t) (2) } },
    { "drawArraysInstanced", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDrawArraysInstanced), (intptr_t) (4) } },
    { "drawElementsInstanced", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDrawElementsInstanced), (intptr_t) (5) } },
    { "drawRangeElements", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDrawRangeElements), (intptr_t) (6) } },
    { "drawBuffers", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDrawBuffers), (intptr_t) (1) } },
    { "clearBufferiv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionClearBufferiv), (intptr_t) (3) } },
    { "clearBufferuiv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionClearBufferuiv), (intptr_t) (3) } },
    { "clearBufferfv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionClearBufferfv), (intptr_t) (3) } },
    { "clearBufferfi", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionClearBufferfi), (intptr_t) (4) } },
    { "createQuery", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateQuery), (intptr_t) (0) } },
    { "deleteQuery", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteQuery), (intptr_t) (1) } },
    { "isQuery", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsQuery), (intptr_t) (1) } },
    { "beginQuery", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBeginQuery), (intptr_t) (2) } },
    { "endQuery", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionEndQuery), (intptr_t) (1) } },
    { "getQuery", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetQuery), (intptr_t) (2) } },
    { "getQueryParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetQueryParameter), (intptr_t) (2) } },
    { "createSampler", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateSampler), (intptr_t) (0) } },
    { "deleteSampler", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteSampler), (intptr_t) (1) } },
    { "isSampler", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsSampler), (intptr_t) (1) } },
    { "bindSampler", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindSampler), (intptr_t) (2) } },
    { "samplerParameteri", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionSamplerParameteri), (intptr_t) (3) } },
    { "samplerParameterf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionSamplerParameterf), (intptr_t) (3) } },
    { "getSamplerParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetSamplerParameter), (intptr_t) (2) } },
    { "fenceSync", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionFenceSync), (intptr_t) (2) } },
    { "isSync", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsSync), (intptr_t) (1) } },
    { "deleteSync", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteSync), (intptr_t) (1) } },
    { "clientWaitSync", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionClientWaitSync), (intptr_t) (3) } },
    { "waitSync", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionWaitSync), (intptr_t) (3) } },
    { "getSyncParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetSyncParameter), (intptr_t) (2) } },
    { "createTransformFeedback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateTransformFeedback), (intptr_t) (0) } },
    { "deleteTransformFeedback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteTransformFeedback), (intptr_t) (1) } },
    { "isTransformFeedback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsTransformFeedback), (intptr_t) (1) } },
    { "bindTransformFeedback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindTransformFeedback), (intptr_t) (2) } },
    { "beginTransformFeedback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBeginTransformFeedback), (intptr_t) (1) } },
    { "endTransformFeedback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionEndTransformFeedback), (intptr_t) (0) } },
    { "transformFeedbackVaryings", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionTransformFeedbackVaryings), (intptr_t) (3) } },
    { "getTransformFeedbackVarying", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetTransformFeedbackVarying), (intptr_t) (2) } },
    { "pauseTransformFeedback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionPauseTransformFeedback), (intptr_t) (0) } },
    { "resumeTransformFeedback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionResumeTransformFeedback), (intptr_t) (0) } },
    { "bindBufferBase", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindBufferBase), (intptr_t) (3) } },
    { "bindBufferRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindBufferRange), (intptr_t) (5) } },
    { "getIndexedParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetIndexedParameter), (intptr_t) (2) } },
    { "getUniformIndices", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetUniformIndices), (intptr_t) (2) } },
    { "getActiveUniforms", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetActiveUniforms), (intptr_t) (3) } },
    { "getUniformBlockIndex", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetUniformBlockIndex), (intptr_t) (2) } },
    { "getActiveUniformBlockParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockParameter), (intptr_t) (3) } },
    { "getActiveUniformBlockName", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockName), (intptr_t) (2) } },
    { "uniformBlockBinding", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformBlockBinding), (intptr_t) (3) } },
    { "createVertexArray", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateVertexArray), (intptr_t) (0) } },
    { "deleteVertexArray", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteVertexArray), (intptr_t) (1) } },
    { "isVertexArray", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsVertexArray), (intptr_t) (1) } },
    { "bindVertexArray", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindVertexArray), (intptr_t) (1) } },
    { "texImage2D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionTexImage2D), (intptr_t) (6) } },
    { "texSubImage2D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D), (intptr_t) (7) } },
    { "compressedTexImage2D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D), (intptr_t) (7) } },
    { "compressedTexSubImage2D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D), (intptr_t) (8) } },
    { "uniform1fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform1fv), (intptr_t) (2) } },
    { "uniform2fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform2fv), (intptr_t) (2) } },
    { "uniform3fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform3fv), (intptr_t) (2) } },
    { "uniform4fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform4fv), (intptr_t) (2) } },
    { "uniform1iv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform1iv), (intptr_t) (2) } },
    { "uniform2iv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform2iv), (intptr_t) (2) } },
    { "uniform3iv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform3iv), (intptr_t) (2) } },
    { "uniform4iv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform4iv), (intptr_t) (2) } },
    { "uniformMatrix2fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fv), (intptr_t) (3) } },
    { "uniformMatrix3fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fv), (intptr_t) (3) } },
    { "uniformMatrix4fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fv), (intptr_t) (3) } },
    { "readPixels", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionReadPixels), (intptr_t) (7) } },
#if ENABLE(WEBGL)
    { "activeTexture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionActiveTexture), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "attachShader", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionAttachShader), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "bindAttribLocation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindAttribLocation), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "bindBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindBuffer), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "bindFramebuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindFramebuffer), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "bindRenderbuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindRenderbuffer), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "bindTexture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBindTexture), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "blendColor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBlendColor), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "blendEquation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBlendEquation), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "blendEquationSeparate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBlendEquationSeparate), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "blendFunc", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBlendFunc), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "blendFuncSeparate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionBlendFuncSeparate), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "checkFramebufferStatus", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCheckFramebufferStatus), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "clear", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionClear), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "clearColor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionClearColor), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "clearDepth", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionClearDepth), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "clearStencil", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionClearStencil), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "colorMask", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionColorMask), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "compileShader", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCompileShader), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "copyTexImage2D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCopyTexImage2D), (intptr_t) (8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "copyTexSubImage2D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage2D), (intptr_t) (8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "createBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateBuffer), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "createFramebuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateFramebuffer), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "createProgram", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateProgram), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "createRenderbuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateRenderbuffer), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "createShader", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateShader), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "createTexture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCreateTexture), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "cullFace", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionCullFace), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "deleteBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteBuffer), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "deleteFramebuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteFramebuffer), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "deleteProgram", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteProgram), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "deleteRenderbuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteRenderbuffer), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "deleteShader", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteShader), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "deleteTexture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDeleteTexture), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "depthFunc", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDepthFunc), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "depthMask", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDepthMask), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "depthRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDepthRange), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "detachShader", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDetachShader), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "disable", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDisable), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "disableVertexAttribArray", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDisableVertexAttribArray), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "drawArrays", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDrawArrays), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "drawElements", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionDrawElements), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "enable", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionEnable), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "enableVertexAttribArray", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionEnableVertexAttribArray), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "finish", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionFinish), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "flush", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionFlush), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "framebufferRenderbuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionFramebufferRenderbuffer), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "framebufferTexture2D", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionFramebufferTexture2D), (intptr_t) (5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "frontFace", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionFrontFace), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "generateMipmap", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGenerateMipmap), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getActiveAttrib", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetActiveAttrib), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getActiveUniform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetActiveUniform), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getAttachedShaders", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetAttachedShaders), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getAttribLocation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetAttribLocation), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getBufferParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetBufferParameter), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getContextAttributes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetContextAttributes), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getError", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetError), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getSupportedExtensions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetSupportedExtensions), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getExtension", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetExtension), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getFramebufferAttachmentParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetFramebufferAttachmentParameter), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetParameter), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getProgramParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetProgramParameter), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getProgramInfoLog", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetProgramInfoLog), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getRenderbufferParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetRenderbufferParameter), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getShaderParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetShaderParameter), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getShaderInfoLog", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetShaderInfoLog), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getShaderPrecisionFormat", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetShaderPrecisionFormat), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getShaderSource", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetShaderSource), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getTexParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetTexParameter), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getUniform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetUniform), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getUniformLocation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetUniformLocation), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getVertexAttrib", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetVertexAttrib), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "getVertexAttribOffset", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionGetVertexAttribOffset), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "hint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionHint), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "isBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsBuffer), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "isContextLost", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsContextLost), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "isEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsEnabled), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "isFramebuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsFramebuffer), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "isProgram", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsProgram), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "isRenderbuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsRenderbuffer), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "isShader", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsShader), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "isTexture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionIsTexture), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "lineWidth", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionLineWidth), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "linkProgram", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionLinkProgram), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "pixelStorei", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionPixelStorei), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "polygonOffset", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionPolygonOffset), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "releaseShaderCompiler", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionReleaseShaderCompiler), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "renderbufferStorage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorage), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "sampleCoverage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionSampleCoverage), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "scissor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionScissor), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "shaderSource", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionShaderSource), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "stencilFunc", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionStencilFunc), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "stencilFuncSeparate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionStencilFuncSeparate), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "stencilMask", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionStencilMask), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "stencilMaskSeparate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionStencilMaskSeparate), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "stencilOp", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionStencilOp), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "stencilOpSeparate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionStencilOpSeparate), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "texParameterf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionTexParameterf), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "texParameteri", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionTexParameteri), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "uniform1f", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform1f), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "uniform2f", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform2f), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "uniform3f", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform3f), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "uniform4f", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform4f), (intptr_t) (5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "uniform1i", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform1i), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "uniform2i", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform2i), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "uniform3i", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform3i), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "uniform4i", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUniform4i), (intptr_t) (5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "useProgram", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionUseProgram), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "validateProgram", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionValidateProgram), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib1f", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1f), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib2f", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2f), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib3f", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3f), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib4f", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4f), (intptr_t) (5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib1fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1fv), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib2fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2fv), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib3fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3fv), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttrib4fv", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4fv), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "vertexAttribPointer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionVertexAttribPointer), (intptr_t) (6) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "viewport", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGL2RenderingContextPrototypeFunctionViewport), (intptr_t) (4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "READ_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C02) } },
    { "UNPACK_ROW_LENGTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0CF2) } },
    { "UNPACK_SKIP_ROWS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0CF3) } },
    { "UNPACK_SKIP_PIXELS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0CF4) } },
    { "PACK_ROW_LENGTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D02) } },
    { "PACK_SKIP_ROWS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D03) } },
    { "PACK_SKIP_PIXELS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D04) } },
    { "COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1800) } },
    { "DEPTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1801) } },
    { "STENCIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1802) } },
    { "RED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1903) } },
    { "RGB8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8051) } },
    { "RGBA8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8058) } },
    { "RGB10_A2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8059) } },
    { "TEXTURE_BINDING_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x806A) } },
    { "UNPACK_SKIP_IMAGES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x806D) } },
    { "UNPACK_IMAGE_HEIGHT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x806E) } },
    { "TEXTURE_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x806F) } },
    { "TEXTURE_WRAP_R", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8072) } },
    { "MAX_3D_TEXTURE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8073) } },
    { "UNSIGNED_INT_2_10_10_10_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8368) } },
    { "MAX_ELEMENTS_VERTICES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80E8) } },
    { "MAX_ELEMENTS_INDICES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80E9) } },
    { "TEXTURE_MIN_LOD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x813A) } },
    { "TEXTURE_MAX_LOD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x813B) } },
    { "TEXTURE_BASE_LEVEL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x813C) } },
    { "TEXTURE_MAX_LEVEL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x813D) } },
    { "MIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8007) } },
    { "MAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8008) } },
    { "DEPTH_COMPONENT24", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x81A6) } },
    { "MAX_TEXTURE_LOD_BIAS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84FD) } },
    { "TEXTURE_COMPARE_MODE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x884C) } },
    { "TEXTURE_COMPARE_FUNC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x884D) } },
    { "CURRENT_QUERY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8865) } },
    { "QUERY_RESULT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8866) } },
    { "QUERY_RESULT_AVAILABLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8867) } },
    { "STREAM_READ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E1) } },
    { "STREAM_COPY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E2) } },
    { "STATIC_READ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E5) } },
    { "STATIC_COPY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E6) } },
    { "DYNAMIC_READ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E9) } },
    { "DYNAMIC_COPY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88EA) } },
    { "MAX_DRAW_BUFFERS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8824) } },
    { "DRAW_BUFFER0", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8825) } },
    { "DRAW_BUFFER1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8826) } },
    { "DRAW_BUFFER2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8827) } },
    { "DRAW_BUFFER3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8828) } },
    { "DRAW_BUFFER4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8829) } },
    { "DRAW_BUFFER5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882A) } },
    { "DRAW_BUFFER6", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882B) } },
    { "DRAW_BUFFER7", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882C) } },
    { "DRAW_BUFFER8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882D) } },
    { "DRAW_BUFFER9", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882E) } },
    { "DRAW_BUFFER10", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x882F) } },
    { "DRAW_BUFFER11", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8830) } },
    { "DRAW_BUFFER12", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8831) } },
    { "DRAW_BUFFER13", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8832) } },
    { "DRAW_BUFFER14", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8833) } },
    { "DRAW_BUFFER15", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8834) } },
    { "MAX_FRAGMENT_UNIFORM_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B49) } },
    { "MAX_VERTEX_UNIFORM_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4A) } },
    { "SAMPLER_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5F) } },
    { "SAMPLER_2D_SHADOW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B62) } },
    { "FRAGMENT_SHADER_DERIVATIVE_HINT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B8B) } },
    { "PIXEL_PACK_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88EB) } },
    { "PIXEL_UNPACK_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88EC) } },
    { "PIXEL_PACK_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88ED) } },
    { "PIXEL_UNPACK_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88EF) } },
    { "FLOAT_MAT2x3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B65) } },
    { "FLOAT_MAT2x4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B66) } },
    { "FLOAT_MAT3x2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B67) } },
    { "FLOAT_MAT3x4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B68) } },
    { "FLOAT_MAT4x2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B69) } },
    { "FLOAT_MAT4x3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B6A) } },
    { "SRGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C40) } },
    { "SRGB8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C41) } },
    { "SRGB8_ALPHA8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C43) } },
    { "COMPARE_REF_TO_TEXTURE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x884E) } },
    { "RGBA32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8814) } },
    { "RGB32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8815) } },
    { "RGBA16F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x881A) } },
    { "RGB16F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x881B) } },
    { "VERTEX_ATTRIB_ARRAY_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88FD) } },
    { "MAX_ARRAY_TEXTURE_LAYERS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88FF) } },
    { "MIN_PROGRAM_TEXEL_OFFSET", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8904) } },
    { "MAX_PROGRAM_TEXEL_OFFSET", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8905) } },
    { "MAX_VARYING_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4B) } },
    { "TEXTURE_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C1A) } },
    { "TEXTURE_BINDING_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C1D) } },
    { "R11F_G11F_B10F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C3A) } },
    { "UNSIGNED_INT_10F_11F_11F_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C3B) } },
    { "RGB9_E5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C3D) } },
    { "UNSIGNED_INT_5_9_9_9_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C3E) } },
    { "TRANSFORM_FEEDBACK_BUFFER_MODE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C7F) } },
    { "MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C80) } },
    { "TRANSFORM_FEEDBACK_VARYINGS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C83) } },
    { "TRANSFORM_FEEDBACK_BUFFER_START", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C84) } },
    { "TRANSFORM_FEEDBACK_BUFFER_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C85) } },
    { "TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C88) } },
    { "RASTERIZER_DISCARD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C89) } },
    { "MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8A) } },
    { "MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8B) } },
    { "INTERLEAVED_ATTRIBS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8C) } },
    { "SEPARATE_ATTRIBS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8D) } },
    { "TRANSFORM_FEEDBACK_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8E) } },
    { "TRANSFORM_FEEDBACK_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C8F) } },
    { "RGBA32UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D70) } },
    { "RGB32UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D71) } },
    { "RGBA16UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D76) } },
    { "RGB16UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D77) } },
    { "RGBA8UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D7C) } },
    { "RGB8UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D7D) } },
    { "RGBA32I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D82) } },
    { "RGB32I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D83) } },
    { "RGBA16I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D88) } },
    { "RGB16I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D89) } },
    { "RGBA8I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D8E) } },
    { "RGB8I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D8F) } },
    { "RED_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D94) } },
    { "RGB_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D98) } },
    { "RGBA_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D99) } },
    { "SAMPLER_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC1) } },
    { "SAMPLER_2D_ARRAY_SHADOW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC4) } },
    { "SAMPLER_CUBE_SHADOW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC5) } },
    { "UNSIGNED_INT_VEC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC6) } },
    { "UNSIGNED_INT_VEC3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC7) } },
    { "UNSIGNED_INT_VEC4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DC8) } },
    { "INT_SAMPLER_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DCA) } },
    { "INT_SAMPLER_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DCB) } },
    { "INT_SAMPLER_CUBE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DCC) } },
    { "INT_SAMPLER_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DCF) } },
    { "UNSIGNED_INT_SAMPLER_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DD2) } },
    { "UNSIGNED_INT_SAMPLER_3D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DD3) } },
    { "UNSIGNED_INT_SAMPLER_CUBE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DD4) } },
    { "UNSIGNED_INT_SAMPLER_2D_ARRAY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DD7) } },
    { "DEPTH_COMPONENT32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CAC) } },
    { "DEPTH32F_STENCIL8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CAD) } },
    { "FLOAT_32_UNSIGNED_INT_24_8_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DAD) } },
    { "FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8210) } },
    { "FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8211) } },
    { "FRAMEBUFFER_ATTACHMENT_RED_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8212) } },
    { "FRAMEBUFFER_ATTACHMENT_GREEN_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8213) } },
    { "FRAMEBUFFER_ATTACHMENT_BLUE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8214) } },
    { "FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8215) } },
    { "FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8216) } },
    { "FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8217) } },
    { "FRAMEBUFFER_DEFAULT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8218) } },
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x821A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84F9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "UNSIGNED_INT_24_8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84FA) } },
    { "DEPTH24_STENCIL8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88F0) } },
    { "UNSIGNED_NORMALIZED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C17) } },
    { "DRAW_FRAMEBUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA6) } },
    { "READ_FRAMEBUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA8) } },
    { "DRAW_FRAMEBUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA9) } },
    { "READ_FRAMEBUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CAA) } },
    { "RENDERBUFFER_SAMPLES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CAB) } },
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD4) } },
    { "MAX_COLOR_ATTACHMENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CDF) } },
    { "COLOR_ATTACHMENT1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE1) } },
    { "COLOR_ATTACHMENT2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE2) } },
    { "COLOR_ATTACHMENT3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE3) } },
    { "COLOR_ATTACHMENT4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE4) } },
    { "COLOR_ATTACHMENT5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE5) } },
    { "COLOR_ATTACHMENT6", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE6) } },
    { "COLOR_ATTACHMENT7", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE7) } },
    { "COLOR_ATTACHMENT8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE8) } },
    { "COLOR_ATTACHMENT9", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE9) } },
    { "COLOR_ATTACHMENT10", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEA) } },
    { "COLOR_ATTACHMENT11", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEB) } },
    { "COLOR_ATTACHMENT12", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEC) } },
    { "COLOR_ATTACHMENT13", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CED) } },
    { "COLOR_ATTACHMENT14", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEE) } },
    { "COLOR_ATTACHMENT15", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CEF) } },
    { "FRAMEBUFFER_INCOMPLETE_MULTISAMPLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D56) } },
    { "MAX_SAMPLES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D57) } },
    { "HALF_FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x140B) } },
    { "RG", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8227) } },
    { "RG_INTEGER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8228) } },
    { "R8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8229) } },
    { "RG8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x822B) } },
    { "R16F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x822D) } },
    { "R32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x822E) } },
    { "RG16F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x822F) } },
    { "RG32F", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8230) } },
    { "R8I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8231) } },
    { "R8UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8232) } },
    { "R16I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8233) } },
    { "R16UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8234) } },
    { "R32I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8235) } },
    { "R32UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8236) } },
    { "RG8I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8237) } },
    { "RG8UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8238) } },
    { "RG16I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8239) } },
    { "RG16UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x823A) } },
    { "RG32I", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x823B) } },
    { "RG32UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x823C) } },
    { "VERTEX_ARRAY_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x85B5) } },
    { "R8_SNORM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F94) } },
    { "RG8_SNORM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F95) } },
    { "RGB8_SNORM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F96) } },
    { "RGBA8_SNORM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F97) } },
    { "SIGNED_NORMALIZED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F9C) } },
    { "COPY_READ_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F36) } },
    { "COPY_WRITE_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F37) } },
    { "COPY_READ_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F36) } },
    { "COPY_WRITE_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8F37) } },
    { "UNIFORM_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A11) } },
    { "UNIFORM_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A28) } },
    { "UNIFORM_BUFFER_START", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A29) } },
    { "UNIFORM_BUFFER_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2A) } },
    { "MAX_VERTEX_UNIFORM_BLOCKS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2B) } },
    { "MAX_FRAGMENT_UNIFORM_BLOCKS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2D) } },
    { "MAX_COMBINED_UNIFORM_BLOCKS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2E) } },
    { "MAX_UNIFORM_BUFFER_BINDINGS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A2F) } },
    { "MAX_UNIFORM_BLOCK_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A30) } },
    { "MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A31) } },
    { "MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A33) } },
    { "UNIFORM_BUFFER_OFFSET_ALIGNMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A34) } },
    { "ACTIVE_UNIFORM_BLOCKS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A36) } },
    { "UNIFORM_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A37) } },
    { "UNIFORM_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A38) } },
    { "UNIFORM_BLOCK_INDEX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3A) } },
    { "UNIFORM_OFFSET", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3B) } },
    { "UNIFORM_ARRAY_STRIDE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3C) } },
    { "UNIFORM_MATRIX_STRIDE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3D) } },
    { "UNIFORM_IS_ROW_MAJOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3E) } },
    { "UNIFORM_BLOCK_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A3F) } },
    { "UNIFORM_BLOCK_DATA_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A40) } },
    { "UNIFORM_BLOCK_ACTIVE_UNIFORMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A42) } },
    { "UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A43) } },
    { "UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A44) } },
    { "UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8A46) } },
    { "INVALID_INDEX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0xFFFFFFFF) } },
    { "MAX_VERTEX_OUTPUT_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9122) } },
    { "MAX_FRAGMENT_INPUT_COMPONENTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9125) } },
    { "MAX_SERVER_WAIT_TIMEOUT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9111) } },
    { "OBJECT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9112) } },
    { "SYNC_CONDITION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9113) } },
    { "SYNC_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9114) } },
    { "SYNC_FLAGS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9115) } },
    { "SYNC_FENCE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9116) } },
    { "SYNC_GPU_COMMANDS_COMPLETE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9117) } },
    { "UNSIGNALED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9118) } },
    { "SIGNALED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9119) } },
    { "ALREADY_SIGNALED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x911A) } },
    { "TIMEOUT_EXPIRED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x911B) } },
    { "CONDITION_SATISFIED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x911C) } },
    { "WAIT_FAILED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x911D) } },
    { "SYNC_FLUSH_COMMANDS_BIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00000001) } },
    { "VERTEX_ATTRIB_ARRAY_DIVISOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88FE) } },
    { "ANY_SAMPLES_PASSED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C2F) } },
    { "ANY_SAMPLES_PASSED_CONSERVATIVE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D6A) } },
    { "SAMPLER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8919) } },
    { "RGB10_A2UI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x906F) } },
    { "INT_2_10_10_10_REV", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D9F) } },
    { "TRANSFORM_FEEDBACK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8E22) } },
    { "TRANSFORM_FEEDBACK_PAUSED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8E23) } },
    { "TRANSFORM_FEEDBACK_ACTIVE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8E24) } },
    { "TRANSFORM_FEEDBACK_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8E25) } },
    { "TEXTURE_IMMUTABLE_FORMAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x912F) } },
    { "MAX_ELEMENT_INDEX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D6B) } },
    { "TEXTURE_IMMUTABLE_LEVELS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x82DF) } },
    { "TIMEOUT_IGNORED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(-1) } },
    { "MAX_CLIENT_WAIT_TIMEOUT_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9247) } },
#if ENABLE(WEBGL)
    { "DEPTH_BUFFER_BIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00000100) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BUFFER_BIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00000400) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_BUFFER_BIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00004000) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "POINTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0000) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0001) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINE_LOOP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0002) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINE_STRIP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0003) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0004) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLE_STRIP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0005) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TRIANGLE_FAN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0006) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ZERO", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SRC_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0300) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_SRC_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0301) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SRC_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0302) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_SRC_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0303) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DST_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0304) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_DST_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0305) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DST_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0306) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_DST_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0307) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SRC_ALPHA_SATURATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0308) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_ADD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8006) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8009) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION_RGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8009) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_EQUATION_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x883D) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_SUBTRACT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x800A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FUNC_REVERSE_SUBTRACT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x800B) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_DST_RGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80C8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_SRC_RGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80C9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_DST_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80CA) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_SRC_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80CB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CONSTANT_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8001) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_CONSTANT_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8002) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CONSTANT_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8003) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ONE_MINUS_CONSTANT_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8004) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8005) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ARRAY_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8892) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ELEMENT_ARRAY_BUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8893) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ARRAY_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8894) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ELEMENT_ARRAY_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8895) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STREAM_DRAW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STATIC_DRAW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DYNAMIC_DRAW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88E8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BUFFER_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8764) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BUFFER_USAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8765) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CURRENT_VERTEX_ATTRIB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8626) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRONT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0404) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BACK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0405) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRONT_AND_BACK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0408) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0DE1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CULL_FACE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B44) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLEND", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0BE2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DITHER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0BD0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_TEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B90) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_TEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B71) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SCISSOR_TEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C11) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_FILL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8037) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_ALPHA_TO_COVERAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x809E) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80A0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NO_ERROR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_ENUM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0500) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0501) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_OPERATION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0502) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "OUT_OF_MEMORY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0505) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0900) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CCW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0901) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINE_WIDTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B21) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALIASED_POINT_SIZE_RANGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x846D) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALIASED_LINE_WIDTH_RANGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x846E) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CULL_FACE_MODE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B45) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRONT_FACE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B46) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_RANGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B70) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_WRITEMASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B72) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_CLEAR_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B73) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_FUNC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B74) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_CLEAR_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B91) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_FUNC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B92) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_FAIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B94) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_PASS_DEPTH_FAIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B95) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_PASS_DEPTH_PASS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B96) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_REF", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B97) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_VALUE_MASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B93) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_WRITEMASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0B98) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_FUNC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8800) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_FAIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8801) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_PASS_DEPTH_FAIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8802) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_PASS_DEPTH_PASS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8803) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_REF", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_VALUE_MASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BACK_WRITEMASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VIEWPORT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0BA2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SCISSOR_BOX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C10) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_CLEAR_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C22) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_WRITEMASK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0C23) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_ALIGNMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0CF5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "PACK_ALIGNMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D05) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_TEXTURE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D33) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VIEWPORT_DIMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D3A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SUBPIXEL_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D50) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RED_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D52) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "GREEN_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D53) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BLUE_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D54) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALPHA_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D55) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D56) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_BITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0D57) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_UNITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2A00) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "POLYGON_OFFSET_FACTOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8038) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_BINDING_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8069) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_BUFFERS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80A8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80A9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80AA) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLE_COVERAGE_INVERT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x80AB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COMPRESSED_TEXTURE_FORMATS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x86A3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DONT_CARE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1100) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FASTEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1101) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NICEST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1102) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "GENERATE_MIPMAP_HINT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8192) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BYTE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1400) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_BYTE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1401) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SHORT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1402) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1403) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1404) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1405) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1406) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_COMPONENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1902) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1906) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGB", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1907) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGBA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1908) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LUMINANCE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1909) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LUMINANCE_ALPHA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x190A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_4_4_4_4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8033) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_5_5_5_1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8034) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNSIGNED_SHORT_5_6_5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8363) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAGMENT_SHADER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B30) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_SHADER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B31) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_ATTRIBS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8869) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_UNIFORM_VECTORS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DFB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VARYING_VECTORS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DFC) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_COMBINED_TEXTURE_IMAGE_UNITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4D) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_VERTEX_TEXTURE_IMAGE_UNITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4C) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_TEXTURE_IMAGE_UNITS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8872) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_FRAGMENT_UNIFORM_VECTORS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DFD) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SHADER_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B4F) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DELETE_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B80) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINK_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B82) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VALIDATE_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B83) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ATTACHED_SHADERS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B85) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_UNIFORMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B86) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_ATTRIBUTES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B89) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SHADING_LANGUAGE_VERSION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B8C) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CURRENT_PROGRAM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B8D) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NEVER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0200) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LESS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0201) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "EQUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0202) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LEQUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0203) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "GREATER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0204) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NOTEQUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0205) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "GEQUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0206) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ALWAYS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0207) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "KEEP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1E00) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "REPLACE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1E01) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INCR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1E02) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DECR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1E03) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVERT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x150A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INCR_WRAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8507) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DECR_WRAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8508) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VENDOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1F00) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1F01) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERSION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1F02) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2600) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2601) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST_MIPMAP_NEAREST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2700) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR_MIPMAP_NEAREST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2701) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NEAREST_MIPMAP_LINEAR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2702) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LINEAR_MIPMAP_LINEAR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2703) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_MAG_FILTER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2800) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_MIN_FILTER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2801) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_WRAP_S", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2802) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_WRAP_T", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2803) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1702) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8513) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_BINDING_CUBE_MAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8514) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_X", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8515) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_X", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8516) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_Y", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8517) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_Y", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8518) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_POSITIVE_Z", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8519) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE_CUBE_MAP_NEGATIVE_Z", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x851A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_CUBE_MAP_TEXTURE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x851C) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE0", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE5", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE6", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C6) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE7", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C7) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE9", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84C9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE10", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CA) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE11", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE12", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CC) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE13", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CD) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE14", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CE) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE15", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84CF) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE16", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE17", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE18", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE19", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE20", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE21", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE22", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D6) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE23", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D7) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE24", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE25", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84D9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE26", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DA) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE27", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DB) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE28", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DC) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE29", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DD) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE30", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DE) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "TEXTURE31", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84DF) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "ACTIVE_TEXTURE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84E0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "REPEAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x2901) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CLAMP_TO_EDGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x812F) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MIRRORED_REPEAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8370) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B50) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B51) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_VEC4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B52) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B53) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B54) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INT_VEC4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B55) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BOOL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B56) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B57) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B58) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BOOL_VEC4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B59) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT2", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT3", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5B) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FLOAT_MAT4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5C) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLER_2D", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B5E) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "SAMPLER_CUBE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B60) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_ENABLED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8622) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8623) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_STRIDE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8624) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8625) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_NORMALIZED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x886A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_POINTER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8645) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "VERTEX_ATTRIB_ARRAY_BUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x889F) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "IMPLEMENTATION_COLOR_READ_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B9A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "IMPLEMENTATION_COLOR_READ_FORMAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B9B) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COMPILE_STATUS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B81) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LOW_FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MEDIUM_FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "HIGH_FLOAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "LOW_INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MEDIUM_INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF4) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "HIGH_INT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8DF5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D40) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D41) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGBA4", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8056) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGB5_A1", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8057) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RGB565", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D62) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_COMPONENT16", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x81A5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_INDEX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x1901) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_INDEX8", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D48) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84F9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_WIDTH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D42) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_HEIGHT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D43) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_INTERNAL_FORMAT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D44) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_RED_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D50) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_GREEN_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D51) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_BLUE_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D52) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_ALPHA_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D53) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_DEPTH_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D54) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_STENCIL_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D55) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_OBJECT_NAME", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "COLOR_ATTACHMENT0", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CE0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D00) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "STENCIL_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8D20) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "DEPTH_STENCIL_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x821A) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "NONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_COMPLETE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD6) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD7) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_INCOMPLETE_DIMENSIONS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CD9) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_UNSUPPORTED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CDD) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "FRAMEBUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA6) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "RENDERBUFFER_BINDING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8CA7) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "MAX_RENDERBUFFER_SIZE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x84E8) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "INVALID_FRAMEBUFFER_OPERATION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x0506) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_FLIP_Y_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9240) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_PREMULTIPLY_ALPHA_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9241) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "CONTEXT_LOST_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9242) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "UNPACK_COLORSPACE_CONVERSION_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9243) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "BROWSER_DEFAULT_WEBGL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x9244) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSWebGL2RenderingContextPrototype::s_info = { "WebGL2RenderingContextPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGL2RenderingContextPrototype) };

void JSWebGL2RenderingContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGL2RenderingContext::info(), JSWebGL2RenderingContextPrototypeTableValues, *this);
}

const ClassInfo JSWebGL2RenderingContext::s_info = { "WebGL2RenderingContext", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGL2RenderingContext) };

JSWebGL2RenderingContext::JSWebGL2RenderingContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGL2RenderingContext>&& impl)
    : JSDOMWrapper<WebGL2RenderingContext>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGL2RenderingContext::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, WebGL2RenderingContext>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSWebGL2RenderingContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGL2RenderingContextPrototype::create(vm, &globalObject, JSWebGL2RenderingContextPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGL2RenderingContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGL2RenderingContext>(vm, globalObject);
}

JSValue JSWebGL2RenderingContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGL2RenderingContextConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGL2RenderingContext::destroy(JSC::JSCell* cell)
{
    JSWebGL2RenderingContext* thisObject = static_cast<JSWebGL2RenderingContext*>(cell);
    thisObject->JSWebGL2RenderingContext::~JSWebGL2RenderingContext();
}

template<> inline JSWebGL2RenderingContext* IDLAttribute<JSWebGL2RenderingContext>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWebGL2RenderingContext*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSWebGL2RenderingContext* IDLOperation<JSWebGL2RenderingContext>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGL2RenderingContext*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebGL2RenderingContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGL2RenderingContextPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGL2RenderingContext::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGL2RenderingContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGL2RenderingContextPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

#if ENABLE(WEBGL)
static inline JSValue jsWebGL2RenderingContextCanvasGetter(JSGlobalObject& lexicalGlobalObject, JSWebGL2RenderingContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLInterface<HTMLCanvasElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas());
    return result;
}

EncodedJSValue jsWebGL2RenderingContextCanvas(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebGL2RenderingContext>::get<jsWebGL2RenderingContextCanvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "canvas");
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWebGL2RenderingContextDrawingBufferWidthGetter(JSGlobalObject& lexicalGlobalObject, JSWebGL2RenderingContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.drawingBufferWidth());
    return result;
}

EncodedJSValue jsWebGL2RenderingContextDrawingBufferWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebGL2RenderingContext>::get<jsWebGL2RenderingContextDrawingBufferWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "drawingBufferWidth");
}

#endif

#if ENABLE(WEBGL)
static inline JSValue jsWebGL2RenderingContextDrawingBufferHeightGetter(JSGlobalObject& lexicalGlobalObject, JSWebGL2RenderingContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.drawingBufferHeight());
    return result;
}

EncodedJSValue jsWebGL2RenderingContextDrawingBufferHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebGL2RenderingContext>::get<jsWebGL2RenderingContextDrawingBufferHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "drawingBufferHeight");
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBufferData1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "data", "WebGL2RenderingContext", "bufferData", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto usage = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto length = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bufferData"_s, { target, data, usage, srcOffset, length });
    impl.bufferData(WTFMove(target), data.releaseNonNull(), WTFMove(usage), WTFMove(srcOffset), WTFMove(length));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBufferSubData1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstByteOffset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "srcData", "WebGL2RenderingContext", "bufferSubData", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto length = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bufferSubData"_s, { target, dstByteOffset, srcData, srcOffset, length });
    impl.bufferSubData(WTFMove(target), WTFMove(dstByteOffset), srcData.releaseNonNull(), WTFMove(srcOffset), WTFMove(length));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCopyBufferSubDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto readTarget = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto writeTarget = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto readOffset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto writeOffset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto size = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "copyBufferSubData"_s, { readTarget, writeTarget, readOffset, writeOffset, size });
    impl.copyBufferSubData(WTFMove(readTarget), WTFMove(writeTarget), WTFMove(readOffset), WTFMove(writeOffset), WTFMove(size));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCopyBufferSubData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCopyBufferSubDataBody>(*lexicalGlobalObject, *callFrame, "copyBufferSubData");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetBufferSubDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcByteOffset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "dstData", "WebGL2RenderingContext", "getBufferSubData", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto length = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getBufferSubData"_s, { target, srcByteOffset, dstData, dstOffset, length });
    impl.getBufferSubData(WTFMove(target), WTFMove(srcByteOffset), dstData.releaseNonNull(), WTFMove(dstOffset), WTFMove(length));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetBufferSubData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetBufferSubDataBody>(*lexicalGlobalObject, *callFrame, "getBufferSubData");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBlitFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 10))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto srcX0 = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcY0 = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcX1 = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcY1 = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstX0 = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstY0 = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstX1 = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstY1 = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto filter = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "blitFramebuffer"_s, { srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter });
    impl.blitFramebuffer(WTFMove(srcX0), WTFMove(srcY0), WTFMove(srcX1), WTFMove(srcY1), WTFMove(dstX0), WTFMove(dstY0), WTFMove(dstX1), WTFMove(dstY1), WTFMove(mask), WTFMove(filter));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlitFramebuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBlitFramebufferBody>(*lexicalGlobalObject, *callFrame, "blitFramebuffer");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionFramebufferTextureLayerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto attachment = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto texture = convert<IDLNullable<IDLInterface<WebGLTexture>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "texture", "WebGL2RenderingContext", "framebufferTextureLayer", "WebGLTexture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto layer = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "framebufferTextureLayer"_s, { target, attachment, texture, level, layer });
    impl.framebufferTextureLayer(WTFMove(target), WTFMove(attachment), WTFMove(texture), WTFMove(level), WTFMove(layer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFramebufferTextureLayer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionFramebufferTextureLayerBody>(*lexicalGlobalObject, *callFrame, "framebufferTextureLayer");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionInvalidateFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto attachments = convert<IDLSequence<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "invalidateFramebuffer"_s, { target, attachments });
    impl.invalidateFramebuffer(WTFMove(target), WTFMove(attachments));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionInvalidateFramebuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionInvalidateFramebufferBody>(*lexicalGlobalObject, *callFrame, "invalidateFramebuffer");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionInvalidateSubFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto attachments = convert<IDLSequence<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "invalidateSubFramebuffer"_s, { target, attachments, x, y, width, height });
    impl.invalidateSubFramebuffer(WTFMove(target), WTFMove(attachments), WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionInvalidateSubFramebuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionInvalidateSubFramebufferBody>(*lexicalGlobalObject, *callFrame, "invalidateSubFramebuffer");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionReadBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto src = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "readBuffer"_s, { src });
    impl.readBuffer(WTFMove(src));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionReadBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionReadBufferBody>(*lexicalGlobalObject, *callFrame, "readBuffer");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetInternalformatParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getInternalformatParameter"_s, { target, internalformat, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getInternalformatParameter(WTFMove(target), WTFMove(internalformat), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetInternalformatParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetInternalformatParameterBody>(*lexicalGlobalObject, *callFrame, "getInternalformatParameter");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorageMultisampleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto samples = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "renderbufferStorageMultisample"_s, { target, samples, internalformat, width, height });
    impl.renderbufferStorageMultisample(WTFMove(target), WTFMove(samples), WTFMove(internalformat), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorageMultisample(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorageMultisampleBody>(*lexicalGlobalObject, *callFrame, "renderbufferStorageMultisample");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexStorage2DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto levels = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texStorage2D"_s, { target, levels, internalformat, width, height });
    impl.texStorage2D(WTFMove(target), WTFMove(levels), WTFMove(internalformat), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexStorage2D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionTexStorage2DBody>(*lexicalGlobalObject, *callFrame, "texStorage2D");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexStorage3DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto levels = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texStorage3D"_s, { target, levels, internalformat, width, height, depth });
    impl.texStorage3D(WTFMove(target), WTFMove(levels), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(depth));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexStorage3D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionTexStorage3DBody>(*lexicalGlobalObject, *callFrame, "texStorage3D");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage3D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pboOffset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texImage3D"_s, { target, level, internalformat, width, height, depth, border, format, type, pboOffset });
    impl.texImage3D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(border), WTFMove(format), WTFMove(type), WTFMove(pboOffset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage3D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto source = convert<IDLUnion<IDLInterface<ImageBitmap>, IDLInterface<ImageData>, IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texImage3D"_s, { target, level, internalformat, width, height, depth, border, format, type, source });
    impl.texImage3D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(border), WTFMove(format), WTFMove(type), WTFMove(source));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage3D3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pixels = convert<IDLNullable<IDLArrayBufferView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(9), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 9, "pixels", "WebGL2RenderingContext", "texImage3D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texImage3D"_s, { target, level, internalformat, width, height, depth, border, format, type, pixels });
    impl.texImage3D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(border), WTFMove(format), WTFMove(type), WTFMove(pixels));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage3D4Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(9), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 9, "srcData", "WebGL2RenderingContext", "texImage3D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(10));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texImage3D"_s, { target, level, internalformat, width, height, depth, border, format, type, srcData, srcOffset });
    impl.texImage3D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(border), WTFMove(format), WTFMove(type), srcData.releaseNonNull(), WTFMove(srcOffset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage3DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(11, callFrame->argumentCount());
    if (argsCount == 10) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(9);
        if (distinguishingArg.isUndefinedOrNull())
            return jsWebGL2RenderingContextPrototypeFunctionTexImage3D3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageBitmap>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageData>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLImageElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLCanvasElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLVideoElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage3D3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionTexImage3D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsWebGL2RenderingContextPrototypeFunctionTexImage3D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 11) {
        return jsWebGL2RenderingContextPrototypeFunctionTexImage3D4Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 10 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexImage3D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionTexImage3DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "texImage3D");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pboOffset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(10));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texSubImage3D"_s, { target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pboOffset });
    impl.texSubImage3D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(zoffset), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(format), WTFMove(type), WTFMove(pboOffset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto source = convert<IDLUnion<IDLInterface<ImageBitmap>, IDLInterface<ImageData>, IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(10));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texSubImage3D"_s, { target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, source });
    impl.texSubImage3D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(zoffset), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(format), WTFMove(type), WTFMove(source));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcData = convert<IDLNullable<IDLArrayBufferView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(10), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 10, "srcData", "WebGL2RenderingContext", "texSubImage3D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(11));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texSubImage3D"_s, { target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, srcData, srcOffset });
    impl.texSubImage3D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(zoffset), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(format), WTFMove(type), WTFMove(srcData), WTFMove(srcOffset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage3DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(12, callFrame->argumentCount());
    if (argsCount == 11) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(10);
        if (distinguishingArg.isUndefinedOrNull())
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageBitmap>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageData>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLImageElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLCanvasElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLVideoElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 12) {
        return jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 11 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexSubImage3D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionTexSubImage3DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "texSubImage3D");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage3DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 9))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "copyTexSubImage3D"_s, { target, level, xoffset, yoffset, zoffset, x, y, width, height });
    impl.copyTexSubImage3D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(zoffset), WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage3D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage3DBody>(*lexicalGlobalObject, *callFrame, "copyTexSubImage3D");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto imageSize = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexImage3D"_s, { target, level, internalformat, width, height, depth, border, imageSize, offset });
    impl.compressedTexImage3D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(border), WTFMove(imageSize), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(7), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 7, "srcData", "WebGL2RenderingContext", "compressedTexImage3D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLengthOverride = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexImage3D"_s, { target, level, internalformat, width, height, depth, border, srcData, srcOffset, srcLengthOverride });
    impl.compressedTexImage3D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(border), srcData.releaseNonNull(), WTFMove(srcOffset), WTFMove(srcLengthOverride));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(10, callFrame->argumentCount());
    if (argsCount == 10) {
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 8) {
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 9) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(7);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 8 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage3DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "compressedTexImage3D");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto imageSize = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(10));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexSubImage3D"_s, { target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, offset });
    impl.compressedTexSubImage3D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(zoffset), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(format), WTFMove(imageSize), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(9), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 9, "srcData", "WebGL2RenderingContext", "compressedTexSubImage3D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(10));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLengthOverride = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(11));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexSubImage3D"_s, { target, level, xoffset, yoffset, zoffset, width, height, depth, format, srcData, srcOffset, srcLengthOverride });
    impl.compressedTexSubImage3D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(zoffset), WTFMove(width), WTFMove(height), WTFMove(depth), WTFMove(format), srcData.releaseNonNull(), WTFMove(srcOffset), WTFMove(srcLengthOverride));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(12, callFrame->argumentCount());
    if (argsCount == 10) {
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 11) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(9);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 12) {
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 10 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage3DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "compressedTexSubImage3D");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetFragDataLocationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getFragDataLocation", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getFragDataLocation"_s, { program, name });
    return JSValue::encode(toJS<IDLLong>(impl.getFragDataLocation(*program, WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetFragDataLocation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetFragDataLocationBody>(*lexicalGlobalObject, *callFrame, "getFragDataLocation");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1uiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform1ui", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v0 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform1ui"_s, { location, v0 });
    impl.uniform1ui(WTFMove(location), WTFMove(v0));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1ui(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform1uiBody>(*lexicalGlobalObject, *callFrame, "uniform1ui");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2uiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform2ui", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v0 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v1 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform2ui"_s, { location, v0, v1 });
    impl.uniform2ui(WTFMove(location), WTFMove(v0), WTFMove(v1));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2ui(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform2uiBody>(*lexicalGlobalObject, *callFrame, "uniform2ui");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3uiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform3ui", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v0 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v1 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v2 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform3ui"_s, { location, v0, v1, v2 });
    impl.uniform3ui(WTFMove(location), WTFMove(v0), WTFMove(v1), WTFMove(v2));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3ui(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform3uiBody>(*lexicalGlobalObject, *callFrame, "uniform3ui");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4uiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform4ui", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v0 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v1 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v2 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v3 = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform4ui"_s, { location, v0, v1, v2, v3 });
    impl.uniform4ui(WTFMove(location), WTFMove(v0), WTFMove(v1), WTFMove(v2), WTFMove(v3));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4ui(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform4uiBody>(*lexicalGlobalObject, *callFrame, "uniform4ui");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1uivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform1uiv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLUint32Array, IDLSequence<IDLUnsignedLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform1uiv"_s, { location, data, srcOffset, srcLength });
    impl.uniform1uiv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1uiv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform1uivBody>(*lexicalGlobalObject, *callFrame, "uniform1uiv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2uivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform2uiv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLUint32Array, IDLSequence<IDLUnsignedLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform2uiv"_s, { location, data, srcOffset, srcLength });
    impl.uniform2uiv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2uiv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform2uivBody>(*lexicalGlobalObject, *callFrame, "uniform2uiv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3uivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform3uiv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLUint32Array, IDLSequence<IDLUnsignedLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform3uiv"_s, { location, data, srcOffset, srcLength });
    impl.uniform3uiv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3uiv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform3uivBody>(*lexicalGlobalObject, *callFrame, "uniform3uiv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4uivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform4uiv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLUint32Array, IDLSequence<IDLUnsignedLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform4uiv"_s, { location, data, srcOffset, srcLength });
    impl.uniform4uiv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4uiv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform4uivBody>(*lexicalGlobalObject, *callFrame, "uniform4uiv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x3fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix2x3fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix2x3fv"_s, { location, transpose, data, srcOffset, srcLength });
    impl.uniformMatrix2x3fv(WTFMove(location), WTFMove(transpose), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x3fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x3fvBody>(*lexicalGlobalObject, *callFrame, "uniformMatrix2x3fv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x2fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix3x2fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix3x2fv"_s, { location, transpose, data, srcOffset, srcLength });
    impl.uniformMatrix3x2fv(WTFMove(location), WTFMove(transpose), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x2fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x2fvBody>(*lexicalGlobalObject, *callFrame, "uniformMatrix3x2fv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x4fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix2x4fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix2x4fv"_s, { location, transpose, data, srcOffset, srcLength });
    impl.uniformMatrix2x4fv(WTFMove(location), WTFMove(transpose), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x4fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2x4fvBody>(*lexicalGlobalObject, *callFrame, "uniformMatrix2x4fv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x2fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix4x2fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix4x2fv"_s, { location, transpose, data, srcOffset, srcLength });
    impl.uniformMatrix4x2fv(WTFMove(location), WTFMove(transpose), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x2fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x2fvBody>(*lexicalGlobalObject, *callFrame, "uniformMatrix4x2fv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x4fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix3x4fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix3x4fv"_s, { location, transpose, data, srcOffset, srcLength });
    impl.uniformMatrix3x4fv(WTFMove(location), WTFMove(transpose), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x4fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3x4fvBody>(*lexicalGlobalObject, *callFrame, "uniformMatrix3x4fv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x3fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix4x3fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix4x3fv"_s, { location, transpose, data, srcOffset, srcLength });
    impl.uniformMatrix4x3fv(WTFMove(location), WTFMove(transpose), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x3fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4x3fvBody>(*lexicalGlobalObject, *callFrame, "uniformMatrix4x3fv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4iBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttribI4i"_s, { index, x, y, z, w });
    impl.vertexAttribI4i(WTFMove(index), WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4i(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4iBody>(*lexicalGlobalObject, *callFrame, "vertexAttribI4i");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4ivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto values = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttribI4iv"_s, { index, values });
    impl.vertexAttribI4iv(WTFMove(index), WTFMove(values));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4iv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4ivBody>(*lexicalGlobalObject, *callFrame, "vertexAttribI4iv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4uiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttribI4ui"_s, { index, x, y, z, w });
    impl.vertexAttribI4ui(WTFMove(index), WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4ui(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4uiBody>(*lexicalGlobalObject, *callFrame, "vertexAttribI4ui");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4uivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto values = convert<IDLUnion<IDLUint32Array, IDLSequence<IDLUnsignedLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttribI4uiv"_s, { index, values });
    impl.vertexAttribI4uiv(WTFMove(index), WTFMove(values));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4uiv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttribI4uivBody>(*lexicalGlobalObject, *callFrame, "vertexAttribI4uiv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttribIPointerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto size = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto stride = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttribIPointer"_s, { index, size, type, stride, offset });
    impl.vertexAttribIPointer(WTFMove(index), WTFMove(size), WTFMove(type), WTFMove(stride), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribIPointer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttribIPointerBody>(*lexicalGlobalObject, *callFrame, "vertexAttribIPointer");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttribDivisorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto divisor = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttribDivisor"_s, { index, divisor });
    impl.vertexAttribDivisor(WTFMove(index), WTFMove(divisor));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribDivisor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttribDivisorBody>(*lexicalGlobalObject, *callFrame, "vertexAttribDivisor");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDrawArraysInstancedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto first = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto instanceCount = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawArraysInstanced"_s, { mode, first, count, instanceCount });
    impl.drawArraysInstanced(WTFMove(mode), WTFMove(first), WTFMove(count), WTFMove(instanceCount));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawArraysInstanced(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDrawArraysInstancedBody>(*lexicalGlobalObject, *callFrame, "drawArraysInstanced");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDrawElementsInstancedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto instanceCount = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawElementsInstanced"_s, { mode, count, type, offset, instanceCount });
    impl.drawElementsInstanced(WTFMove(mode), WTFMove(count), WTFMove(type), WTFMove(offset), WTFMove(instanceCount));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawElementsInstanced(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDrawElementsInstancedBody>(*lexicalGlobalObject, *callFrame, "drawElementsInstanced");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDrawRangeElementsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto start = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto end = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawRangeElements"_s, { mode, start, end, count, type, offset });
    impl.drawRangeElements(WTFMove(mode), WTFMove(start), WTFMove(end), WTFMove(count), WTFMove(type), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawRangeElements(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDrawRangeElementsBody>(*lexicalGlobalObject, *callFrame, "drawRangeElements");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDrawBuffersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffers = convert<IDLSequence<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawBuffers"_s, { buffers });
    impl.drawBuffers(WTFMove(buffers));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawBuffers(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDrawBuffersBody>(*lexicalGlobalObject, *callFrame, "drawBuffers");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionClearBufferivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto drawbuffer = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto values = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clearBufferiv"_s, { buffer, drawbuffer, values, srcOffset });
    impl.clearBufferiv(WTFMove(buffer), WTFMove(drawbuffer), WTFMove(values), WTFMove(srcOffset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearBufferiv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionClearBufferivBody>(*lexicalGlobalObject, *callFrame, "clearBufferiv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionClearBufferuivBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto drawbuffer = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto values = convert<IDLUnion<IDLUint32Array, IDLSequence<IDLUnsignedLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clearBufferuiv"_s, { buffer, drawbuffer, values, srcOffset });
    impl.clearBufferuiv(WTFMove(buffer), WTFMove(drawbuffer), WTFMove(values), WTFMove(srcOffset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearBufferuiv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionClearBufferuivBody>(*lexicalGlobalObject, *callFrame, "clearBufferuiv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionClearBufferfvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto drawbuffer = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto values = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clearBufferfv"_s, { buffer, drawbuffer, values, srcOffset });
    impl.clearBufferfv(WTFMove(buffer), WTFMove(drawbuffer), WTFMove(values), WTFMove(srcOffset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearBufferfv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionClearBufferfvBody>(*lexicalGlobalObject, *callFrame, "clearBufferfv");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionClearBufferfiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto drawbuffer = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto depth = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto stencil = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clearBufferfi"_s, { buffer, drawbuffer, depth, stencil });
    impl.clearBufferfi(WTFMove(buffer), WTFMove(drawbuffer), WTFMove(depth), WTFMove(stencil));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearBufferfi(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionClearBufferfiBody>(*lexicalGlobalObject, *callFrame, "clearBufferfi");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateQueryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createQuery"_s);
    return JSValue::encode(toJS<IDLNullable<IDLInterface<WebGLQuery>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createQuery()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateQuery(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateQueryBody>(*lexicalGlobalObject, *callFrame, "createQuery");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteQueryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto query = convert<IDLNullable<IDLInterface<WebGLQuery>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "query", "WebGL2RenderingContext", "deleteQuery", "WebGLQuery"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteQuery"_s, { query });
    impl.deleteQuery(WTFMove(query));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteQuery(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteQueryBody>(*lexicalGlobalObject, *callFrame, "deleteQuery");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsQueryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto query = convert<IDLNullable<IDLInterface<WebGLQuery>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "query", "WebGL2RenderingContext", "isQuery", "WebGLQuery"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isQuery"_s, { query });
    return JSValue::encode(toJS<IDLBoolean>(impl.isQuery(WTFMove(query))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsQuery(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsQueryBody>(*lexicalGlobalObject, *callFrame, "isQuery");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBeginQueryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto query = convert<IDLInterface<WebGLQuery>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "query", "WebGL2RenderingContext", "beginQuery", "WebGLQuery"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "beginQuery"_s, { target, query });
    impl.beginQuery(WTFMove(target), *query);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBeginQuery(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBeginQueryBody>(*lexicalGlobalObject, *callFrame, "beginQuery");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionEndQueryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "endQuery"_s, { target });
    impl.endQuery(WTFMove(target));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionEndQuery(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionEndQueryBody>(*lexicalGlobalObject, *callFrame, "endQuery");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetQueryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getQuery"_s, { target, pname });
    return JSValue::encode(toJS<IDLNullable<IDLInterface<WebGLQuery>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getQuery(WTFMove(target), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetQuery(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetQueryBody>(*lexicalGlobalObject, *callFrame, "getQuery");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetQueryParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto query = convert<IDLInterface<WebGLQuery>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "query", "WebGL2RenderingContext", "getQueryParameter", "WebGLQuery"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getQueryParameter"_s, { query, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getQueryParameter(*query, WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetQueryParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetQueryParameterBody>(*lexicalGlobalObject, *callFrame, "getQueryParameter");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateSamplerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createSampler"_s);
    return JSValue::encode(toJS<IDLNullable<IDLInterface<WebGLSampler>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createSampler()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateSampler(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateSamplerBody>(*lexicalGlobalObject, *callFrame, "createSampler");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteSamplerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sampler = convert<IDLNullable<IDLInterface<WebGLSampler>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sampler", "WebGL2RenderingContext", "deleteSampler", "WebGLSampler"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteSampler"_s, { sampler });
    impl.deleteSampler(WTFMove(sampler));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteSampler(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteSamplerBody>(*lexicalGlobalObject, *callFrame, "deleteSampler");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsSamplerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sampler = convert<IDLNullable<IDLInterface<WebGLSampler>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sampler", "WebGL2RenderingContext", "isSampler", "WebGLSampler"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isSampler"_s, { sampler });
    return JSValue::encode(toJS<IDLBoolean>(impl.isSampler(WTFMove(sampler))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsSampler(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsSamplerBody>(*lexicalGlobalObject, *callFrame, "isSampler");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindSamplerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto unit = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sampler = convert<IDLNullable<IDLInterface<WebGLSampler>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "sampler", "WebGL2RenderingContext", "bindSampler", "WebGLSampler"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindSampler"_s, { unit, sampler });
    impl.bindSampler(WTFMove(unit), WTFMove(sampler));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindSampler(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindSamplerBody>(*lexicalGlobalObject, *callFrame, "bindSampler");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionSamplerParameteriBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sampler = convert<IDLInterface<WebGLSampler>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sampler", "WebGL2RenderingContext", "samplerParameteri", "WebGLSampler"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto param = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "samplerParameteri"_s, { sampler, pname, param });
    impl.samplerParameteri(*sampler, WTFMove(pname), WTFMove(param));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionSamplerParameteri(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionSamplerParameteriBody>(*lexicalGlobalObject, *callFrame, "samplerParameteri");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionSamplerParameterfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sampler = convert<IDLInterface<WebGLSampler>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sampler", "WebGL2RenderingContext", "samplerParameterf", "WebGLSampler"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto param = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "samplerParameterf"_s, { sampler, pname, param });
    impl.samplerParameterf(*sampler, WTFMove(pname), WTFMove(param));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionSamplerParameterf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionSamplerParameterfBody>(*lexicalGlobalObject, *callFrame, "samplerParameterf");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetSamplerParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sampler = convert<IDLInterface<WebGLSampler>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sampler", "WebGL2RenderingContext", "getSamplerParameter", "WebGLSampler"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getSamplerParameter"_s, { sampler, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getSamplerParameter(*sampler, WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetSamplerParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetSamplerParameterBody>(*lexicalGlobalObject, *callFrame, "getSamplerParameter");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionFenceSyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto condition = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto flags = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "fenceSync"_s, { condition, flags });
    return JSValue::encode(toJS<IDLNullable<IDLInterface<WebGLSync>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.fenceSync(WTFMove(condition), WTFMove(flags))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFenceSync(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionFenceSyncBody>(*lexicalGlobalObject, *callFrame, "fenceSync");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsSyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sync = convert<IDLNullable<IDLInterface<WebGLSync>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sync", "WebGL2RenderingContext", "isSync", "WebGLSync"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isSync"_s, { sync });
    return JSValue::encode(toJS<IDLBoolean>(impl.isSync(WTFMove(sync))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsSync(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsSyncBody>(*lexicalGlobalObject, *callFrame, "isSync");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteSyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sync = convert<IDLNullable<IDLInterface<WebGLSync>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sync", "WebGL2RenderingContext", "deleteSync", "WebGLSync"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteSync"_s, { sync });
    impl.deleteSync(WTFMove(sync));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteSync(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteSyncBody>(*lexicalGlobalObject, *callFrame, "deleteSync");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionClientWaitSyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sync = convert<IDLInterface<WebGLSync>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sync", "WebGL2RenderingContext", "clientWaitSync", "WebGLSync"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto flags = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto timeout = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clientWaitSync"_s, { sync, flags, timeout });
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.clientWaitSync(*sync, WTFMove(flags), WTFMove(timeout))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClientWaitSync(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionClientWaitSyncBody>(*lexicalGlobalObject, *callFrame, "clientWaitSync");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionWaitSyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sync = convert<IDLInterface<WebGLSync>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sync", "WebGL2RenderingContext", "waitSync", "WebGLSync"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto flags = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto timeout = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "waitSync"_s, { sync, flags, timeout });
    impl.waitSync(*sync, WTFMove(flags), WTFMove(timeout));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionWaitSync(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionWaitSyncBody>(*lexicalGlobalObject, *callFrame, "waitSync");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetSyncParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sync = convert<IDLInterface<WebGLSync>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sync", "WebGL2RenderingContext", "getSyncParameter", "WebGLSync"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getSyncParameter"_s, { sync, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getSyncParameter(*sync, WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetSyncParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetSyncParameterBody>(*lexicalGlobalObject, *callFrame, "getSyncParameter");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateTransformFeedbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createTransformFeedback"_s);
    return JSValue::encode(toJS<IDLNullable<IDLInterface<WebGLTransformFeedback>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createTransformFeedback()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateTransformFeedback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateTransformFeedbackBody>(*lexicalGlobalObject, *callFrame, "createTransformFeedback");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteTransformFeedbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto id = convert<IDLNullable<IDLInterface<WebGLTransformFeedback>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "id", "WebGL2RenderingContext", "deleteTransformFeedback", "WebGLTransformFeedback"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteTransformFeedback"_s, { id });
    impl.deleteTransformFeedback(WTFMove(id));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteTransformFeedback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteTransformFeedbackBody>(*lexicalGlobalObject, *callFrame, "deleteTransformFeedback");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsTransformFeedbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto id = convert<IDLNullable<IDLInterface<WebGLTransformFeedback>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "id", "WebGL2RenderingContext", "isTransformFeedback", "WebGLTransformFeedback"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isTransformFeedback"_s, { id });
    return JSValue::encode(toJS<IDLBoolean>(impl.isTransformFeedback(WTFMove(id))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsTransformFeedback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsTransformFeedbackBody>(*lexicalGlobalObject, *callFrame, "isTransformFeedback");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindTransformFeedbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto id = convert<IDLNullable<IDLInterface<WebGLTransformFeedback>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "id", "WebGL2RenderingContext", "bindTransformFeedback", "WebGLTransformFeedback"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindTransformFeedback"_s, { target, id });
    impl.bindTransformFeedback(WTFMove(target), WTFMove(id));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindTransformFeedback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindTransformFeedbackBody>(*lexicalGlobalObject, *callFrame, "bindTransformFeedback");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBeginTransformFeedbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto primitiveMode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "beginTransformFeedback"_s, { primitiveMode });
    impl.beginTransformFeedback(WTFMove(primitiveMode));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBeginTransformFeedback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBeginTransformFeedbackBody>(*lexicalGlobalObject, *callFrame, "beginTransformFeedback");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionEndTransformFeedbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "endTransformFeedback"_s);
    impl.endTransformFeedback();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionEndTransformFeedback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionEndTransformFeedbackBody>(*lexicalGlobalObject, *callFrame, "endTransformFeedback");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTransformFeedbackVaryingsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "transformFeedbackVaryings", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto varyings = convert<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto bufferMode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "transformFeedbackVaryings"_s, { program, varyings, bufferMode });
    impl.transformFeedbackVaryings(*program, WTFMove(varyings), WTFMove(bufferMode));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTransformFeedbackVaryings(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionTransformFeedbackVaryingsBody>(*lexicalGlobalObject, *callFrame, "transformFeedbackVaryings");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetTransformFeedbackVaryingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getTransformFeedbackVarying", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getTransformFeedbackVarying"_s, { program, index });
    return JSValue::encode(toJS<IDLNullable<IDLInterface<WebGLActiveInfo>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTransformFeedbackVarying(*program, WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetTransformFeedbackVarying(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetTransformFeedbackVaryingBody>(*lexicalGlobalObject, *callFrame, "getTransformFeedbackVarying");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionPauseTransformFeedbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "pauseTransformFeedback"_s);
    impl.pauseTransformFeedback();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionPauseTransformFeedback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionPauseTransformFeedbackBody>(*lexicalGlobalObject, *callFrame, "pauseTransformFeedback");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionResumeTransformFeedbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "resumeTransformFeedback"_s);
    impl.resumeTransformFeedback();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionResumeTransformFeedback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionResumeTransformFeedbackBody>(*lexicalGlobalObject, *callFrame, "resumeTransformFeedback");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindBufferBaseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto buffer = convert<IDLNullable<IDLInterface<WebGLBuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "buffer", "WebGL2RenderingContext", "bindBufferBase", "WebGLBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindBufferBase"_s, { target, index, buffer });
    impl.bindBufferBase(WTFMove(target), WTFMove(index), WTFMove(buffer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindBufferBase(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindBufferBaseBody>(*lexicalGlobalObject, *callFrame, "bindBufferBase");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindBufferRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto buffer = convert<IDLNullable<IDLInterface<WebGLBuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "buffer", "WebGL2RenderingContext", "bindBufferRange", "WebGLBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto size = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindBufferRange"_s, { target, index, buffer, offset, size });
    impl.bindBufferRange(WTFMove(target), WTFMove(index), WTFMove(buffer), WTFMove(offset), WTFMove(size));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindBufferRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindBufferRangeBody>(*lexicalGlobalObject, *callFrame, "bindBufferRange");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetIndexedParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getIndexedParameter"_s, { target, index });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getIndexedParameter(WTFMove(target), WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetIndexedParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetIndexedParameterBody>(*lexicalGlobalObject, *callFrame, "getIndexedParameter");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetUniformIndicesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getUniformIndices", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto uniformNames = convert<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getUniformIndices"_s, { program, uniformNames });
    return JSValue::encode(toJS<IDLNullable<IDLSequence<IDLUnsignedLong>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getUniformIndices(*program, WTFMove(uniformNames))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetUniformIndices(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetUniformIndicesBody>(*lexicalGlobalObject, *callFrame, "getUniformIndices");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getActiveUniforms", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto uniformIndices = convert<IDLSequence<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getActiveUniforms"_s, { program, uniformIndices, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getActiveUniforms(*program, WTFMove(uniformIndices), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveUniforms(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformsBody>(*lexicalGlobalObject, *callFrame, "getActiveUniforms");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetUniformBlockIndexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getUniformBlockIndex", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto uniformBlockName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getUniformBlockIndex"_s, { program, uniformBlockName });
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.getUniformBlockIndex(*program, WTFMove(uniformBlockName))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetUniformBlockIndex(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetUniformBlockIndexBody>(*lexicalGlobalObject, *callFrame, "getUniformBlockIndex");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getActiveUniformBlockParameter", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto uniformBlockIndex = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getActiveUniformBlockParameter"_s, { program, uniformBlockIndex, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getActiveUniformBlockParameter(*program, WTFMove(uniformBlockIndex), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockParameterBody>(*lexicalGlobalObject, *callFrame, "getActiveUniformBlockParameter");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getActiveUniformBlockName", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto uniformBlockIndex = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getActiveUniformBlockName"_s, { program, uniformBlockIndex });
    return JSValue::encode(toJS<IDLNullable<IDLWebGLAny>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getActiveUniformBlockName(*program, WTFMove(uniformBlockIndex))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBlockNameBody>(*lexicalGlobalObject, *callFrame, "getActiveUniformBlockName");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformBlockBindingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "uniformBlockBinding", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto uniformBlockIndex = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto uniformBlockBinding = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformBlockBinding"_s, { program, uniformBlockIndex, uniformBlockBinding });
    impl.uniformBlockBinding(*program, WTFMove(uniformBlockIndex), WTFMove(uniformBlockBinding));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformBlockBinding(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformBlockBindingBody>(*lexicalGlobalObject, *callFrame, "uniformBlockBinding");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateVertexArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createVertexArray"_s);
    return JSValue::encode(toJS<IDLNullable<IDLInterface<WebGLVertexArrayObject>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createVertexArray()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateVertexArray(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateVertexArrayBody>(*lexicalGlobalObject, *callFrame, "createVertexArray");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteVertexArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto vertexArray = convert<IDLNullable<IDLInterface<WebGLVertexArrayObject>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "vertexArray", "WebGL2RenderingContext", "deleteVertexArray", "WebGLVertexArrayObject"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteVertexArray"_s, { vertexArray });
    impl.deleteVertexArray(WTFMove(vertexArray));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteVertexArray(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteVertexArrayBody>(*lexicalGlobalObject, *callFrame, "deleteVertexArray");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsVertexArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto vertexArray = convert<IDLNullable<IDLInterface<WebGLVertexArrayObject>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "vertexArray", "WebGL2RenderingContext", "isVertexArray", "WebGLVertexArrayObject"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isVertexArray"_s, { vertexArray });
    return JSValue::encode(toJS<IDLBoolean>(impl.isVertexArray(WTFMove(vertexArray))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsVertexArray(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsVertexArrayBody>(*lexicalGlobalObject, *callFrame, "isVertexArray");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindVertexArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto vertexArray = convert<IDLNullable<IDLInterface<WebGLVertexArrayObject>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "vertexArray", "WebGL2RenderingContext", "bindVertexArray", "WebGLVertexArrayObject"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindVertexArray"_s, { vertexArray });
    impl.bindVertexArray(WTFMove(vertexArray));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindVertexArray(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindVertexArrayBody>(*lexicalGlobalObject, *callFrame, "bindVertexArray");
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage2D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pboOffset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texImage2D"_s, { target, level, internalformat, width, height, border, format, type, pboOffset });
    impl.texImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(border), WTFMove(format), WTFMove(type), WTFMove(pboOffset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage2D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto source = convert<IDLUnion<IDLInterface<ImageBitmap>, IDLInterface<ImageData>, IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texImage2D"_s, { target, level, internalformat, width, height, border, format, type, source });
    propagateException(*lexicalGlobalObject, throwScope, impl.texImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(border), WTFMove(format), WTFMove(type), WTFMove(source)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage2D3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(8), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 8, "srcData", "WebGL2RenderingContext", "texImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texImage2D"_s, { target, level, internalformat, width, height, border, format, type, srcData, srcOffset });
    impl.texImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(border), WTFMove(format), WTFMove(type), srcData.releaseNonNull(), WTFMove(srcOffset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pboOffset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texSubImage2D"_s, { target, level, xoffset, yoffset, width, height, format, type, pboOffset });
    impl.texSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(type), WTFMove(pboOffset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto source = convert<IDLUnion<IDLInterface<ImageBitmap>, IDLInterface<ImageData>, IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texSubImage2D"_s, { target, level, xoffset, yoffset, width, height, format, type, source });
    propagateException(*lexicalGlobalObject, throwScope, impl.texSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(type), WTFMove(source)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(8), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 8, "srcData", "WebGL2RenderingContext", "texSubImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texSubImage2D"_s, { target, level, xoffset, yoffset, width, height, format, type, srcData, srcOffset });
    impl.texSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(type), srcData.releaseNonNull(), WTFMove(srcOffset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto imageSize = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexImage2D"_s, { target, level, internalformat, width, height, border, imageSize, offset });
    impl.compressedTexImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(border), WTFMove(imageSize), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(6), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 6, "srcData", "WebGL2RenderingContext", "compressedTexImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLengthOverride = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexImage2D"_s, { target, level, internalformat, width, height, border, srcData, srcOffset, srcLengthOverride });
    impl.compressedTexImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(border), srcData.releaseNonNull(), WTFMove(srcOffset), WTFMove(srcLengthOverride));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto imageSize = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexSubImage2D"_s, { target, level, xoffset, yoffset, width, height, format, imageSize, offset });
    impl.compressedTexSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(imageSize), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(7), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 7, "srcData", "WebGL2RenderingContext", "compressedTexSubImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLengthOverride = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexSubImage2D"_s, { target, level, xoffset, yoffset, width, height, format, srcData, srcOffset, srcLengthOverride });
    impl.compressedTexSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(width), WTFMove(height), WTFMove(format), srcData.releaseNonNull(), WTFMove(srcOffset), WTFMove(srcLengthOverride));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1fv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform1fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform1fv"_s, { location, data, srcOffset, srcLength });
    impl.uniform1fv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2fv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform2fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform2fv"_s, { location, data, srcOffset, srcLength });
    impl.uniform2fv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3fv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform3fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform3fv"_s, { location, data, srcOffset, srcLength });
    impl.uniform3fv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4fv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform4fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform4fv"_s, { location, data, srcOffset, srcLength });
    impl.uniform4fv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1iv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform1iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform1iv"_s, { location, data, srcOffset, srcLength });
    impl.uniform1iv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2iv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform2iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform2iv"_s, { location, data, srcOffset, srcLength });
    impl.uniform2iv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3iv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform3iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform3iv"_s, { location, data, srcOffset, srcLength });
    impl.uniform3iv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4iv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform4iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform4iv"_s, { location, data, srcOffset, srcLength });
    impl.uniform4iv(WTFMove(location), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix2fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix2fv"_s, { location, transpose, data, srcOffset, srcLength });
    impl.uniformMatrix2fv(WTFMove(location), WTFMove(transpose), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix3fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix3fv"_s, { location, transpose, data, srcOffset, srcLength });
    impl.uniformMatrix3fv(WTFMove(location), WTFMove(transpose), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fv1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix4fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcLength = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix4fv"_s, { location, transpose, data, srcOffset, srcLength });
    impl.uniformMatrix4fv(WTFMove(location), WTFMove(transpose), WTFMove(data), WTFMove(srcOffset), WTFMove(srcLength));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionReadPixels1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "readPixels"_s, { x, y, width, height, format, type, offset });
    impl.readPixels(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(type), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionReadPixels2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstData = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(6), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 6, "dstData", "WebGL2RenderingContext", "readPixels", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "readPixels"_s, { x, y, width, height, format, type, dstData, dstOffset });
    impl.readPixels(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(type), dstData.releaseNonNull(), WTFMove(dstOffset));
    return JSValue::encode(jsUndefined());
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionActiveTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto texture = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "activeTexture"_s, { texture });
    impl.activeTexture(WTFMove(texture));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionActiveTexture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionActiveTextureBody>(*lexicalGlobalObject, *callFrame, "activeTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionAttachShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "attachShader", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "shader", "WebGL2RenderingContext", "attachShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "attachShader"_s, { program, shader });
    impl.attachShader(WTFMove(program), WTFMove(shader));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionAttachShader(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionAttachShaderBody>(*lexicalGlobalObject, *callFrame, "attachShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindAttribLocationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "bindAttribLocation", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindAttribLocation"_s, { program, index, name });
    impl.bindAttribLocation(WTFMove(program), WTFMove(index), WTFMove(name));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindAttribLocation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindAttribLocationBody>(*lexicalGlobalObject, *callFrame, "bindAttribLocation");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto buffer = convert<IDLNullable<IDLInterface<WebGLBuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "buffer", "WebGL2RenderingContext", "bindBuffer", "WebGLBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindBuffer"_s, { target, buffer });
    impl.bindBuffer(WTFMove(target), WTFMove(buffer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindBufferBody>(*lexicalGlobalObject, *callFrame, "bindBuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto framebuffer = convert<IDLNullable<IDLInterface<WebGLFramebuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "framebuffer", "WebGL2RenderingContext", "bindFramebuffer", "WebGLFramebuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindFramebuffer"_s, { target, framebuffer });
    impl.bindFramebuffer(WTFMove(target), WTFMove(framebuffer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindFramebuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindFramebufferBody>(*lexicalGlobalObject, *callFrame, "bindFramebuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto renderbuffer = convert<IDLNullable<IDLInterface<WebGLRenderbuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "renderbuffer", "WebGL2RenderingContext", "bindRenderbuffer", "WebGLRenderbuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindRenderbuffer"_s, { target, renderbuffer });
    impl.bindRenderbuffer(WTFMove(target), WTFMove(renderbuffer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindRenderbuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindRenderbufferBody>(*lexicalGlobalObject, *callFrame, "bindRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBindTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto texture = convert<IDLNullable<IDLInterface<WebGLTexture>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "texture", "WebGL2RenderingContext", "bindTexture", "WebGLTexture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bindTexture"_s, { target, texture });
    impl.bindTexture(WTFMove(target), WTFMove(texture));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBindTexture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBindTextureBody>(*lexicalGlobalObject, *callFrame, "bindTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBlendColorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto red = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto green = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto blue = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "blendColor"_s, { red, green, blue, alpha });
    impl.blendColor(WTFMove(red), WTFMove(green), WTFMove(blue), WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendColor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBlendColorBody>(*lexicalGlobalObject, *callFrame, "blendColor");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBlendEquationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "blendEquation"_s, { mode });
    impl.blendEquation(WTFMove(mode));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendEquation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBlendEquationBody>(*lexicalGlobalObject, *callFrame, "blendEquation");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBlendEquationSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto modeRGB = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto modeAlpha = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "blendEquationSeparate"_s, { modeRGB, modeAlpha });
    impl.blendEquationSeparate(WTFMove(modeRGB), WTFMove(modeAlpha));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendEquationSeparate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBlendEquationSeparateBody>(*lexicalGlobalObject, *callFrame, "blendEquationSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBlendFuncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sfactor = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dfactor = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "blendFunc"_s, { sfactor, dfactor });
    impl.blendFunc(WTFMove(sfactor), WTFMove(dfactor));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendFunc(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBlendFuncBody>(*lexicalGlobalObject, *callFrame, "blendFunc");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBlendFuncSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto srcRGB = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstRGB = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcAlpha = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dstAlpha = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "blendFuncSeparate"_s, { srcRGB, dstRGB, srcAlpha, dstAlpha });
    impl.blendFuncSeparate(WTFMove(srcRGB), WTFMove(dstRGB), WTFMove(srcAlpha), WTFMove(dstAlpha));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBlendFuncSeparate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBlendFuncSeparateBody>(*lexicalGlobalObject, *callFrame, "blendFuncSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBufferData2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLNullable<IDLUnion<IDLArrayBuffer, IDLArrayBufferView>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto usage = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bufferData"_s, { target, data, usage });
    impl.bufferData(WTFMove(target), WTFMove(data), WTFMove(usage));
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBufferData3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto size = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto usage = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bufferData"_s, { target, size, usage });
    impl.bufferData(WTFMove(target), WTFMove(size), WTFMove(usage));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBufferDataOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 3) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(1);
#if ENABLE(WEBGL)
        if (distinguishingArg.isUndefinedOrNull())
            return jsWebGL2RenderingContextPrototypeFunctionBufferData2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
#if ENABLE(WEBGL)
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBuffer>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionBufferData2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
#if ENABLE(WEBGL)
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionBufferData2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
#if ENABLE(WEBGL)
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionBufferData3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionBufferData3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionBufferData1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsWebGL2RenderingContextPrototypeFunctionBufferData1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBufferData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBufferDataOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "bufferData");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBufferSubData2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLNullable<IDLUnion<IDLArrayBuffer, IDLArrayBufferView>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bufferSubData"_s, { target, offset, data });
    impl.bufferSubData(WTFMove(target), WTFMove(offset), WTFMove(data));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionBufferSubDataOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 3) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionBufferSubData2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionBufferSubData1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsWebGL2RenderingContextPrototypeFunctionBufferSubData1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionBufferSubData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionBufferSubDataOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "bufferSubData");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCheckFramebufferStatusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "checkFramebufferStatus"_s, { target });
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.checkFramebufferStatus(WTFMove(target))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCheckFramebufferStatus(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCheckFramebufferStatusBody>(*lexicalGlobalObject, *callFrame, "checkFramebufferStatus");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionClearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clear"_s, { mask });
    impl.clear(WTFMove(mask));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClear(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionClearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionClearColorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto red = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto green = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto blue = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clearColor"_s, { red, green, blue, alpha });
    impl.clearColor(WTFMove(red), WTFMove(green), WTFMove(blue), WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearColor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionClearColorBody>(*lexicalGlobalObject, *callFrame, "clearColor");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionClearDepthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto depth = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clearDepth"_s, { depth });
    impl.clearDepth(WTFMove(depth));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearDepth(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionClearDepthBody>(*lexicalGlobalObject, *callFrame, "clearDepth");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionClearStencilBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto s = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clearStencil"_s, { s });
    impl.clearStencil(WTFMove(s));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionClearStencil(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionClearStencilBody>(*lexicalGlobalObject, *callFrame, "clearStencil");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionColorMaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto red = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto green = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto blue = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "colorMask"_s, { red, green, blue, alpha });
    impl.colorMask(WTFMove(red), WTFMove(green), WTFMove(blue), WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionColorMask(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionColorMaskBody>(*lexicalGlobalObject, *callFrame, "colorMask");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompileShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGL2RenderingContext", "compileShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compileShader"_s, { shader });
    impl.compileShader(WTFMove(shader));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompileShader(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCompileShaderBody>(*lexicalGlobalObject, *callFrame, "compileShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage2D4Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pixels = convert<IDLNullable<IDLArrayBufferView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(8), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 8, "pixels", "WebGL2RenderingContext", "texImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texImage2D"_s, { target, level, internalformat, width, height, border, format, type, pixels });
    impl.texImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(border), WTFMove(format), WTFMove(type), WTFMove(pixels));
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage2D5Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto source = convert<IDLNullable<IDLUnion<IDLInterface<ImageBitmap>, IDLInterface<ImageData>, IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<HTMLVideoElement>>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texImage2D"_s, { target, level, internalformat, format, type, source });
    propagateException(*lexicalGlobalObject, throwScope, impl.texImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(format), WTFMove(type), WTFMove(source)));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexImage2DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(10, callFrame->argumentCount());
    if (argsCount == 10) {
        return jsWebGL2RenderingContextPrototypeFunctionTexImage2D3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 6) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionTexImage2D5Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 9) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(8);
#if ENABLE(WEBGL)
        if (distinguishingArg.isUndefinedOrNull())
            return jsWebGL2RenderingContextPrototypeFunctionTexImage2D4Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageBitmap>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageData>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLImageElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLCanvasElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLVideoElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#if ENABLE(WEBGL)
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexImage2D4Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionTexImage2D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsWebGL2RenderingContextPrototypeFunctionTexImage2D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 6 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexImage2D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionTexImage2DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "texImage2D");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D4Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pixels = convert<IDLNullable<IDLArrayBufferView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(8), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 8, "pixels", "WebGL2RenderingContext", "texSubImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texSubImage2D"_s, { target, level, xoffset, yoffset, width, height, format, type, pixels });
    impl.texSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(type), WTFMove(pixels));
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D5Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto source = convert<IDLNullable<IDLUnion<IDLInterface<ImageBitmap>, IDLInterface<ImageData>, IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<HTMLVideoElement>>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texSubImage2D"_s, { target, level, xoffset, yoffset, format, type, source });
    propagateException(*lexicalGlobalObject, throwScope, impl.texSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(format), WTFMove(type), WTFMove(source)));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexSubImage2DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(10, callFrame->argumentCount());
    if (argsCount == 10) {
        return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 7) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D5Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 9) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(8);
#if ENABLE(WEBGL)
        if (distinguishingArg.isUndefinedOrNull())
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D4Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageBitmap>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageData>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLImageElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLCanvasElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLVideoElement>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#if ENABLE(WEBGL)
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D4Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 7 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexSubImage2D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionTexSubImage2DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "texSubImage2D");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(6), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 6, "data", "WebGL2RenderingContext", "compressedTexImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexImage2D"_s, { target, level, internalformat, width, height, border, data });
    impl.compressedTexImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(width), WTFMove(height), WTFMove(border), data.releaseNonNull());
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(9, callFrame->argumentCount());
    if (argsCount == 7) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 8) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(6);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 9) {
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 7 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCompressedTexImage2DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "compressedTexImage2D");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(7), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 7, "data", "WebGL2RenderingContext", "compressedTexSubImage2D", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "compressedTexSubImage2D"_s, { target, level, xoffset, yoffset, width, height, format, data });
    impl.compressedTexSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(width), WTFMove(height), WTFMove(format), data.releaseNonNull());
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2DOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(10, callFrame->argumentCount());
    if (argsCount == 10) {
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 8) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 9) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(7);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 8 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCompressedTexSubImage2DOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "compressedTexSubImage2D");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCopyTexImage2DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 8))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto border = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "copyTexImage2D"_s, { target, level, internalformat, x, y, width, height, border });
    impl.copyTexImage2D(WTFMove(target), WTFMove(level), WTFMove(internalformat), WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height), WTFMove(border));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCopyTexImage2D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCopyTexImage2DBody>(*lexicalGlobalObject, *callFrame, "copyTexImage2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage2DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 8))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto xoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto yoffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "copyTexSubImage2D"_s, { target, level, xoffset, yoffset, x, y, width, height });
    impl.copyTexSubImage2D(WTFMove(target), WTFMove(level), WTFMove(xoffset), WTFMove(yoffset), WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage2D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCopyTexSubImage2DBody>(*lexicalGlobalObject, *callFrame, "copyTexSubImage2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createBuffer"_s);
    return JSValue::encode(toJS<IDLInterface<WebGLBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createBuffer()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateBufferBody>(*lexicalGlobalObject, *callFrame, "createBuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createFramebuffer"_s);
    return JSValue::encode(toJS<IDLInterface<WebGLFramebuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createFramebuffer()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateFramebuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateFramebufferBody>(*lexicalGlobalObject, *callFrame, "createFramebuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createProgram"_s);
    return JSValue::encode(toJS<IDLInterface<WebGLProgram>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createProgram()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateProgram(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateProgramBody>(*lexicalGlobalObject, *callFrame, "createProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createRenderbuffer"_s);
    return JSValue::encode(toJS<IDLInterface<WebGLRenderbuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createRenderbuffer()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateRenderbuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateRenderbufferBody>(*lexicalGlobalObject, *callFrame, "createRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createShader"_s, { type });
    return JSValue::encode(toJS<IDLInterface<WebGLShader>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createShader(WTFMove(type))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateShader(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateShaderBody>(*lexicalGlobalObject, *callFrame, "createShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCreateTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createTexture"_s);
    return JSValue::encode(toJS<IDLInterface<WebGLTexture>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createTexture()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCreateTexture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCreateTextureBody>(*lexicalGlobalObject, *callFrame, "createTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionCullFaceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "cullFace"_s, { mode });
    impl.cullFace(WTFMove(mode));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionCullFace(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionCullFaceBody>(*lexicalGlobalObject, *callFrame, "cullFace");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLNullable<IDLInterface<WebGLBuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "WebGL2RenderingContext", "deleteBuffer", "WebGLBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteBuffer"_s, { buffer });
    impl.deleteBuffer(WTFMove(buffer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteBufferBody>(*lexicalGlobalObject, *callFrame, "deleteBuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto framebuffer = convert<IDLNullable<IDLInterface<WebGLFramebuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "framebuffer", "WebGL2RenderingContext", "deleteFramebuffer", "WebGLFramebuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteFramebuffer"_s, { framebuffer });
    impl.deleteFramebuffer(WTFMove(framebuffer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteFramebuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteFramebufferBody>(*lexicalGlobalObject, *callFrame, "deleteFramebuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "deleteProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteProgram"_s, { program });
    impl.deleteProgram(WTFMove(program));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteProgram(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteProgramBody>(*lexicalGlobalObject, *callFrame, "deleteProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto renderbuffer = convert<IDLNullable<IDLInterface<WebGLRenderbuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "renderbuffer", "WebGL2RenderingContext", "deleteRenderbuffer", "WebGLRenderbuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteRenderbuffer"_s, { renderbuffer });
    impl.deleteRenderbuffer(WTFMove(renderbuffer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteRenderbuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteRenderbufferBody>(*lexicalGlobalObject, *callFrame, "deleteRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGL2RenderingContext", "deleteShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteShader"_s, { shader });
    impl.deleteShader(WTFMove(shader));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteShader(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteShaderBody>(*lexicalGlobalObject, *callFrame, "deleteShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDeleteTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto texture = convert<IDLNullable<IDLInterface<WebGLTexture>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "texture", "WebGL2RenderingContext", "deleteTexture", "WebGLTexture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "deleteTexture"_s, { texture });
    impl.deleteTexture(WTFMove(texture));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDeleteTexture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDeleteTextureBody>(*lexicalGlobalObject, *callFrame, "deleteTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDepthFuncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto func = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "depthFunc"_s, { func });
    impl.depthFunc(WTFMove(func));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDepthFunc(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDepthFuncBody>(*lexicalGlobalObject, *callFrame, "depthFunc");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDepthMaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto flag = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "depthMask"_s, { flag });
    impl.depthMask(WTFMove(flag));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDepthMask(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDepthMaskBody>(*lexicalGlobalObject, *callFrame, "depthMask");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDepthRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto zNear = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zFar = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "depthRange"_s, { zNear, zFar });
    impl.depthRange(WTFMove(zNear), WTFMove(zFar));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDepthRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDepthRangeBody>(*lexicalGlobalObject, *callFrame, "depthRange");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDetachShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "detachShader", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "shader", "WebGL2RenderingContext", "detachShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "detachShader"_s, { program, shader });
    impl.detachShader(WTFMove(program), WTFMove(shader));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDetachShader(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDetachShaderBody>(*lexicalGlobalObject, *callFrame, "detachShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDisableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cap = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "disable"_s, { cap });
    impl.disable(WTFMove(cap));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDisable(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDisableBody>(*lexicalGlobalObject, *callFrame, "disable");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDisableVertexAttribArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "disableVertexAttribArray"_s, { index });
    impl.disableVertexAttribArray(WTFMove(index));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDisableVertexAttribArray(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDisableVertexAttribArrayBody>(*lexicalGlobalObject, *callFrame, "disableVertexAttribArray");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDrawArraysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto first = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawArrays"_s, { mode, first, count });
    impl.drawArrays(WTFMove(mode), WTFMove(first), WTFMove(count));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawArrays(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDrawArraysBody>(*lexicalGlobalObject, *callFrame, "drawArrays");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionDrawElementsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawElements"_s, { mode, count, type, offset });
    impl.drawElements(WTFMove(mode), WTFMove(count), WTFMove(type), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionDrawElements(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionDrawElementsBody>(*lexicalGlobalObject, *callFrame, "drawElements");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionEnableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cap = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "enable"_s, { cap });
    impl.enable(WTFMove(cap));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionEnable(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionEnableBody>(*lexicalGlobalObject, *callFrame, "enable");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionEnableVertexAttribArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "enableVertexAttribArray"_s, { index });
    impl.enableVertexAttribArray(WTFMove(index));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionEnableVertexAttribArray(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionEnableVertexAttribArrayBody>(*lexicalGlobalObject, *callFrame, "enableVertexAttribArray");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionFinishBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "finish"_s);
    impl.finish();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFinish(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionFinishBody>(*lexicalGlobalObject, *callFrame, "finish");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionFlushBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "flush"_s);
    impl.flush();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFlush(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionFlushBody>(*lexicalGlobalObject, *callFrame, "flush");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionFramebufferRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto attachment = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto renderbuffertarget = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto renderbuffer = convert<IDLNullable<IDLInterface<WebGLRenderbuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(3), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 3, "renderbuffer", "WebGL2RenderingContext", "framebufferRenderbuffer", "WebGLRenderbuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "framebufferRenderbuffer"_s, { target, attachment, renderbuffertarget, renderbuffer });
    impl.framebufferRenderbuffer(WTFMove(target), WTFMove(attachment), WTFMove(renderbuffertarget), WTFMove(renderbuffer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFramebufferRenderbuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionFramebufferRenderbufferBody>(*lexicalGlobalObject, *callFrame, "framebufferRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionFramebufferTexture2DBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto attachment = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto textarget = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto texture = convert<IDLNullable<IDLInterface<WebGLTexture>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(3), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 3, "texture", "WebGL2RenderingContext", "framebufferTexture2D", "WebGLTexture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto level = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "framebufferTexture2D"_s, { target, attachment, textarget, texture, level });
    impl.framebufferTexture2D(WTFMove(target), WTFMove(attachment), WTFMove(textarget), WTFMove(texture), WTFMove(level));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFramebufferTexture2D(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionFramebufferTexture2DBody>(*lexicalGlobalObject, *callFrame, "framebufferTexture2D");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionFrontFaceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "frontFace"_s, { mode });
    impl.frontFace(WTFMove(mode));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionFrontFace(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionFrontFaceBody>(*lexicalGlobalObject, *callFrame, "frontFace");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGenerateMipmapBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "generateMipmap"_s, { target });
    impl.generateMipmap(WTFMove(target));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGenerateMipmap(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGenerateMipmapBody>(*lexicalGlobalObject, *callFrame, "generateMipmap");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetActiveAttribBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getActiveAttrib", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getActiveAttrib"_s, { program, index });
    return JSValue::encode(toJS<IDLInterface<WebGLActiveInfo>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getActiveAttrib(WTFMove(program), WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveAttrib(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetActiveAttribBody>(*lexicalGlobalObject, *callFrame, "getActiveAttrib");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getActiveUniform", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getActiveUniform"_s, { program, index });
    return JSValue::encode(toJS<IDLInterface<WebGLActiveInfo>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getActiveUniform(WTFMove(program), WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetActiveUniform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetActiveUniformBody>(*lexicalGlobalObject, *callFrame, "getActiveUniform");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetAttachedShadersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getAttachedShaders", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getAttachedShaders"_s, { program });
    return JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<WebGLShader>>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getAttachedShaders(WTFMove(program))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetAttachedShaders(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetAttachedShadersBody>(*lexicalGlobalObject, *callFrame, "getAttachedShaders");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetAttribLocationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getAttribLocation", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getAttribLocation"_s, { program, name });
    return JSValue::encode(toJS<IDLLong>(impl.getAttribLocation(WTFMove(program), WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetAttribLocation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetAttribLocationBody>(*lexicalGlobalObject, *callFrame, "getAttribLocation");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetBufferParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getBufferParameter"_s, { target, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getBufferParameter(WTFMove(target), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetBufferParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetBufferParameterBody>(*lexicalGlobalObject, *callFrame, "getBufferParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetContextAttributesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getContextAttributes"_s);
    return JSValue::encode(toJS<IDLNullable<IDLDictionary<WebGLContextAttributes>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getContextAttributes()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetContextAttributes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetContextAttributesBody>(*lexicalGlobalObject, *callFrame, "getContextAttributes");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetErrorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getError"_s);
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.getError()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetError(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetErrorBody>(*lexicalGlobalObject, *callFrame, "getError");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetSupportedExtensionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getSupportedExtensions"_s);
    return JSValue::encode(toJS<IDLNullable<IDLSequence<IDLDOMString>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getSupportedExtensions()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetSupportedExtensions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetSupportedExtensionsBody>(*lexicalGlobalObject, *callFrame, "getSupportedExtensions");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetExtensionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getExtension"_s, { name });
    return JSValue::encode(toJS<IDLNullable<IDLWebGLExtension>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getExtension(WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetExtension(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetExtensionBody>(*lexicalGlobalObject, *callFrame, "getExtension");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetFramebufferAttachmentParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto attachment = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getFramebufferAttachmentParameter"_s, { target, attachment, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getFramebufferAttachmentParameter(WTFMove(target), WTFMove(attachment), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetFramebufferAttachmentParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetFramebufferAttachmentParameterBody>(*lexicalGlobalObject, *callFrame, "getFramebufferAttachmentParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getParameter"_s, { pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getParameter(WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetParameterBody>(*lexicalGlobalObject, *callFrame, "getParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetProgramParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getProgramParameter", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getProgramParameter"_s, { program, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getProgramParameter(WTFMove(program), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetProgramParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetProgramParameterBody>(*lexicalGlobalObject, *callFrame, "getProgramParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetProgramInfoLogBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getProgramInfoLog", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getProgramInfoLog"_s, { program });
    return JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, impl.getProgramInfoLog(WTFMove(program))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetProgramInfoLog(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetProgramInfoLogBody>(*lexicalGlobalObject, *callFrame, "getProgramInfoLog");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetRenderbufferParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getRenderbufferParameter"_s, { target, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getRenderbufferParameter(WTFMove(target), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetRenderbufferParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetRenderbufferParameterBody>(*lexicalGlobalObject, *callFrame, "getRenderbufferParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetShaderParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGL2RenderingContext", "getShaderParameter", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getShaderParameter"_s, { shader, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getShaderParameter(WTFMove(shader), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetShaderParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetShaderParameterBody>(*lexicalGlobalObject, *callFrame, "getShaderParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetShaderInfoLogBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGL2RenderingContext", "getShaderInfoLog", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getShaderInfoLog"_s, { shader });
    return JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, impl.getShaderInfoLog(WTFMove(shader))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetShaderInfoLog(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetShaderInfoLogBody>(*lexicalGlobalObject, *callFrame, "getShaderInfoLog");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetShaderPrecisionFormatBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shadertype = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto precisiontype = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getShaderPrecisionFormat"_s, { shadertype, precisiontype });
    return JSValue::encode(toJS<IDLInterface<WebGLShaderPrecisionFormat>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getShaderPrecisionFormat(WTFMove(shadertype), WTFMove(precisiontype))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetShaderPrecisionFormat(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetShaderPrecisionFormatBody>(*lexicalGlobalObject, *callFrame, "getShaderPrecisionFormat");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetShaderSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGL2RenderingContext", "getShaderSource", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getShaderSource"_s, { shader });
    return JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, impl.getShaderSource(WTFMove(shader))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetShaderSource(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetShaderSourceBody>(*lexicalGlobalObject, *callFrame, "getShaderSource");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetTexParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getTexParameter"_s, { target, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTexParameter(WTFMove(target), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetTexParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetTexParameterBody>(*lexicalGlobalObject, *callFrame, "getTexParameter");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetUniformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getUniform", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "location", "WebGL2RenderingContext", "getUniform", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getUniform"_s, { program, location });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getUniform(WTFMove(program), WTFMove(location))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetUniform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetUniformBody>(*lexicalGlobalObject, *callFrame, "getUniform");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetUniformLocationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "getUniformLocation", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getUniformLocation"_s, { program, name });
    return JSValue::encode(toJS<IDLInterface<WebGLUniformLocation>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getUniformLocation(WTFMove(program), WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetUniformLocation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetUniformLocationBody>(*lexicalGlobalObject, *callFrame, "getUniformLocation");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetVertexAttribBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getVertexAttrib"_s, { index, pname });
    return JSValue::encode(toJS<IDLWebGLAny>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getVertexAttrib(WTFMove(index), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetVertexAttrib(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetVertexAttribBody>(*lexicalGlobalObject, *callFrame, "getVertexAttrib");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionGetVertexAttribOffsetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getVertexAttribOffset"_s, { index, pname });
    return JSValue::encode(toJS<IDLLongLong>(impl.getVertexAttribOffset(WTFMove(index), WTFMove(pname))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionGetVertexAttribOffset(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionGetVertexAttribOffsetBody>(*lexicalGlobalObject, *callFrame, "getVertexAttribOffset");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionHintBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "hint"_s, { target, mode });
    impl.hint(WTFMove(target), WTFMove(mode));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionHint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionHintBody>(*lexicalGlobalObject, *callFrame, "hint");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLNullable<IDLInterface<WebGLBuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "WebGL2RenderingContext", "isBuffer", "WebGLBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isBuffer"_s, { buffer });
    return JSValue::encode(toJS<IDLBoolean>(impl.isBuffer(WTFMove(buffer))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsBufferBody>(*lexicalGlobalObject, *callFrame, "isBuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsContextLostBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isContextLost"_s);
    return JSValue::encode(toJS<IDLBoolean>(impl.isContextLost()));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsContextLost(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsContextLostBody>(*lexicalGlobalObject, *callFrame, "isContextLost");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cap = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isEnabled"_s, { cap });
    return JSValue::encode(toJS<IDLBoolean>(impl.isEnabled(WTFMove(cap))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsEnabledBody>(*lexicalGlobalObject, *callFrame, "isEnabled");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsFramebufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto framebuffer = convert<IDLNullable<IDLInterface<WebGLFramebuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "framebuffer", "WebGL2RenderingContext", "isFramebuffer", "WebGLFramebuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isFramebuffer"_s, { framebuffer });
    return JSValue::encode(toJS<IDLBoolean>(impl.isFramebuffer(WTFMove(framebuffer))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsFramebuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsFramebufferBody>(*lexicalGlobalObject, *callFrame, "isFramebuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "isProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isProgram"_s, { program });
    return JSValue::encode(toJS<IDLBoolean>(impl.isProgram(WTFMove(program))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsProgram(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsProgramBody>(*lexicalGlobalObject, *callFrame, "isProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsRenderbufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto renderbuffer = convert<IDLNullable<IDLInterface<WebGLRenderbuffer>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "renderbuffer", "WebGL2RenderingContext", "isRenderbuffer", "WebGLRenderbuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isRenderbuffer"_s, { renderbuffer });
    return JSValue::encode(toJS<IDLBoolean>(impl.isRenderbuffer(WTFMove(renderbuffer))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsRenderbuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsRenderbufferBody>(*lexicalGlobalObject, *callFrame, "isRenderbuffer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsShaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGL2RenderingContext", "isShader", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isShader"_s, { shader });
    return JSValue::encode(toJS<IDLBoolean>(impl.isShader(WTFMove(shader))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsShader(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsShaderBody>(*lexicalGlobalObject, *callFrame, "isShader");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionIsTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto texture = convert<IDLNullable<IDLInterface<WebGLTexture>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "texture", "WebGL2RenderingContext", "isTexture", "WebGLTexture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isTexture"_s, { texture });
    return JSValue::encode(toJS<IDLBoolean>(impl.isTexture(WTFMove(texture))));
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionIsTexture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionIsTextureBody>(*lexicalGlobalObject, *callFrame, "isTexture");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionLineWidthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto width = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineWidth"_s, { width });
    impl.lineWidth(WTFMove(width));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionLineWidth(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionLineWidthBody>(*lexicalGlobalObject, *callFrame, "lineWidth");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionLinkProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "linkProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "linkProgram"_s, { program });
    impl.linkProgram(WTFMove(program));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionLinkProgram(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionLinkProgramBody>(*lexicalGlobalObject, *callFrame, "linkProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionPixelStoreiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto param = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "pixelStorei"_s, { pname, param });
    impl.pixelStorei(WTFMove(pname), WTFMove(param));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionPixelStorei(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionPixelStoreiBody>(*lexicalGlobalObject, *callFrame, "pixelStorei");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionPolygonOffsetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto factor = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto units = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "polygonOffset"_s, { factor, units });
    impl.polygonOffset(WTFMove(factor), WTFMove(units));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionPolygonOffset(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionPolygonOffsetBody>(*lexicalGlobalObject, *callFrame, "polygonOffset");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionReadPixels3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto format = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pixels = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(6), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 6, "pixels", "WebGL2RenderingContext", "readPixels", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "readPixels"_s, { x, y, width, height, format, type, pixels });
    impl.readPixels(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height), WTFMove(format), WTFMove(type), pixels.releaseNonNull());
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionReadPixelsOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(8, callFrame->argumentCount());
    if (argsCount == 7) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(6);
#if ENABLE(WEBGL)
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsWebGL2RenderingContextPrototypeFunctionReadPixels3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
        if (distinguishingArg.isNumber())
            return jsWebGL2RenderingContextPrototypeFunctionReadPixels1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsWebGL2RenderingContextPrototypeFunctionReadPixels1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 8) {
        return jsWebGL2RenderingContextPrototypeFunctionReadPixels2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 7 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionReadPixels(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionReadPixelsOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "readPixels");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionReleaseShaderCompilerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "releaseShaderCompiler"_s);
    impl.releaseShaderCompiler();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionReleaseShaderCompiler(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionReleaseShaderCompilerBody>(*lexicalGlobalObject, *callFrame, "releaseShaderCompiler");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto internalformat = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "renderbufferStorage"_s, { target, internalformat, width, height });
    impl.renderbufferStorage(WTFMove(target), WTFMove(internalformat), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionRenderbufferStorageBody>(*lexicalGlobalObject, *callFrame, "renderbufferStorage");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionSampleCoverageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto value = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto invert = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "sampleCoverage"_s, { value, invert });
    impl.sampleCoverage(WTFMove(value), WTFMove(invert));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionSampleCoverage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionSampleCoverageBody>(*lexicalGlobalObject, *callFrame, "sampleCoverage");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionScissorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "scissor"_s, { x, y, width, height });
    impl.scissor(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionScissor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionScissorBody>(*lexicalGlobalObject, *callFrame, "scissor");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionShaderSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shader = convert<IDLNullable<IDLInterface<WebGLShader>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGL2RenderingContext", "shaderSource", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto string = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "shaderSource"_s, { shader, string });
    impl.shaderSource(WTFMove(shader), WTFMove(string));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionShaderSource(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionShaderSourceBody>(*lexicalGlobalObject, *callFrame, "shaderSource");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionStencilFuncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto func = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto ref = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "stencilFunc"_s, { func, ref, mask });
    impl.stencilFunc(WTFMove(func), WTFMove(ref), WTFMove(mask));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilFunc(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionStencilFuncBody>(*lexicalGlobalObject, *callFrame, "stencilFunc");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionStencilFuncSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto face = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto func = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto ref = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "stencilFuncSeparate"_s, { face, func, ref, mask });
    impl.stencilFuncSeparate(WTFMove(face), WTFMove(func), WTFMove(ref), WTFMove(mask));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilFuncSeparate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionStencilFuncSeparateBody>(*lexicalGlobalObject, *callFrame, "stencilFuncSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionStencilMaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "stencilMask"_s, { mask });
    impl.stencilMask(WTFMove(mask));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilMask(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionStencilMaskBody>(*lexicalGlobalObject, *callFrame, "stencilMask");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionStencilMaskSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto face = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto mask = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "stencilMaskSeparate"_s, { face, mask });
    impl.stencilMaskSeparate(WTFMove(face), WTFMove(mask));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilMaskSeparate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionStencilMaskSeparateBody>(*lexicalGlobalObject, *callFrame, "stencilMaskSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionStencilOpBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto fail = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zfail = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zpass = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "stencilOp"_s, { fail, zfail, zpass });
    impl.stencilOp(WTFMove(fail), WTFMove(zfail), WTFMove(zpass));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilOp(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionStencilOpBody>(*lexicalGlobalObject, *callFrame, "stencilOp");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionStencilOpSeparateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto face = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fail = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zfail = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto zpass = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "stencilOpSeparate"_s, { face, fail, zfail, zpass });
    impl.stencilOpSeparate(WTFMove(face), WTFMove(fail), WTFMove(zfail), WTFMove(zpass));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionStencilOpSeparate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionStencilOpSeparateBody>(*lexicalGlobalObject, *callFrame, "stencilOpSeparate");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexParameterfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto param = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texParameterf"_s, { target, pname, param });
    impl.texParameterf(WTFMove(target), WTFMove(pname), WTFMove(param));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexParameterf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionTexParameterfBody>(*lexicalGlobalObject, *callFrame, "texParameterf");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionTexParameteriBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pname = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto param = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "texParameteri"_s, { target, pname, param });
    impl.texParameteri(WTFMove(target), WTFMove(pname), WTFMove(param));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionTexParameteri(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionTexParameteriBody>(*lexicalGlobalObject, *callFrame, "texParameteri");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform1f", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform1f"_s, { location, x });
    impl.uniform1f(WTFMove(location), WTFMove(x));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1f(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform1fBody>(*lexicalGlobalObject, *callFrame, "uniform1f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform2f", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform2f"_s, { location, x, y });
    impl.uniform2f(WTFMove(location), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2f(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform2fBody>(*lexicalGlobalObject, *callFrame, "uniform2f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform3f", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform3f"_s, { location, x, y, z });
    impl.uniform3f(WTFMove(location), WTFMove(x), WTFMove(y), WTFMove(z));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3f(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform3fBody>(*lexicalGlobalObject, *callFrame, "uniform3f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform4f", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform4f"_s, { location, x, y, z, w });
    impl.uniform4f(WTFMove(location), WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4f(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform4fBody>(*lexicalGlobalObject, *callFrame, "uniform4f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1iBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform1i", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform1i"_s, { location, x });
    impl.uniform1i(WTFMove(location), WTFMove(x));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1i(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform1iBody>(*lexicalGlobalObject, *callFrame, "uniform1i");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2iBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform2i", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform2i"_s, { location, x, y });
    impl.uniform2i(WTFMove(location), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2i(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform2iBody>(*lexicalGlobalObject, *callFrame, "uniform2i");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3iBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform3i", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform3i"_s, { location, x, y, z });
    impl.uniform3i(WTFMove(location), WTFMove(x), WTFMove(y), WTFMove(z));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3i(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform3iBody>(*lexicalGlobalObject, *callFrame, "uniform3i");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4iBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform4i", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform4i"_s, { location, x, y, z, w });
    impl.uniform4i(WTFMove(location), WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4i(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform4iBody>(*lexicalGlobalObject, *callFrame, "uniform4i");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1fv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform1fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform1fv"_s, { location, v });
    impl.uniform1fv(WTFMove(location), WTFMove(v));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1fvOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniform1fv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 3) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform1fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform1fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform1fvOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniform1fv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2fv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform2fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform2fv"_s, { location, v });
    impl.uniform2fv(WTFMove(location), WTFMove(v));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2fvOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniform2fv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 3) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform2fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform2fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform2fvOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniform2fv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3fv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform3fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform3fv"_s, { location, v });
    impl.uniform3fv(WTFMove(location), WTFMove(v));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3fvOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniform3fv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 3) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform3fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform3fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform3fvOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniform3fv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4fv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform4fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform4fv"_s, { location, v });
    impl.uniform4fv(WTFMove(location), WTFMove(v));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4fvOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniform4fv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 3) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform4fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform4fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform4fvOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniform4fv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1iv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform1iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform1iv"_s, { location, v });
    impl.uniform1iv(WTFMove(location), WTFMove(v));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform1ivOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniform1iv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 3) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform1iv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform1iv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform1iv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform1ivOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniform1iv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2iv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform2iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform2iv"_s, { location, v });
    impl.uniform2iv(WTFMove(location), WTFMove(v));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform2ivOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniform2iv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 3) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform2iv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform2iv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform2iv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform2ivOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniform2iv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3iv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform3iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform3iv"_s, { location, v });
    impl.uniform3iv(WTFMove(location), WTFMove(v));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform3ivOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniform3iv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 3) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform3iv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform3iv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform3iv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform3ivOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniform3iv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4iv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniform4iv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto v = convert<IDLUnion<IDLInt32Array, IDLSequence<IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniform4iv"_s, { location, v });
    impl.uniform4iv(WTFMove(location), WTFMove(v));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniform4ivOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniform4iv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 3) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform4iv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniform4iv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniform4iv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniform4ivOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniform4iv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix2fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto array = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix2fv"_s, { location, transpose, array });
    impl.uniformMatrix2fv(WTFMove(location), WTFMove(transpose), WTFMove(array));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fvOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 3) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformMatrix2fvOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniformMatrix2fv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix3fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto array = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix3fv"_s, { location, transpose, array });
    impl.uniformMatrix3fv(WTFMove(location), WTFMove(transpose), WTFMove(array));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fvOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 3) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformMatrix3fvOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniformMatrix3fv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fv2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto location = convert<IDLNullable<IDLInterface<WebGLUniformLocation>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "location", "WebGL2RenderingContext", "uniformMatrix4fv", "WebGLUniformLocation"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transpose = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto array = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "uniformMatrix4fv"_s, { location, transpose, array });
    impl.uniformMatrix4fv(WTFMove(location), WTFMove(transpose), WTFMove(array));
    return JSValue::encode(jsUndefined());
}

#endif

static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fvOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 3) {
#if ENABLE(WEBGL)
        return jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fv2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
#endif
    }
    if (argsCount == 4) {
        return jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fv1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUniformMatrix4fvOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "uniformMatrix4fv");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionUseProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "useProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "useProgram"_s, { program });
    impl.useProgram(WTFMove(program));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionUseProgram(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionUseProgramBody>(*lexicalGlobalObject, *callFrame, "useProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionValidateProgramBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto program = convert<IDLNullable<IDLInterface<WebGLProgram>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "program", "WebGL2RenderingContext", "validateProgram", "WebGLProgram"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "validateProgram"_s, { program });
    impl.validateProgram(WTFMove(program));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionValidateProgram(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionValidateProgramBody>(*lexicalGlobalObject, *callFrame, "validateProgram");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttrib1f"_s, { index, x });
    impl.vertexAttrib1f(WTFMove(index), WTFMove(x));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1f(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1fBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib1f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttrib2f"_s, { index, x, y });
    impl.vertexAttrib2f(WTFMove(index), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2f(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2fBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib2f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttrib3f"_s, { index, x, y, z });
    impl.vertexAttrib3f(WTFMove(index), WTFMove(x), WTFMove(y), WTFMove(z));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3f(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3fBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib3f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4fBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttrib4f"_s, { index, x, y, z, w });
    impl.vertexAttrib4f(WTFMove(index), WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4f(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4fBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib4f");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto values = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttrib1fv"_s, { index, values });
    impl.vertexAttrib1fv(WTFMove(index), WTFMove(values));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttrib1fvBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib1fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto values = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttrib2fv"_s, { index, values });
    impl.vertexAttrib2fv(WTFMove(index), WTFMove(values));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttrib2fvBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib2fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto values = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttrib3fv"_s, { index, values });
    impl.vertexAttrib3fv(WTFMove(index), WTFMove(values));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttrib3fvBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib3fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4fvBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto values = convert<IDLUnion<IDLFloat32Array, IDLSequence<IDLUnrestrictedFloat>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttrib4fv"_s, { index, values });
    impl.vertexAttrib4fv(WTFMove(index), WTFMove(values));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4fv(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttrib4fvBody>(*lexicalGlobalObject, *callFrame, "vertexAttrib4fv");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionVertexAttribPointerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto indx = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto size = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto normalized = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto stride = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "vertexAttribPointer"_s, { indx, size, type, normalized, stride, offset });
    impl.vertexAttribPointer(WTFMove(indx), WTFMove(size), WTFMove(type), WTFMove(normalized), WTFMove(stride), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionVertexAttribPointer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionVertexAttribPointerBody>(*lexicalGlobalObject, *callFrame, "vertexAttribPointer");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsWebGL2RenderingContextPrototypeFunctionViewportBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGL2RenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "viewport"_s, { x, y, width, height });
    impl.viewport(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGL2RenderingContextPrototypeFunctionViewport(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGL2RenderingContext>::call<jsWebGL2RenderingContextPrototypeFunctionViewportBody>(*lexicalGlobalObject, *callFrame, "viewport");
}

#endif

void JSWebGL2RenderingContext::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSWebGL2RenderingContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSWebGL2RenderingContext::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSWebGL2RenderingContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSWebGL2RenderingContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGL2RenderingContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGL2RenderingContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGL2RenderingContext = jsCast<JSWebGL2RenderingContext*>(handle.slot()->asCell());
    if (jsWebGL2RenderingContext->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGL2RenderingContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGL2RenderingContext = static_cast<JSWebGL2RenderingContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGL2RenderingContext->wrapped(), jsWebGL2RenderingContext);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGL2RenderingContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGL2RenderingContextE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGL2RenderingContext>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGL2RenderingContext@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22WebGL2RenderingContextE[2];
#endif

    // If this fails WebGL2RenderingContext does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGL2RenderingContext>::value, "WebGL2RenderingContext is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGL2RenderingContext has subclasses. If WebGL2RenderingContext has subclasses that get passed
    // to toJS() we currently require WebGL2RenderingContext you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGL2RenderingContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGL2RenderingContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGL2RenderingContext* JSWebGL2RenderingContext::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGL2RenderingContext*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL2)
