/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureS3TC.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLCompressedTextureS3TCPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTextureS3TCPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureS3TCPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureS3TCPrototype>(vm.heap)) JSWebGLCompressedTextureS3TCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureS3TCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureS3TCPrototype, JSWebGLCompressedTextureS3TCPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTextureS3TCPrototypeTableValues[] =
{
    { "COMPRESSED_RGB_S3TC_DXT1_EXT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x83F0) } },
    { "COMPRESSED_RGBA_S3TC_DXT1_EXT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x83F1) } },
    { "COMPRESSED_RGBA_S3TC_DXT3_EXT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x83F2) } },
    { "COMPRESSED_RGBA_S3TC_DXT5_EXT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x83F3) } },
};

const ClassInfo JSWebGLCompressedTextureS3TCPrototype::s_info = { "WebGLCompressedTextureS3TCPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureS3TCPrototype) };

void JSWebGLCompressedTextureS3TCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureS3TC::info(), JSWebGLCompressedTextureS3TCPrototypeTableValues, *this);
}

const ClassInfo JSWebGLCompressedTextureS3TC::s_info = { "WebGLCompressedTextureS3TC", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureS3TC) };

JSWebGLCompressedTextureS3TC::JSWebGLCompressedTextureS3TC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureS3TC>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureS3TC>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLCompressedTextureS3TC::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTextureS3TC>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLCompressedTextureS3TC::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLCompressedTextureS3TCPrototype::create(vm, &globalObject, JSWebGLCompressedTextureS3TCPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLCompressedTextureS3TC::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureS3TC>(vm, globalObject);
}

void JSWebGLCompressedTextureS3TC::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureS3TC* thisObject = static_cast<JSWebGLCompressedTextureS3TC*>(cell);
    thisObject->JSWebGLCompressedTextureS3TC::~JSWebGLCompressedTextureS3TC();
}

void JSWebGLCompressedTextureS3TC::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTextureS3TC*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTextureS3TCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLCompressedTextureS3TC = jsCast<JSWebGLCompressedTextureS3TC*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLCompressedTextureS3TC->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLCompressedTextureS3TC";
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLCompressedTextureS3TCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureS3TC = static_cast<JSWebGLCompressedTextureS3TC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLCompressedTextureS3TC->wrapped(), jsWebGLCompressedTextureS3TC);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureS3TC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26WebGLCompressedTextureS3TCE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTextureS3TC>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLCompressedTextureS3TC@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore26WebGLCompressedTextureS3TCE[2];
#endif

    // If this fails WebGLCompressedTextureS3TC does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLCompressedTextureS3TC>::value, "WebGLCompressedTextureS3TC is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLCompressedTextureS3TC has subclasses. If WebGLCompressedTextureS3TC has subclasses that get passed
    // to toJS() we currently require WebGLCompressedTextureS3TC you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLCompressedTextureS3TC>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTextureS3TC& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTextureS3TC* JSWebGLCompressedTextureS3TC::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureS3TC*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
