/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLContextAttributes.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGL)

template<> WebGLContextAttributes convertDictionary<WebGLContextAttributes>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGLContextAttributes result;
    JSValue alphaValue;
    if (isNullOrUndefined)
        alphaValue = jsUndefined();
    else {
        alphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alpha"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!alphaValue.isUndefined()) {
        result.alpha = convert<IDLBoolean>(lexicalGlobalObject, alphaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.alpha = true;
    JSValue antialiasValue;
    if (isNullOrUndefined)
        antialiasValue = jsUndefined();
    else {
        antialiasValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "antialias"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!antialiasValue.isUndefined()) {
        result.antialias = convert<IDLBoolean>(lexicalGlobalObject, antialiasValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.antialias = true;
    JSValue depthValue;
    if (isNullOrUndefined)
        depthValue = jsUndefined();
    else {
        depthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depth"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthValue.isUndefined()) {
        result.depth = convert<IDLBoolean>(lexicalGlobalObject, depthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.depth = true;
    JSValue failIfMajorPerformanceCaveatValue;
    if (isNullOrUndefined)
        failIfMajorPerformanceCaveatValue = jsUndefined();
    else {
        failIfMajorPerformanceCaveatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "failIfMajorPerformanceCaveat"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!failIfMajorPerformanceCaveatValue.isUndefined()) {
        result.failIfMajorPerformanceCaveat = convert<IDLBoolean>(lexicalGlobalObject, failIfMajorPerformanceCaveatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.failIfMajorPerformanceCaveat = false;
    JSValue powerPreferenceValue;
    if (isNullOrUndefined)
        powerPreferenceValue = jsUndefined();
    else {
        powerPreferenceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "powerPreference"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!powerPreferenceValue.isUndefined()) {
        result.powerPreference = convert<IDLEnumeration<WebGLContextAttributes::PowerPreference>>(lexicalGlobalObject, powerPreferenceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.powerPreference = WebGLContextAttributes::PowerPreference::Default;
    JSValue premultipliedAlphaValue;
    if (isNullOrUndefined)
        premultipliedAlphaValue = jsUndefined();
    else {
        premultipliedAlphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "premultipliedAlpha"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!premultipliedAlphaValue.isUndefined()) {
        result.premultipliedAlpha = convert<IDLBoolean>(lexicalGlobalObject, premultipliedAlphaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.premultipliedAlpha = true;
    JSValue preserveDrawingBufferValue;
    if (isNullOrUndefined)
        preserveDrawingBufferValue = jsUndefined();
    else {
        preserveDrawingBufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "preserveDrawingBuffer"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!preserveDrawingBufferValue.isUndefined()) {
        result.preserveDrawingBuffer = convert<IDLBoolean>(lexicalGlobalObject, preserveDrawingBufferValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.preserveDrawingBuffer = false;
    JSValue stencilValue;
    if (isNullOrUndefined)
        stencilValue = jsUndefined();
    else {
        stencilValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencil"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilValue.isUndefined()) {
        result.stencil = convert<IDLBoolean>(lexicalGlobalObject, stencilValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stencil = false;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebGLContextAttributes& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto alphaValue = toJS<IDLBoolean>(dictionary.alpha);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "alpha"), alphaValue);
    auto antialiasValue = toJS<IDLBoolean>(dictionary.antialias);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "antialias"), antialiasValue);
    auto depthValue = toJS<IDLBoolean>(dictionary.depth);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "depth"), depthValue);
    auto failIfMajorPerformanceCaveatValue = toJS<IDLBoolean>(dictionary.failIfMajorPerformanceCaveat);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "failIfMajorPerformanceCaveat"), failIfMajorPerformanceCaveatValue);
    auto powerPreferenceValue = toJS<IDLEnumeration<WebGLContextAttributes::PowerPreference>>(lexicalGlobalObject, dictionary.powerPreference);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "powerPreference"), powerPreferenceValue);
    auto premultipliedAlphaValue = toJS<IDLBoolean>(dictionary.premultipliedAlpha);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "premultipliedAlpha"), premultipliedAlphaValue);
    auto preserveDrawingBufferValue = toJS<IDLBoolean>(dictionary.preserveDrawingBuffer);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "preserveDrawingBuffer"), preserveDrawingBufferValue);
    auto stencilValue = toJS<IDLBoolean>(dictionary.stencil);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "stencil"), stencilValue);
    return result;
}

#endif

String convertEnumerationToString(WebGLContextAttributes::PowerPreference enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("default"),
        MAKE_STATIC_STRING_IMPL("low-power"),
        MAKE_STATIC_STRING_IMPL("high-performance"),
    };
    static_assert(static_cast<size_t>(WebGLContextAttributes::PowerPreference::Default) == 0, "WebGLContextAttributes::PowerPreference::Default is not 0 as expected");
    static_assert(static_cast<size_t>(WebGLContextAttributes::PowerPreference::LowPower) == 1, "WebGLContextAttributes::PowerPreference::LowPower is not 1 as expected");
    static_assert(static_cast<size_t>(WebGLContextAttributes::PowerPreference::HighPerformance) == 2, "WebGLContextAttributes::PowerPreference::HighPerformance is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, WebGLContextAttributes::PowerPreference enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<WebGLContextAttributes::PowerPreference> parseEnumeration<WebGLContextAttributes::PowerPreference>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "default")
        return WebGLContextAttributes::PowerPreference::Default;
    if (stringValue == "low-power")
        return WebGLContextAttributes::PowerPreference::LowPower;
    if (stringValue == "high-performance")
        return WebGLContextAttributes::PowerPreference::HighPerformance;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<WebGLContextAttributes::PowerPreference>()
{
    return "\"default\", \"low-power\", \"high-performance\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGL)
