/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDebugShaders.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebGLShader.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSource(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSWebGLDebugShadersPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLDebugShadersPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDebugShadersPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDebugShadersPrototype>(vm.heap)) JSWebGLDebugShadersPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDebugShadersPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLDebugShadersPrototype, JSWebGLDebugShadersPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLDebugShadersPrototypeTableValues[] =
{
    { "getTranslatedShaderSource", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSource), (intptr_t) (1) } },
};

const ClassInfo JSWebGLDebugShadersPrototype::s_info = { "WebGLDebugShadersPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDebugShadersPrototype) };

void JSWebGLDebugShadersPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDebugShaders::info(), JSWebGLDebugShadersPrototypeTableValues, *this);
}

const ClassInfo JSWebGLDebugShaders::s_info = { "WebGLDebugShaders", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDebugShaders) };

JSWebGLDebugShaders::JSWebGLDebugShaders(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDebugShaders>&& impl)
    : JSDOMWrapper<WebGLDebugShaders>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLDebugShaders::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLDebugShaders>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLDebugShaders::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLDebugShadersPrototype::create(vm, &globalObject, JSWebGLDebugShadersPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLDebugShaders::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLDebugShaders>(vm, globalObject);
}

void JSWebGLDebugShaders::destroy(JSC::JSCell* cell)
{
    JSWebGLDebugShaders* thisObject = static_cast<JSWebGLDebugShaders*>(cell);
    thisObject->JSWebGLDebugShaders::~JSWebGLDebugShaders();
}

template<> inline JSWebGLDebugShaders* IDLOperation<JSWebGLDebugShaders>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGLDebugShaders*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLDebugShaders>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shader = convert<IDLInterface<WebGLShader>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "shader", "WebGLDebugShaders", "getTranslatedShaderSource", "WebGLShader"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.getTranslatedShaderSource(*shader)));
}

EncodedJSValue JSC_HOST_CALL jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSource(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGLDebugShaders>::call<jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSourceBody>(*lexicalGlobalObject, *callFrame, "getTranslatedShaderSource");
}

void JSWebGLDebugShaders::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLDebugShaders*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLDebugShadersOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLDebugShaders = jsCast<JSWebGLDebugShaders*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLDebugShaders->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLDebugShaders";
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLDebugShadersOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDebugShaders = static_cast<JSWebGLDebugShaders*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLDebugShaders->wrapped(), jsWebGLDebugShaders);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDebugShaders@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17WebGLDebugShadersE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLDebugShaders>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLDebugShaders@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17WebGLDebugShadersE[2];
#endif

    // If this fails WebGLDebugShaders does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLDebugShaders>::value, "WebGLDebugShaders is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLDebugShaders has subclasses. If WebGLDebugShaders has subclasses that get passed
    // to toJS() we currently require WebGLDebugShaders you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLDebugShaders>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLDebugShaders& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLDebugShaders* JSWebGLDebugShaders::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDebugShaders*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
