/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLFramebuffer.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsWebGLFramebufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGLFramebufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLFramebufferPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLFramebufferPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLFramebufferPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLFramebufferPrototype>(vm.heap)) JSWebGLFramebufferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLFramebufferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLFramebufferPrototype, JSWebGLFramebufferPrototype::Base);

using JSWebGLFramebufferConstructor = JSDOMConstructorNotConstructable<JSWebGLFramebuffer>;

template<> JSValue JSWebGLFramebufferConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLFramebufferConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLFramebuffer::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WebGLFramebuffer"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGLFramebufferConstructor::s_info = { "WebGLFramebuffer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLFramebufferConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLFramebufferPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLFramebufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLFramebufferConstructor) } },
};

const ClassInfo JSWebGLFramebufferPrototype::s_info = { "WebGLFramebufferPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLFramebufferPrototype) };

void JSWebGLFramebufferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLFramebuffer::info(), JSWebGLFramebufferPrototypeTableValues, *this);
}

const ClassInfo JSWebGLFramebuffer::s_info = { "WebGLFramebuffer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLFramebuffer) };

JSWebGLFramebuffer::JSWebGLFramebuffer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLFramebuffer>&& impl)
    : JSDOMWrapper<WebGLFramebuffer>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLFramebuffer::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLFramebuffer>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLFramebuffer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLFramebufferPrototype::create(vm, &globalObject, JSWebGLFramebufferPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLFramebuffer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLFramebuffer>(vm, globalObject);
}

JSValue JSWebGLFramebuffer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLFramebufferConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLFramebuffer::destroy(JSC::JSCell* cell)
{
    JSWebGLFramebuffer* thisObject = static_cast<JSWebGLFramebuffer*>(cell);
    thisObject->JSWebGLFramebuffer::~JSWebGLFramebuffer();
}

EncodedJSValue jsWebGLFramebufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLFramebufferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLFramebuffer::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGLFramebufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLFramebufferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSWebGLFramebuffer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLFramebuffer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLFramebufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGLFramebufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLFramebuffer = static_cast<JSWebGLFramebuffer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLFramebuffer->wrapped(), jsWebGLFramebuffer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLFramebuffer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WebGLFramebufferE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLFramebuffer>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLFramebuffer@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16WebGLFramebufferE[2];
#endif

    // If this fails WebGLFramebuffer does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLFramebuffer>::value, "WebGLFramebuffer is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLFramebuffer has subclasses. If WebGLFramebuffer has subclasses that get passed
    // to toJS() we currently require WebGLFramebuffer you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLFramebuffer>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLFramebuffer& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLFramebuffer* JSWebGLFramebuffer::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLFramebuffer*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
