/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLLoseContext.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGLLoseContextPrototypeFunctionLoseContext(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLLoseContextPrototypeFunctionRestoreContext(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSWebGLLoseContextPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLLoseContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLLoseContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLLoseContextPrototype>(vm.heap)) JSWebGLLoseContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLLoseContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLLoseContextPrototype, JSWebGLLoseContextPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLLoseContextPrototypeTableValues[] =
{
    { "loseContext", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGLLoseContextPrototypeFunctionLoseContext), (intptr_t) (0) } },
    { "restoreContext", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGLLoseContextPrototypeFunctionRestoreContext), (intptr_t) (0) } },
};

const ClassInfo JSWebGLLoseContextPrototype::s_info = { "WebGLLoseContextPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLLoseContextPrototype) };

void JSWebGLLoseContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLLoseContext::info(), JSWebGLLoseContextPrototypeTableValues, *this);
}

const ClassInfo JSWebGLLoseContext::s_info = { "WebGLLoseContext", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLLoseContext) };

JSWebGLLoseContext::JSWebGLLoseContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLLoseContext>&& impl)
    : JSDOMWrapper<WebGLLoseContext>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLLoseContext::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLLoseContext>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLLoseContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLLoseContextPrototype::create(vm, &globalObject, JSWebGLLoseContextPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLLoseContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLLoseContext>(vm, globalObject);
}

void JSWebGLLoseContext::destroy(JSC::JSCell* cell)
{
    JSWebGLLoseContext* thisObject = static_cast<JSWebGLLoseContext*>(cell);
    thisObject->JSWebGLLoseContext::~JSWebGLLoseContext();
}

template<> inline JSWebGLLoseContext* IDLOperation<JSWebGLLoseContext>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGLLoseContext*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsWebGLLoseContextPrototypeFunctionLoseContextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLLoseContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.loseContext();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGLLoseContextPrototypeFunctionLoseContext(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGLLoseContext>::call<jsWebGLLoseContextPrototypeFunctionLoseContextBody>(*lexicalGlobalObject, *callFrame, "loseContext");
}

static inline JSC::EncodedJSValue jsWebGLLoseContextPrototypeFunctionRestoreContextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLLoseContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.restoreContext();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGLLoseContextPrototypeFunctionRestoreContext(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGLLoseContext>::call<jsWebGLLoseContextPrototypeFunctionRestoreContextBody>(*lexicalGlobalObject, *callFrame, "restoreContext");
}

void JSWebGLLoseContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLLoseContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLLoseContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLLoseContext = jsCast<JSWebGLLoseContext*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLLoseContext->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLLoseContext";
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLLoseContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLLoseContext = static_cast<JSWebGLLoseContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLLoseContext->wrapped(), jsWebGLLoseContext);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLLoseContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WebGLLoseContextE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLLoseContext>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLLoseContext@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16WebGLLoseContextE[2];
#endif

    // If this fails WebGLLoseContext does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLLoseContext>::value, "WebGLLoseContext is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLLoseContext has subclasses. If WebGLLoseContext has subclasses that get passed
    // to toJS() we currently require WebGLLoseContext you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLLoseContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLLoseContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLLoseContext* JSWebGLLoseContext::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLLoseContext*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
