/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLSampler.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsWebGLSamplerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGLSamplerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLSamplerPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLSamplerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLSamplerPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLSamplerPrototype>(vm.heap)) JSWebGLSamplerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLSamplerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLSamplerPrototype, JSWebGLSamplerPrototype::Base);

using JSWebGLSamplerConstructor = JSDOMConstructorNotConstructable<JSWebGLSampler>;

template<> JSValue JSWebGLSamplerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLSamplerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLSampler::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WebGLSampler"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGLSamplerConstructor::s_info = { "WebGLSampler", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLSamplerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLSamplerPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLSamplerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLSamplerConstructor) } },
};

const ClassInfo JSWebGLSamplerPrototype::s_info = { "WebGLSamplerPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLSamplerPrototype) };

void JSWebGLSamplerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLSampler::info(), JSWebGLSamplerPrototypeTableValues, *this);
}

const ClassInfo JSWebGLSampler::s_info = { "WebGLSampler", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLSampler) };

JSWebGLSampler::JSWebGLSampler(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLSampler>&& impl)
    : JSDOMWrapper<WebGLSampler>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLSampler::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLSampler>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLSampler::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLSamplerPrototype::create(vm, &globalObject, JSWebGLSamplerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLSampler::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLSampler>(vm, globalObject);
}

JSValue JSWebGLSampler::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLSamplerConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLSampler::destroy(JSC::JSCell* cell)
{
    JSWebGLSampler* thisObject = static_cast<JSWebGLSampler*>(cell);
    thisObject->JSWebGLSampler::~JSWebGLSampler();
}

EncodedJSValue jsWebGLSamplerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLSamplerPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLSampler::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGLSamplerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLSamplerPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSWebGLSampler::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLSampler*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLSamplerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGLSamplerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLSampler = static_cast<JSWebGLSampler*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLSampler->wrapped(), jsWebGLSampler);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLSampler@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12WebGLSamplerE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLSampler>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLSampler@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12WebGLSamplerE[2];
#endif

    // If this fails WebGLSampler does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLSampler>::value, "WebGLSampler is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLSampler has subclasses. If WebGLSampler has subclasses that get passed
    // to toJS() we currently require WebGLSampler you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLSampler>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLSampler& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLSampler* JSWebGLSampler::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLSampler*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
