/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL2)

#include "JSWebGLVertexArrayObject.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsWebGLVertexArrayObjectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGLVertexArrayObjectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLVertexArrayObjectPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLVertexArrayObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLVertexArrayObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLVertexArrayObjectPrototype>(vm.heap)) JSWebGLVertexArrayObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLVertexArrayObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLVertexArrayObjectPrototype, JSWebGLVertexArrayObjectPrototype::Base);

using JSWebGLVertexArrayObjectConstructor = JSDOMConstructorNotConstructable<JSWebGLVertexArrayObject>;

template<> JSValue JSWebGLVertexArrayObjectConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLVertexArrayObjectConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLVertexArrayObject::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WebGLVertexArrayObject"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGLVertexArrayObjectConstructor::s_info = { "WebGLVertexArrayObject", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLVertexArrayObjectConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLVertexArrayObjectPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLVertexArrayObjectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLVertexArrayObjectConstructor) } },
};

const ClassInfo JSWebGLVertexArrayObjectPrototype::s_info = { "WebGLVertexArrayObjectPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLVertexArrayObjectPrototype) };

void JSWebGLVertexArrayObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLVertexArrayObject::info(), JSWebGLVertexArrayObjectPrototypeTableValues, *this);
}

const ClassInfo JSWebGLVertexArrayObject::s_info = { "WebGLVertexArrayObject", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLVertexArrayObject) };

JSWebGLVertexArrayObject::JSWebGLVertexArrayObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLVertexArrayObject>&& impl)
    : JSDOMWrapper<WebGLVertexArrayObject>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGLVertexArrayObject::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGLVertexArrayObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGLVertexArrayObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGLVertexArrayObjectPrototype::create(vm, &globalObject, JSWebGLVertexArrayObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGLVertexArrayObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLVertexArrayObject>(vm, globalObject);
}

JSValue JSWebGLVertexArrayObject::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLVertexArrayObjectConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLVertexArrayObject::destroy(JSC::JSCell* cell)
{
    JSWebGLVertexArrayObject* thisObject = static_cast<JSWebGLVertexArrayObject*>(cell);
    thisObject->JSWebGLVertexArrayObject::~JSWebGLVertexArrayObject();
}

EncodedJSValue jsWebGLVertexArrayObjectConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLVertexArrayObjectPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLVertexArrayObject::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGLVertexArrayObjectConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLVertexArrayObjectPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSWebGLVertexArrayObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLVertexArrayObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLVertexArrayObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGLVertexArrayObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLVertexArrayObject = static_cast<JSWebGLVertexArrayObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLVertexArrayObject->wrapped(), jsWebGLVertexArrayObject);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLVertexArrayObject@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGLVertexArrayObjectE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLVertexArrayObject>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGLVertexArrayObject@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22WebGLVertexArrayObjectE[2];
#endif

    // If this fails WebGLVertexArrayObject does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGLVertexArrayObject>::value, "WebGLVertexArrayObject is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGLVertexArrayObject has subclasses. If WebGLVertexArrayObject has subclasses that get passed
    // to toJS() we currently require WebGLVertexArrayObject you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGLVertexArrayObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLVertexArrayObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLVertexArrayObject* JSWebGLVertexArrayObject::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLVertexArrayObject*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL2)
