/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPUAdapter.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUAdapterPrototypeFunctionRequestDevice(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsWebGPUAdapterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPUAdapterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGPUAdapterPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGPUAdapterPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGPUAdapterPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGPUAdapterPrototype>(vm.heap)) JSWebGPUAdapterPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGPUAdapterPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGPUAdapterPrototype, JSWebGPUAdapterPrototype::Base);

using JSWebGPUAdapterConstructor = JSDOMConstructorNotConstructable<JSWebGPUAdapter>;

template<> JSValue JSWebGPUAdapterConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGPUAdapterConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGPUAdapter::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPUAdapter"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGPUAdapterConstructor::s_info = { "GPUAdapter", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUAdapterConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGPUAdapterPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPUAdapterConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPUAdapterConstructor) } },
    { "requestDevice", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUAdapterPrototypeFunctionRequestDevice), (intptr_t) (0) } },
};

const ClassInfo JSWebGPUAdapterPrototype::s_info = { "GPUAdapterPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUAdapterPrototype) };

void JSWebGPUAdapterPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGPUAdapter::info(), JSWebGPUAdapterPrototypeTableValues, *this);
}

const ClassInfo JSWebGPUAdapter::s_info = { "GPUAdapter", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUAdapter) };

JSWebGPUAdapter::JSWebGPUAdapter(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGPUAdapter>&& impl)
    : JSDOMWrapper<WebGPUAdapter>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGPUAdapter::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGPUAdapter>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGPUAdapter::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGPUAdapterPrototype::create(vm, &globalObject, JSWebGPUAdapterPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGPUAdapter::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGPUAdapter>(vm, globalObject);
}

JSValue JSWebGPUAdapter::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGPUAdapterConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGPUAdapter::destroy(JSC::JSCell* cell)
{
    JSWebGPUAdapter* thisObject = static_cast<JSWebGPUAdapter*>(cell);
    thisObject->JSWebGPUAdapter::~JSWebGPUAdapter();
}

template<> inline JSWebGPUAdapter* IDLOperation<JSWebGPUAdapter>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGPUAdapter*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebGPUAdapterConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUAdapterPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGPUAdapter::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGPUAdapterConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUAdapterPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsWebGPUAdapterPrototypeFunctionRequestDeviceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebGPUAdapter>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    impl.requestDevice(document, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUAdapterPrototypeFunctionRequestDevice(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSWebGPUAdapter>::call<jsWebGPUAdapterPrototypeFunctionRequestDeviceBody>(*lexicalGlobalObject, *callFrame, "requestDevice");
}

void JSWebGPUAdapter::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGPUAdapter*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGPUAdapterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGPUAdapterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGPUAdapter = static_cast<JSWebGPUAdapter*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGPUAdapter->wrapped(), jsWebGPUAdapter);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGPUAdapter>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebGPUAdapter.
    static_assert(!std::is_polymorphic<WebGPUAdapter>::value, "WebGPUAdapter is polymorphic but the IDL claims it is not");
    return createWrapper<WebGPUAdapter>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPUAdapter& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGPUAdapter* JSWebGPUAdapter::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGPUAdapter*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGPU)
