/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPUBindGroupBinding.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSWebGPUBufferBinding.h"
#include "JSWebGPUSampler.h"
#include "JSWebGPUTextureView.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> WebGPUBindGroupBinding convertDictionary<WebGPUBindGroupBinding>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGPUBindGroupBinding result;
    JSValue bindingValue;
    if (isNullOrUndefined)
        bindingValue = jsUndefined();
    else {
        bindingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "binding"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bindingValue.isUndefined()) {
        result.binding = convert<IDLUnsignedLong>(lexicalGlobalObject, bindingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "binding", "WebGPUBindGroupBinding", "unsigned long");
        return { };
    }
    JSValue resourceValue;
    if (isNullOrUndefined)
        resourceValue = jsUndefined();
    else {
        resourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resource"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!resourceValue.isUndefined()) {
        result.resource = convert<IDLUnion<IDLInterface<WebGPUSampler>, IDLInterface<WebGPUTextureView>, IDLDictionary<WebGPUBufferBinding>>>(lexicalGlobalObject, resourceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "resource", "WebGPUBindGroupBinding", "(WebGPUSampler or WebGPUTextureView or WebGPUBufferBinding)");
        return { };
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEBGPU)
