/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPUBuffer.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUBufferPrototypeFunctionMapReadAsync(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUBufferPrototypeFunctionMapWriteAsync(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUBufferPrototypeFunctionUnmap(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUBufferPrototypeFunctionDestroy(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsWebGPUBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPUBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGPUBufferPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGPUBufferPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGPUBufferPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGPUBufferPrototype>(vm.heap)) JSWebGPUBufferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGPUBufferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGPUBufferPrototype, JSWebGPUBufferPrototype::Base);

using JSWebGPUBufferConstructor = JSDOMConstructorNotConstructable<JSWebGPUBuffer>;

template<> JSValue JSWebGPUBufferConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGPUBufferConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGPUBuffer::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPUBuffer"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGPUBufferConstructor::s_info = { "GPUBuffer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUBufferConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGPUBufferPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPUBufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPUBufferConstructor) } },
    { "mapReadAsync", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUBufferPrototypeFunctionMapReadAsync), (intptr_t) (0) } },
    { "mapWriteAsync", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUBufferPrototypeFunctionMapWriteAsync), (intptr_t) (0) } },
    { "unmap", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUBufferPrototypeFunctionUnmap), (intptr_t) (0) } },
    { "destroy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUBufferPrototypeFunctionDestroy), (intptr_t) (0) } },
};

const ClassInfo JSWebGPUBufferPrototype::s_info = { "GPUBufferPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUBufferPrototype) };

void JSWebGPUBufferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGPUBuffer::info(), JSWebGPUBufferPrototypeTableValues, *this);
}

const ClassInfo JSWebGPUBuffer::s_info = { "GPUBuffer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUBuffer) };

JSWebGPUBuffer::JSWebGPUBuffer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGPUBuffer>&& impl)
    : JSDOMWrapper<WebGPUBuffer>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGPUBuffer::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGPUBuffer>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGPUBuffer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGPUBufferPrototype::create(vm, &globalObject, JSWebGPUBufferPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGPUBuffer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGPUBuffer>(vm, globalObject);
}

JSValue JSWebGPUBuffer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGPUBufferConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGPUBuffer::destroy(JSC::JSCell* cell)
{
    JSWebGPUBuffer* thisObject = static_cast<JSWebGPUBuffer*>(cell);
    thisObject->JSWebGPUBuffer::~JSWebGPUBuffer();
}

template<> inline JSWebGPUBuffer* IDLOperation<JSWebGPUBuffer>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGPUBuffer*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebGPUBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUBufferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGPUBuffer::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGPUBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUBufferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsWebGPUBufferPrototypeFunctionMapReadAsyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebGPUBuffer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.mapReadAsync(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUBufferPrototypeFunctionMapReadAsync(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSWebGPUBuffer>::call<jsWebGPUBufferPrototypeFunctionMapReadAsyncBody>(*lexicalGlobalObject, *callFrame, "mapReadAsync");
}

static inline JSC::EncodedJSValue jsWebGPUBufferPrototypeFunctionMapWriteAsyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebGPUBuffer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.mapWriteAsync(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUBufferPrototypeFunctionMapWriteAsync(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSWebGPUBuffer>::call<jsWebGPUBufferPrototypeFunctionMapWriteAsyncBody>(*lexicalGlobalObject, *callFrame, "mapWriteAsync");
}

static inline JSC::EncodedJSValue jsWebGPUBufferPrototypeFunctionUnmapBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUBuffer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.unmap();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUBufferPrototypeFunctionUnmap(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUBuffer>::call<jsWebGPUBufferPrototypeFunctionUnmapBody>(*lexicalGlobalObject, *callFrame, "unmap");
}

static inline JSC::EncodedJSValue jsWebGPUBufferPrototypeFunctionDestroyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUBuffer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.destroy();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUBufferPrototypeFunctionDestroy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUBuffer>::call<jsWebGPUBufferPrototypeFunctionDestroyBody>(*lexicalGlobalObject, *callFrame, "destroy");
}

void JSWebGPUBuffer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGPUBuffer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGPUBufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGPUBufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGPUBuffer = static_cast<JSWebGPUBuffer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGPUBuffer->wrapped(), jsWebGPUBuffer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGPUBuffer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12WebGPUBufferE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGPUBuffer>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGPUBuffer@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12WebGPUBufferE[2];
#endif

    // If this fails WebGPUBuffer does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGPUBuffer>::value, "WebGPUBuffer is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGPUBuffer has subclasses. If WebGPUBuffer has subclasses that get passed
    // to toJS() we currently require WebGPUBuffer you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGPUBuffer>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPUBuffer& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGPUBuffer* JSWebGPUBuffer::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGPUBuffer*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGPU)
