/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPUDevice.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUBindGroupLayoutDescriptor.h"
#include "JSGPUBufferDescriptor.h"
#include "JSGPUSamplerDescriptor.h"
#include "JSGPUTextureDescriptor.h"
#include "JSWebGPUAdapter.h"
#include "JSWebGPUBindGroup.h"
#include "JSWebGPUBindGroupDescriptor.h"
#include "JSWebGPUBindGroupLayout.h"
#include "JSWebGPUBuffer.h"
#include "JSWebGPUCommandEncoder.h"
#include "JSWebGPUComputePipeline.h"
#include "JSWebGPUComputePipelineDescriptor.h"
#include "JSWebGPUPipelineLayout.h"
#include "JSWebGPUPipelineLayoutDescriptor.h"
#include "JSWebGPUQueue.h"
#include "JSWebGPURenderPipeline.h"
#include "JSWebGPURenderPipelineDescriptor.h"
#include "JSWebGPUSampler.h"
#include "JSWebGPUShaderModule.h"
#include "JSWebGPUShaderModuleDescriptor.h"
#include "JSWebGPUTexture.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(WEBGPU)
#include "JSDOMConvertEnumeration.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSEventListener.h"
#include "JSGPUErrorFilter.h"
#include "WebGPUDeviceErrorScopes.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateBufferMapped(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateTexture(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateSampler(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateBindGroupLayout(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreatePipelineLayout(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateBindGroup(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateShaderModule(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateRenderPipeline(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateComputePipeline(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateCommandEncoder(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionGetQueue(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(WEBGPU)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionPushErrorScope(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionPopErrorScope(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif

// Attributes

JSC::EncodedJSValue jsWebGPUDeviceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPUDeviceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebGPUDeviceAdapter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsWebGPUDeviceOnuncapturederror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPUDeviceOnuncapturederror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif

class JSWebGPUDevicePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGPUDevicePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGPUDevicePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGPUDevicePrototype>(vm.heap)) JSWebGPUDevicePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGPUDevicePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGPUDevicePrototype, JSWebGPUDevicePrototype::Base);

using JSWebGPUDeviceConstructor = JSDOMConstructorNotConstructable<JSWebGPUDevice>;

template<> JSValue JSWebGPUDeviceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWebGPUDeviceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGPUDevice::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPUDevice"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGPUDeviceConstructor::s_info = { "GPUDevice", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUDeviceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGPUDevicePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPUDeviceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPUDeviceConstructor) } },
    { "adapter", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPUDeviceAdapter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(WEBGPU)
    { "onuncapturederror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPUDeviceOnuncapturederror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPUDeviceOnuncapturederror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "createBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateBuffer), (intptr_t) (1) } },
    { "createBufferMapped", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateBufferMapped), (intptr_t) (1) } },
    { "createTexture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateTexture), (intptr_t) (1) } },
    { "createSampler", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateSampler), (intptr_t) (1) } },
    { "createBindGroupLayout", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateBindGroupLayout), (intptr_t) (1) } },
    { "createPipelineLayout", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreatePipelineLayout), (intptr_t) (1) } },
    { "createBindGroup", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateBindGroup), (intptr_t) (1) } },
    { "createShaderModule", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateShaderModule), (intptr_t) (1) } },
    { "createRenderPipeline", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateRenderPipeline), (intptr_t) (1) } },
    { "createComputePipeline", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateComputePipeline), (intptr_t) (1) } },
    { "createCommandEncoder", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionCreateCommandEncoder), (intptr_t) (0) } },
    { "getQueue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionGetQueue), (intptr_t) (0) } },
#if ENABLE(WEBGPU)
    { "pushErrorScope", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionPushErrorScope), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGPU)
    { "popErrorScope", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebGPUDevicePrototypeFunctionPopErrorScope), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSWebGPUDevicePrototype::s_info = { "GPUDevicePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUDevicePrototype) };

void JSWebGPUDevicePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGPUDevice::info(), JSWebGPUDevicePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(WEBGPU)
    if (!RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("pushErrorScope"), strlen("pushErrorScope"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(WEBGPU)
    if (!RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("popErrorScope"), strlen("popErrorScope"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(WEBGPU)
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isDocument() && RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onuncapturederror"), strlen("onuncapturederror"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSWebGPUDevice::s_info = { "GPUDevice", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPUDevice) };

JSWebGPUDevice::JSWebGPUDevice(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGPUDevice>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSWebGPUDevice::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGPUDevice>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGPUDevice::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGPUDevicePrototype::create(vm, &globalObject, JSWebGPUDevicePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSWebGPUDevice::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGPUDevice>(vm, globalObject);
}

JSValue JSWebGPUDevice::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGPUDeviceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSWebGPUDevice* IDLAttribute<JSWebGPUDevice>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWebGPUDevice*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSWebGPUDevice* IDLOperation<JSWebGPUDevice>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebGPUDevice*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebGPUDeviceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUDevicePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGPUDevice::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGPUDeviceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPUDevicePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsWebGPUDeviceAdapterGetter(JSGlobalObject& lexicalGlobalObject, JSWebGPUDevice& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<WebGPUAdapter>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.adapter());
    return result;
}

EncodedJSValue jsWebGPUDeviceAdapter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebGPUDevice>::get<jsWebGPUDeviceAdapterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "adapter");
}

#if ENABLE(WEBGPU)
static inline JSValue jsWebGPUDeviceOnuncapturederrorGetter(JSGlobalObject& lexicalGlobalObject, JSWebGPUDevice& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().uncapturederrorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsWebGPUDeviceOnuncapturederror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebGPUDevice>::get<jsWebGPUDeviceOnuncapturederrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onuncapturederror");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSWebGPUDeviceOnuncapturederrorSetter(JSGlobalObject& lexicalGlobalObject, JSWebGPUDevice& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().uncapturederrorEvent, value);
    return true;
}

bool setJSWebGPUDeviceOnuncapturederror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebGPUDevice>::set<setJSWebGPUDeviceOnuncapturederrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onuncapturederror");
}

#endif

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<GPUBufferDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPUBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createBuffer(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateBufferBody>(*lexicalGlobalObject, *callFrame, "createBuffer");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateBufferMappedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<GPUBufferDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLAny>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createBufferMapped(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateBufferMapped(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateBufferMappedBody>(*lexicalGlobalObject, *callFrame, "createBufferMapped");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<GPUTextureDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPUTexture>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createTexture(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateTexture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateTextureBody>(*lexicalGlobalObject, *callFrame, "createTexture");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateSamplerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<GPUSamplerDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPUSampler>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createSampler(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateSampler(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateSamplerBody>(*lexicalGlobalObject, *callFrame, "createSampler");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateBindGroupLayoutBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<GPUBindGroupLayoutDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPUBindGroupLayout>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createBindGroupLayout(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateBindGroupLayout(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateBindGroupLayoutBody>(*lexicalGlobalObject, *callFrame, "createBindGroupLayout");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreatePipelineLayoutBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<WebGPUPipelineLayoutDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPUPipelineLayout>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createPipelineLayout(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreatePipelineLayout(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreatePipelineLayoutBody>(*lexicalGlobalObject, *callFrame, "createPipelineLayout");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateBindGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<WebGPUBindGroupDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPUBindGroup>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createBindGroup(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateBindGroup(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateBindGroupBody>(*lexicalGlobalObject, *callFrame, "createBindGroup");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateShaderModuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<WebGPUShaderModuleDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPUShaderModule>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createShaderModule(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateShaderModule(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateShaderModuleBody>(*lexicalGlobalObject, *callFrame, "createShaderModule");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateRenderPipelineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<WebGPURenderPipelineDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPURenderPipeline>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createRenderPipeline(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateRenderPipeline(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateRenderPipelineBody>(*lexicalGlobalObject, *callFrame, "createRenderPipeline");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateComputePipelineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<WebGPUComputePipelineDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPUComputePipeline>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createComputePipeline(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateComputePipeline(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateComputePipelineBody>(*lexicalGlobalObject, *callFrame, "createComputePipeline");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionCreateCommandEncoderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<WebGPUCommandEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createCommandEncoder()));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionCreateCommandEncoder(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionCreateCommandEncoderBody>(*lexicalGlobalObject, *callFrame, "createCommandEncoder");
}

static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionGetQueueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<WebGPUQueue>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getQueue()));
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionGetQueue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionGetQueueBody>(*lexicalGlobalObject, *callFrame, "getQueue");
}

#if ENABLE(WEBGPU)
static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionPushErrorScopeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGPUDevice>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto filter = convert<IDLEnumeration<GPUErrorFilter>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "filter", "GPUDevice", "pushErrorScope", expectedEnumerationValues<GPUErrorFilter>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    WebCore::WebGPUDeviceErrorScopes::pushErrorScope(impl, WTFMove(filter));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionPushErrorScope(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionPushErrorScopeBody>(*lexicalGlobalObject, *callFrame, "pushErrorScope");
}

#endif

#if ENABLE(WEBGPU)
static inline JSC::EncodedJSValue jsWebGPUDevicePrototypeFunctionPopErrorScopeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebGPUDevice>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    WebCore::WebGPUDeviceErrorScopes::popErrorScope(impl, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGPUDevicePrototypeFunctionPopErrorScope(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSWebGPUDevice>::call<jsWebGPUDevicePrototypeFunctionPopErrorScopeBody>(*lexicalGlobalObject, *callFrame, "popErrorScope");
}

#endif

void JSWebGPUDevice::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGPUDevice*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGPUDevice@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12WebGPUDeviceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGPUDevice>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGPUDevice@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12WebGPUDeviceE[2];
#endif

    // If this fails WebGPUDevice does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGPUDevice>::value, "WebGPUDevice is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGPUDevice has subclasses. If WebGPUDevice has subclasses that get passed
    // to toJS() we currently require WebGPUDevice you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGPUDevice>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPUDevice& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGPUDevice* JSWebGPUDevice::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGPUDevice*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGPU)
