/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSWebGPURenderPipeline.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsWebGPURenderPipelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebGPURenderPipelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGPURenderPipelinePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGPURenderPipelinePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGPURenderPipelinePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGPURenderPipelinePrototype>(vm.heap)) JSWebGPURenderPipelinePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGPURenderPipelinePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGPURenderPipelinePrototype, JSWebGPURenderPipelinePrototype::Base);

using JSWebGPURenderPipelineConstructor = JSDOMConstructorNotConstructable<JSWebGPURenderPipeline>;

template<> JSValue JSWebGPURenderPipelineConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGPURenderPipelineConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGPURenderPipeline::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPURenderPipeline"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebGPURenderPipelineConstructor::s_info = { "GPURenderPipeline", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPURenderPipelineConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGPURenderPipelinePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGPURenderPipelineConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGPURenderPipelineConstructor) } },
};

const ClassInfo JSWebGPURenderPipelinePrototype::s_info = { "GPURenderPipelinePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPURenderPipelinePrototype) };

void JSWebGPURenderPipelinePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGPURenderPipeline::info(), JSWebGPURenderPipelinePrototypeTableValues, *this);
}

const ClassInfo JSWebGPURenderPipeline::s_info = { "GPURenderPipeline", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGPURenderPipeline) };

JSWebGPURenderPipeline::JSWebGPURenderPipeline(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGPURenderPipeline>&& impl)
    : JSDOMWrapper<WebGPURenderPipeline>(structure, globalObject, WTFMove(impl))
{
}

void JSWebGPURenderPipeline::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebGPURenderPipeline>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebGPURenderPipeline::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebGPURenderPipelinePrototype::create(vm, &globalObject, JSWebGPURenderPipelinePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebGPURenderPipeline::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGPURenderPipeline>(vm, globalObject);
}

JSValue JSWebGPURenderPipeline::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGPURenderPipelineConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGPURenderPipeline::destroy(JSC::JSCell* cell)
{
    JSWebGPURenderPipeline* thisObject = static_cast<JSWebGPURenderPipeline*>(cell);
    thisObject->JSWebGPURenderPipeline::~JSWebGPURenderPipeline();
}

EncodedJSValue jsWebGPURenderPipelineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPURenderPipelinePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGPURenderPipeline::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebGPURenderPipelineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGPURenderPipelinePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSWebGPURenderPipeline::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGPURenderPipeline*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGPURenderPipelineOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGPURenderPipelineOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGPURenderPipeline = static_cast<JSWebGPURenderPipeline*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGPURenderPipeline->wrapped(), jsWebGPURenderPipeline);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGPURenderPipeline@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20WebGPURenderPipelineE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGPURenderPipeline>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebGPURenderPipeline@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore20WebGPURenderPipelineE[2];
#endif

    // If this fails WebGPURenderPipeline does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebGPURenderPipeline>::value, "WebGPURenderPipeline is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebGPURenderPipeline has subclasses. If WebGPURenderPipeline has subclasses that get passed
    // to toJS() we currently require WebGPURenderPipeline you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebGPURenderPipeline>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPURenderPipeline& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGPURenderPipeline* JSWebGPURenderPipeline::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGPURenderPipeline*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGPU)
