/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(WEBGPU)

#include "JSDOMWrapper.h"
#include "WebGPURenderPipeline.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSWebGPURenderPipeline : public JSDOMWrapper<WebGPURenderPipeline> {
public:
    using Base = JSDOMWrapper<WebGPURenderPipeline>;
    static JSWebGPURenderPipeline* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<WebGPURenderPipeline>&& impl)
    {
        JSWebGPURenderPipeline* ptr = new (NotNull, JSC::allocateCell<JSWebGPURenderPipeline>(globalObject->vm().heap)) JSWebGPURenderPipeline(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static WebGPURenderPipeline* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSWebGPURenderPipeline(JSC::Structure*, JSDOMGlobalObject&, Ref<WebGPURenderPipeline>&&);

    void finishCreation(JSC::VM&);
};

class JSWebGPURenderPipelineOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, WebGPURenderPipeline*)
{
    static NeverDestroyed<JSWebGPURenderPipelineOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(WebGPURenderPipeline* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, WebGPURenderPipeline&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGPURenderPipeline* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<WebGPURenderPipeline>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<WebGPURenderPipeline>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<WebGPURenderPipeline> {
    using WrapperClass = JSWebGPURenderPipeline;
    using ToWrappedReturnType = WebGPURenderPipeline*;
};

} // namespace WebCore

#endif // ENABLE(WEBGPU)
