/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitCSSMatrix.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebKitCSSMatrix.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSetMatrixValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionMultiply(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionInverse(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionTranslate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionScale(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngle(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewX(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewY(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionToString(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsWebKitCSSMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixA(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixA(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixB(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixB(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixC(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixC(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixD(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixD(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixE(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixE(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixF(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixF(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM11(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM11(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM12(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM12(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM13(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM13(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM14(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM14(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM21(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM21(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM22(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM22(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM23(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM23(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM24(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM24(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM31(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM31(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM32(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM32(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM33(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM33(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM34(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM34(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM41(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM41(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM42(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM42(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM43(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM43(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM44(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitCSSMatrixM44(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebKitCSSMatrixPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebKitCSSMatrixPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitCSSMatrixPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitCSSMatrixPrototype>(vm.heap)) JSWebKitCSSMatrixPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitCSSMatrixPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitCSSMatrixPrototype, JSWebKitCSSMatrixPrototype::Base);

using JSWebKitCSSMatrixConstructor = JSDOMConstructor<JSWebKitCSSMatrix>;

template<> EncodedJSValue JSC_HOST_CALL JSWebKitCSSMatrixConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSWebKitCSSMatrixConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto cssValue = callFrame->argument(0).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WebKitCSSMatrix::create(WTFMove(cssValue));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<WebKitCSSMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSWebKitCSSMatrixConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebKitCSSMatrixConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebKitCSSMatrix::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WebKitCSSMatrix"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebKitCSSMatrixConstructor::s_info = { "WebKitCSSMatrix", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitCSSMatrixConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebKitCSSMatrixPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixConstructor) } },
    { "a", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixA), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixA) } },
    { "b", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixB), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixB) } },
    { "c", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixC), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixC) } },
    { "d", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixD), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixD) } },
    { "e", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixE), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixE) } },
    { "f", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixF), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixF) } },
    { "m11", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM11), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM11) } },
    { "m12", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM12), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM12) } },
    { "m13", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM13), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM13) } },
    { "m14", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM14), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM14) } },
    { "m21", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM21), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM21) } },
    { "m22", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM22), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM22) } },
    { "m23", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM23), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM23) } },
    { "m24", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM24), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM24) } },
    { "m31", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM31), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM31) } },
    { "m32", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM32), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM32) } },
    { "m33", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM33), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM33) } },
    { "m34", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM34), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM34) } },
    { "m41", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM41), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM41) } },
    { "m42", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM42), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM42) } },
    { "m43", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM43), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM43) } },
    { "m44", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM44), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM44) } },
    { "setMatrixValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionSetMatrixValue), (intptr_t) (0) } },
    { "multiply", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionMultiply), (intptr_t) (0) } },
    { "inverse", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionInverse), (intptr_t) (0) } },
    { "translate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionTranslate), (intptr_t) (0) } },
    { "scale", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionScale), (intptr_t) (0) } },
    { "rotate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionRotate), (intptr_t) (0) } },
    { "rotateAxisAngle", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngle), (intptr_t) (0) } },
    { "skewX", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionSkewX), (intptr_t) (0) } },
    { "skewY", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionSkewY), (intptr_t) (0) } },
    { "toString", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsWebKitCSSMatrixPrototypeFunctionToString), (intptr_t) (0) } },
};

const ClassInfo JSWebKitCSSMatrixPrototype::s_info = { "WebKitCSSMatrixPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitCSSMatrixPrototype) };

void JSWebKitCSSMatrixPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitCSSMatrix::info(), JSWebKitCSSMatrixPrototypeTableValues, *this);
}

const ClassInfo JSWebKitCSSMatrix::s_info = { "WebKitCSSMatrix", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitCSSMatrix) };

JSWebKitCSSMatrix::JSWebKitCSSMatrix(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitCSSMatrix>&& impl)
    : JSDOMWrapper<WebKitCSSMatrix>(structure, globalObject, WTFMove(impl))
{
}

void JSWebKitCSSMatrix::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebKitCSSMatrix>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebKitCSSMatrix::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebKitCSSMatrixPrototype::create(vm, &globalObject, JSWebKitCSSMatrixPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebKitCSSMatrix::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebKitCSSMatrix>(vm, globalObject);
}

JSValue JSWebKitCSSMatrix::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitCSSMatrixConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebKitCSSMatrix::destroy(JSC::JSCell* cell)
{
    JSWebKitCSSMatrix* thisObject = static_cast<JSWebKitCSSMatrix*>(cell);
    thisObject->JSWebKitCSSMatrix::~JSWebKitCSSMatrix();
}

template<> inline JSWebKitCSSMatrix* IDLAttribute<JSWebKitCSSMatrix>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWebKitCSSMatrix*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSWebKitCSSMatrix* IDLOperation<JSWebKitCSSMatrix>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSWebKitCSSMatrix*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsWebKitCSSMatrixConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitCSSMatrixPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebKitCSSMatrix::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebKitCSSMatrixConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitCSSMatrixPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsWebKitCSSMatrixAGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.a());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixA(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixAGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "a");
}

static inline bool setJSWebKitCSSMatrixASetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setA(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixA(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixASetter>(*lexicalGlobalObject, thisValue, encodedValue, "a");
}

static inline JSValue jsWebKitCSSMatrixBGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.b());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixB(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixBGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "b");
}

static inline bool setJSWebKitCSSMatrixBSetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setB(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixB(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixBSetter>(*lexicalGlobalObject, thisValue, encodedValue, "b");
}

static inline JSValue jsWebKitCSSMatrixCGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.c());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixC(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixCGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "c");
}

static inline bool setJSWebKitCSSMatrixCSetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setC(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixC(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixCSetter>(*lexicalGlobalObject, thisValue, encodedValue, "c");
}

static inline JSValue jsWebKitCSSMatrixDGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.d());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixD(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixDGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "d");
}

static inline bool setJSWebKitCSSMatrixDSetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setD(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixD(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixDSetter>(*lexicalGlobalObject, thisValue, encodedValue, "d");
}

static inline JSValue jsWebKitCSSMatrixEGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.e());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixE(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixEGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "e");
}

static inline bool setJSWebKitCSSMatrixESetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setE(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixE(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixESetter>(*lexicalGlobalObject, thisValue, encodedValue, "e");
}

static inline JSValue jsWebKitCSSMatrixFGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.f());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixF(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixFGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "f");
}

static inline bool setJSWebKitCSSMatrixFSetter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setF(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixF(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixFSetter>(*lexicalGlobalObject, thisValue, encodedValue, "f");
}

static inline JSValue jsWebKitCSSMatrixM11Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m11());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM11(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM11Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m11");
}

static inline bool setJSWebKitCSSMatrixM11Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM11(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM11(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM11Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m11");
}

static inline JSValue jsWebKitCSSMatrixM12Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m12());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM12(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM12Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m12");
}

static inline bool setJSWebKitCSSMatrixM12Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM12(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM12(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM12Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m12");
}

static inline JSValue jsWebKitCSSMatrixM13Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m13());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM13(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM13Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m13");
}

static inline bool setJSWebKitCSSMatrixM13Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM13(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM13(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM13Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m13");
}

static inline JSValue jsWebKitCSSMatrixM14Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m14());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM14(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM14Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m14");
}

static inline bool setJSWebKitCSSMatrixM14Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM14(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM14(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM14Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m14");
}

static inline JSValue jsWebKitCSSMatrixM21Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m21());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM21(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM21Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m21");
}

static inline bool setJSWebKitCSSMatrixM21Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM21(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM21(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM21Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m21");
}

static inline JSValue jsWebKitCSSMatrixM22Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m22());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM22(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM22Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m22");
}

static inline bool setJSWebKitCSSMatrixM22Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM22(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM22(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM22Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m22");
}

static inline JSValue jsWebKitCSSMatrixM23Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m23());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM23(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM23Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m23");
}

static inline bool setJSWebKitCSSMatrixM23Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM23(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM23(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM23Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m23");
}

static inline JSValue jsWebKitCSSMatrixM24Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m24());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM24(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM24Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m24");
}

static inline bool setJSWebKitCSSMatrixM24Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM24(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM24(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM24Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m24");
}

static inline JSValue jsWebKitCSSMatrixM31Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m31());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM31(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM31Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m31");
}

static inline bool setJSWebKitCSSMatrixM31Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM31(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM31(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM31Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m31");
}

static inline JSValue jsWebKitCSSMatrixM32Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m32());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM32(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM32Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m32");
}

static inline bool setJSWebKitCSSMatrixM32Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM32(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM32(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM32Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m32");
}

static inline JSValue jsWebKitCSSMatrixM33Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m33());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM33(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM33Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m33");
}

static inline bool setJSWebKitCSSMatrixM33Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM33(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM33(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM33Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m33");
}

static inline JSValue jsWebKitCSSMatrixM34Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m34());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM34(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM34Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m34");
}

static inline bool setJSWebKitCSSMatrixM34Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM34(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM34(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM34Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m34");
}

static inline JSValue jsWebKitCSSMatrixM41Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m41());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM41(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM41Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m41");
}

static inline bool setJSWebKitCSSMatrixM41Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM41(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM41(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM41Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m41");
}

static inline JSValue jsWebKitCSSMatrixM42Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m42());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM42(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM42Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m42");
}

static inline bool setJSWebKitCSSMatrixM42Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM42(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM42(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM42Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m42");
}

static inline JSValue jsWebKitCSSMatrixM43Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m43());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM43(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM43Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m43");
}

static inline bool setJSWebKitCSSMatrixM43Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM43(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM43(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM43Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m43");
}

static inline JSValue jsWebKitCSSMatrixM44Getter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m44());
    return result;
}

EncodedJSValue jsWebKitCSSMatrixM44(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitCSSMatrix>::get<jsWebKitCSSMatrixM44Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m44");
}

static inline bool setJSWebKitCSSMatrixM44Setter(JSGlobalObject& lexicalGlobalObject, JSWebKitCSSMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM44(WTFMove(nativeValue));
    });
    return true;
}

bool setJSWebKitCSSMatrixM44(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSWebKitCSSMatrix>::set<setJSWebKitCSSMatrixM44Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m44");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionSetMatrixValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto string = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setMatrixValue(WTFMove(string)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSetMatrixValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionSetMatrixValueBody>(*lexicalGlobalObject, *callFrame, "setMatrixValue");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionMultiplyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto secondMatrix = convert<IDLNullable<IDLInterface<WebKitCSSMatrix>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "secondMatrix", "WebKitCSSMatrix", "multiply", "WebKitCSSMatrix"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebKitCSSMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.multiply(WTFMove(secondMatrix))));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionMultiply(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionMultiplyBody>(*lexicalGlobalObject, *callFrame, "multiply");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionInverseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<WebKitCSSMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.inverse()));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionInverse(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionInverseBody>(*lexicalGlobalObject, *callFrame, "inverse");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionTranslateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebKitCSSMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.translate(WTFMove(x), WTFMove(y), WTFMove(z))));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionTranslate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionTranslateBody>(*lexicalGlobalObject, *callFrame, "translate");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionScaleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto scaleX = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto scaleY = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto scaleZ = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebKitCSSMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.scale(WTFMove(scaleX), WTFMove(scaleY), WTFMove(scaleZ))));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionScale(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionScaleBody>(*lexicalGlobalObject, *callFrame, "scale");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionRotateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto rotX = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotY = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotZ = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebKitCSSMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rotate(WTFMove(rotX), WTFMove(rotY), WTFMove(rotZ))));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionRotateBody>(*lexicalGlobalObject, *callFrame, "rotate");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto angle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebKitCSSMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rotateAxisAngle(WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(angle))));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngle(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngleBody>(*lexicalGlobalObject, *callFrame, "rotateAxisAngle");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionSkewXBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto angle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebKitCSSMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.skewX(WTFMove(angle))));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewX(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionSkewXBody>(*lexicalGlobalObject, *callFrame, "skewX");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionSkewYBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto angle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebKitCSSMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.skewY(WTFMove(angle))));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewY(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionSkewYBody>(*lexicalGlobalObject, *callFrame, "skewY");
}

static inline JSC::EncodedJSValue jsWebKitCSSMatrixPrototypeFunctionToStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebKitCSSMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.toString()));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionToString(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSWebKitCSSMatrix>::call<jsWebKitCSSMatrixPrototypeFunctionToStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

void JSWebKitCSSMatrix::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebKitCSSMatrix*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebKitCSSMatrixOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebKitCSSMatrixOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebKitCSSMatrix = static_cast<JSWebKitCSSMatrix*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebKitCSSMatrix->wrapped(), jsWebKitCSSMatrix);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebKitCSSMatrix>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebKitCSSMatrix.
    static_assert(!std::is_polymorphic<WebKitCSSMatrix>::value, "WebKitCSSMatrix is polymorphic but the IDL claims it is not");
    return createWrapper<WebKitCSSMatrix>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebKitCSSMatrix& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebKitCSSMatrix* JSWebKitCSSMatrix::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebKitCSSMatrix*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
