/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(USER_MESSAGE_HANDLERS)

#include "JSWebKitNamespace.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSUserMessageHandlersNamespace.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsWebKitNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitNamespaceMessageHandlers(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSWebKitNamespacePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebKitNamespacePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitNamespacePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitNamespacePrototype>(vm.heap)) JSWebKitNamespacePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitNamespacePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitNamespacePrototype, JSWebKitNamespacePrototype::Base);

using JSWebKitNamespaceConstructor = JSDOMConstructorNotConstructable<JSWebKitNamespace>;

template<> JSValue JSWebKitNamespaceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebKitNamespaceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebKitNamespace::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WebKitNamespace"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebKitNamespaceConstructor::s_info = { "WebKitNamespace", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitNamespaceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebKitNamespacePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitNamespaceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitNamespaceConstructor) } },
    { "messageHandlers", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitNamespaceMessageHandlers), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSWebKitNamespacePrototype::s_info = { "WebKitNamespacePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitNamespacePrototype) };

void JSWebKitNamespacePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitNamespace::info(), JSWebKitNamespacePrototypeTableValues, *this);
}

const ClassInfo JSWebKitNamespace::s_info = { "WebKitNamespace", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitNamespace) };

JSWebKitNamespace::JSWebKitNamespace(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitNamespace>&& impl)
    : JSDOMWrapper<WebKitNamespace>(structure, globalObject, WTFMove(impl))
{
}

void JSWebKitNamespace::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebKitNamespace>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebKitNamespace::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebKitNamespacePrototype::create(vm, &globalObject, JSWebKitNamespacePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWebKitNamespace::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebKitNamespace>(vm, globalObject);
}

JSValue JSWebKitNamespace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitNamespaceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebKitNamespace::destroy(JSC::JSCell* cell)
{
    JSWebKitNamespace* thisObject = static_cast<JSWebKitNamespace*>(cell);
    thisObject->JSWebKitNamespace::~JSWebKitNamespace();
}

template<> inline JSWebKitNamespace* IDLAttribute<JSWebKitNamespace>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWebKitNamespace*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsWebKitNamespaceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitNamespacePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebKitNamespace::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebKitNamespaceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitNamespacePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsWebKitNamespaceMessageHandlersGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitNamespace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<UserMessageHandlersNamespace>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.messageHandlers());
    return result;
}

EncodedJSValue jsWebKitNamespaceMessageHandlers(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitNamespace>::get<jsWebKitNamespaceMessageHandlersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "messageHandlers");
}

void JSWebKitNamespace::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebKitNamespace*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebKitNamespaceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebKitNamespaceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebKitNamespace = static_cast<JSWebKitNamespace*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebKitNamespace->wrapped(), jsWebKitNamespace);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebKitNamespace@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15WebKitNamespaceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebKitNamespace>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebKitNamespace@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15WebKitNamespaceE[2];
#endif

    // If this fails WebKitNamespace does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebKitNamespace>::value, "WebKitNamespace is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebKitNamespace has subclasses. If WebKitNamespace has subclasses that get passed
    // to toJS() we currently require WebKitNamespace you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebKitNamespace>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebKitNamespace& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebKitNamespace* JSWebKitNamespace::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebKitNamespace*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(USER_MESSAGE_HANDLERS)
