/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WIRELESS_PLAYBACK_TARGET)

#include "JSWebKitPlaybackTargetAvailabilityEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> WebKitPlaybackTargetAvailabilityEvent::Init convertDictionary<WebKitPlaybackTargetAvailabilityEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebKitPlaybackTargetAvailabilityEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue availabilityValue;
    if (isNullOrUndefined)
        availabilityValue = jsUndefined();
    else {
        availabilityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "availability"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!availabilityValue.isUndefined()) {
        result.availability = convert<IDLDOMString>(lexicalGlobalObject, availabilityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.availability = emptyString();
    return result;
}

// Attributes

JSC::EncodedJSValue jsWebKitPlaybackTargetAvailabilityEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitPlaybackTargetAvailabilityEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitPlaybackTargetAvailabilityEventAvailability(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSWebKitPlaybackTargetAvailabilityEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebKitPlaybackTargetAvailabilityEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitPlaybackTargetAvailabilityEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitPlaybackTargetAvailabilityEventPrototype>(vm.heap)) JSWebKitPlaybackTargetAvailabilityEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitPlaybackTargetAvailabilityEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitPlaybackTargetAvailabilityEventPrototype, JSWebKitPlaybackTargetAvailabilityEventPrototype::Base);

using JSWebKitPlaybackTargetAvailabilityEventConstructor = JSDOMConstructor<JSWebKitPlaybackTargetAvailabilityEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSWebKitPlaybackTargetAvailabilityEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSWebKitPlaybackTargetAvailabilityEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<WebKitPlaybackTargetAvailabilityEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WebKitPlaybackTargetAvailabilityEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<WebKitPlaybackTargetAvailabilityEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSWebKitPlaybackTargetAvailabilityEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSWebKitPlaybackTargetAvailabilityEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebKitPlaybackTargetAvailabilityEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WebKitPlaybackTargetAvailabilityEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebKitPlaybackTargetAvailabilityEventConstructor::s_info = { "WebKitPlaybackTargetAvailabilityEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitPlaybackTargetAvailabilityEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebKitPlaybackTargetAvailabilityEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitPlaybackTargetAvailabilityEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitPlaybackTargetAvailabilityEventConstructor) } },
    { "availability", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitPlaybackTargetAvailabilityEventAvailability), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSWebKitPlaybackTargetAvailabilityEventPrototype::s_info = { "WebKitPlaybackTargetAvailabilityEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitPlaybackTargetAvailabilityEventPrototype) };

void JSWebKitPlaybackTargetAvailabilityEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitPlaybackTargetAvailabilityEvent::info(), JSWebKitPlaybackTargetAvailabilityEventPrototypeTableValues, *this);
}

const ClassInfo JSWebKitPlaybackTargetAvailabilityEvent::s_info = { "WebKitPlaybackTargetAvailabilityEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitPlaybackTargetAvailabilityEvent) };

JSWebKitPlaybackTargetAvailabilityEvent::JSWebKitPlaybackTargetAvailabilityEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitPlaybackTargetAvailabilityEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSWebKitPlaybackTargetAvailabilityEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebKitPlaybackTargetAvailabilityEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebKitPlaybackTargetAvailabilityEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebKitPlaybackTargetAvailabilityEventPrototype::create(vm, &globalObject, JSWebKitPlaybackTargetAvailabilityEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSWebKitPlaybackTargetAvailabilityEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebKitPlaybackTargetAvailabilityEvent>(vm, globalObject);
}

JSValue JSWebKitPlaybackTargetAvailabilityEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitPlaybackTargetAvailabilityEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSWebKitPlaybackTargetAvailabilityEvent* IDLAttribute<JSWebKitPlaybackTargetAvailabilityEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWebKitPlaybackTargetAvailabilityEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsWebKitPlaybackTargetAvailabilityEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitPlaybackTargetAvailabilityEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebKitPlaybackTargetAvailabilityEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebKitPlaybackTargetAvailabilityEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitPlaybackTargetAvailabilityEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsWebKitPlaybackTargetAvailabilityEventAvailabilityGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitPlaybackTargetAvailabilityEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.availability());
    return result;
}

EncodedJSValue jsWebKitPlaybackTargetAvailabilityEventAvailability(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitPlaybackTargetAvailabilityEvent>::get<jsWebKitPlaybackTargetAvailabilityEventAvailabilityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "availability");
}

void JSWebKitPlaybackTargetAvailabilityEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebKitPlaybackTargetAvailabilityEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebKitPlaybackTargetAvailabilityEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore37WebKitPlaybackTargetAvailabilityEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebKitPlaybackTargetAvailabilityEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebKitPlaybackTargetAvailabilityEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore37WebKitPlaybackTargetAvailabilityEventE[2];
#endif

    // If this fails WebKitPlaybackTargetAvailabilityEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebKitPlaybackTargetAvailabilityEvent>::value, "WebKitPlaybackTargetAvailabilityEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebKitPlaybackTargetAvailabilityEvent has subclasses. If WebKitPlaybackTargetAvailabilityEvent has subclasses that get passed
    // to toJS() we currently require WebKitPlaybackTargetAvailabilityEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebKitPlaybackTargetAvailabilityEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebKitPlaybackTargetAvailabilityEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WIRELESS_PLAYBACK_TARGET)
