/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitTransitionEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> WebKitTransitionEvent::Init convertDictionary<WebKitTransitionEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebKitTransitionEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue elapsedTimeValue;
    if (isNullOrUndefined)
        elapsedTimeValue = jsUndefined();
    else {
        elapsedTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "elapsedTime"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!elapsedTimeValue.isUndefined()) {
        result.elapsedTime = convert<IDLDouble>(lexicalGlobalObject, elapsedTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.elapsedTime = 0;
    JSValue propertyNameValue;
    if (isNullOrUndefined)
        propertyNameValue = jsUndefined();
    else {
        propertyNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "propertyName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!propertyNameValue.isUndefined()) {
        result.propertyName = convert<IDLDOMString>(lexicalGlobalObject, propertyNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.propertyName = emptyString();
    JSValue pseudoElementValue;
    if (isNullOrUndefined)
        pseudoElementValue = jsUndefined();
    else {
        pseudoElementValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pseudoElement"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pseudoElementValue.isUndefined()) {
        result.pseudoElement = convert<IDLDOMString>(lexicalGlobalObject, pseudoElementValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pseudoElement = emptyString();
    return result;
}

// Attributes

JSC::EncodedJSValue jsWebKitTransitionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWebKitTransitionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitTransitionEventPropertyName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebKitTransitionEventElapsedTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebKitTransitionEventPseudoElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSWebKitTransitionEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebKitTransitionEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitTransitionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitTransitionEventPrototype>(vm.heap)) JSWebKitTransitionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitTransitionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitTransitionEventPrototype, JSWebKitTransitionEventPrototype::Base);

using JSWebKitTransitionEventConstructor = JSDOMConstructor<JSWebKitTransitionEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSWebKitTransitionEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSWebKitTransitionEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<WebKitTransitionEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WebKitTransitionEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<WebKitTransitionEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSWebKitTransitionEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSWebKitTransitionEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebKitTransitionEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WebKitTransitionEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWebKitTransitionEventConstructor::s_info = { "WebKitTransitionEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitTransitionEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebKitTransitionEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitTransitionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitTransitionEventConstructor) } },
    { "propertyName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitTransitionEventPropertyName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "elapsedTime", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitTransitionEventElapsedTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pseudoElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitTransitionEventPseudoElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSWebKitTransitionEventPrototype::s_info = { "WebKitTransitionEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitTransitionEventPrototype) };

void JSWebKitTransitionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitTransitionEvent::info(), JSWebKitTransitionEventPrototypeTableValues, *this);
}

const ClassInfo JSWebKitTransitionEvent::s_info = { "WebKitTransitionEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitTransitionEvent) };

JSWebKitTransitionEvent::JSWebKitTransitionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitTransitionEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSWebKitTransitionEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WebKitTransitionEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWebKitTransitionEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWebKitTransitionEventPrototype::create(vm, &globalObject, JSWebKitTransitionEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSWebKitTransitionEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebKitTransitionEvent>(vm, globalObject);
}

JSValue JSWebKitTransitionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitTransitionEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSWebKitTransitionEvent* IDLAttribute<JSWebKitTransitionEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWebKitTransitionEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsWebKitTransitionEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitTransitionEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebKitTransitionEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWebKitTransitionEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitTransitionEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsWebKitTransitionEventPropertyNameGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitTransitionEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.propertyName());
    return result;
}

EncodedJSValue jsWebKitTransitionEventPropertyName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitTransitionEvent>::get<jsWebKitTransitionEventPropertyNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "propertyName");
}

static inline JSValue jsWebKitTransitionEventElapsedTimeGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitTransitionEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.elapsedTime());
    return result;
}

EncodedJSValue jsWebKitTransitionEventElapsedTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitTransitionEvent>::get<jsWebKitTransitionEventElapsedTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "elapsedTime");
}

static inline JSValue jsWebKitTransitionEventPseudoElementGetter(JSGlobalObject& lexicalGlobalObject, JSWebKitTransitionEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.pseudoElement());
    return result;
}

EncodedJSValue jsWebKitTransitionEventPseudoElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWebKitTransitionEvent>::get<jsWebKitTransitionEventPseudoElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pseudoElement");
}

void JSWebKitTransitionEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebKitTransitionEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebKitTransitionEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21WebKitTransitionEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebKitTransitionEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WebKitTransitionEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore21WebKitTransitionEventE[2];
#endif

    // If this fails WebKitTransitionEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WebKitTransitionEvent>::value, "WebKitTransitionEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WebKitTransitionEvent has subclasses. If WebKitTransitionEvent has subclasses that get passed
    // to toJS() we currently require WebKitTransitionEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WebKitTransitionEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebKitTransitionEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
