/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWorkerNavigator.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(SERVICE_WORKER)
#include "JSServiceWorkerContainer.h"
#endif

#if ENABLE(SERVICE_WORKER) || ENABLE(WEBGPU)
#include "JSDOMConvertInterface.h"
#endif

#if ENABLE(WEBGPU)
#include "JSWebGPU.h"
#include "WorkerNavigatorGPU.h"
#endif


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsWorkerNavigatorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSWorkerNavigatorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsWorkerNavigatorGpu(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsWorkerNavigatorAppCodeName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorAppName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorAppVersion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorPlatform(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorProduct(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorUserAgent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorLanguage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorLanguages(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerNavigatorOnLine(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsWorkerNavigatorServiceWorker(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif

class JSWorkerNavigatorPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWorkerNavigatorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWorkerNavigatorPrototype* ptr = new (NotNull, JSC::allocateCell<JSWorkerNavigatorPrototype>(vm.heap)) JSWorkerNavigatorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWorkerNavigatorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWorkerNavigatorPrototype, JSWorkerNavigatorPrototype::Base);

using JSWorkerNavigatorConstructor = JSDOMConstructorNotConstructable<JSWorkerNavigator>;

template<> JSValue JSWorkerNavigatorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWorkerNavigatorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWorkerNavigator::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("WorkerNavigator"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSWorkerNavigatorConstructor::s_info = { "WorkerNavigator", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWorkerNavigatorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWorkerNavigatorPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerNavigatorConstructor) } },
#if ENABLE(WEBGPU)
    { "gpu", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorGpu), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "appCodeName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorAppCodeName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "appName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorAppName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "appVersion", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorAppVersion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "platform", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorPlatform), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "product", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorProduct), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "userAgent", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorUserAgent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "language", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorLanguage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "languages", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorLanguages), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onLine", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorOnLine), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(SERVICE_WORKER)
    { "serviceWorker", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorServiceWorker), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSWorkerNavigatorPrototype::s_info = { "WorkerNavigatorPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWorkerNavigatorPrototype) };

void JSWorkerNavigatorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWorkerNavigator::info(), JSWorkerNavigatorPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(WEBGPU)
    if (!RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("gpu"), strlen("gpu"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(SERVICE_WORKER)
    if (!((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext()|| jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->hasServiceWorkerScheme()) && RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("serviceWorker"), strlen("serviceWorker"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSWorkerNavigator::s_info = { "WorkerNavigator", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWorkerNavigator) };

JSWorkerNavigator::JSWorkerNavigator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WorkerNavigator>&& impl)
    : JSDOMWrapper<WorkerNavigator>(structure, globalObject, WTFMove(impl))
{
}

void JSWorkerNavigator::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, WorkerNavigator>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSWorkerNavigator::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSWorkerNavigatorPrototype::create(vm, &globalObject, JSWorkerNavigatorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSWorkerNavigator::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWorkerNavigator>(vm, globalObject);
}

JSValue JSWorkerNavigator::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWorkerNavigatorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWorkerNavigator::destroy(JSC::JSCell* cell)
{
    JSWorkerNavigator* thisObject = static_cast<JSWorkerNavigator*>(cell);
    thisObject->JSWorkerNavigator::~JSWorkerNavigator();
}

template<> inline JSWorkerNavigator* IDLAttribute<JSWorkerNavigator>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSWorkerNavigator*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsWorkerNavigatorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWorkerNavigatorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWorkerNavigator::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSWorkerNavigatorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWorkerNavigatorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

#if ENABLE(WEBGPU)
static inline JSValue jsWorkerNavigatorGpuGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<WebGPU>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::WorkerNavigatorGPU::gpu(impl));
    return result;
}

EncodedJSValue jsWorkerNavigatorGpu(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorGpuGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "gpu");
}

#endif

static inline JSValue jsWorkerNavigatorAppCodeNameGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.appCodeName());
    return result;
}

EncodedJSValue jsWorkerNavigatorAppCodeName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorAppCodeNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "appCodeName");
}

static inline JSValue jsWorkerNavigatorAppNameGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.appName());
    return result;
}

EncodedJSValue jsWorkerNavigatorAppName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorAppNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "appName");
}

static inline JSValue jsWorkerNavigatorAppVersionGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.appVersion());
    return result;
}

EncodedJSValue jsWorkerNavigatorAppVersion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorAppVersionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "appVersion");
}

static inline JSValue jsWorkerNavigatorPlatformGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.platform());
    return result;
}

EncodedJSValue jsWorkerNavigatorPlatform(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorPlatformGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "platform");
}

static inline JSValue jsWorkerNavigatorProductGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.product());
    return result;
}

EncodedJSValue jsWorkerNavigatorProduct(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorProductGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "product");
}

static inline JSValue jsWorkerNavigatorUserAgentGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.userAgent());
    return result;
}

EncodedJSValue jsWorkerNavigatorUserAgent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorUserAgentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "userAgent");
}

static inline JSValue jsWorkerNavigatorLanguageGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.language());
    return result;
}

EncodedJSValue jsWorkerNavigatorLanguage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorLanguageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "language");
}

static inline JSValue jsWorkerNavigatorLanguagesGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.languages());
    return result;
}

EncodedJSValue jsWorkerNavigatorLanguages(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorLanguagesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "languages");
}

static inline JSValue jsWorkerNavigatorOnLineGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.onLine());
    return result;
}

EncodedJSValue jsWorkerNavigatorOnLine(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorOnLineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onLine");
}

#if ENABLE(SERVICE_WORKER)
static inline JSValue jsWorkerNavigatorServiceWorkerGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<ServiceWorkerContainer>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.serviceWorker(*context));
    return result;
}

EncodedJSValue jsWorkerNavigatorServiceWorker(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigatorServiceWorkerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "serviceWorker");
}

#endif

void JSWorkerNavigator::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSWorkerNavigator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSWorkerNavigator::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSWorkerNavigator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSWorkerNavigator::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWorkerNavigator*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWorkerNavigatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsWorkerNavigator = jsCast<JSWorkerNavigator*>(handle.slot()->asCell());
    WorkerNavigator* root = &jsWorkerNavigator->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from WorkerNavigator";
    return visitor.containsOpaqueRoot(root);
}

void JSWorkerNavigatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWorkerNavigator = static_cast<JSWorkerNavigator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWorkerNavigator->wrapped(), jsWorkerNavigator);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WorkerNavigator@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15WorkerNavigatorE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WorkerNavigator>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7WorkerNavigator@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15WorkerNavigatorE[2];
#endif

    // If this fails WorkerNavigator does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<WorkerNavigator>::value, "WorkerNavigator is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // WorkerNavigator has subclasses. If WorkerNavigator has subclasses that get passed
    // to toJS() we currently require WorkerNavigator you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<WorkerNavigator>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WorkerNavigator& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WorkerNavigator* JSWorkerNavigator::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWorkerNavigator*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
