/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestEventTarget.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsXMLHttpRequestEventTargetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestEventTargetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnloadstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestEventTargetOnloadstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestEventTargetOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestEventTargetOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestEventTargetOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestEventTargetOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOntimeout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestEventTargetOntimeout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnloadend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestEventTargetOnloadend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXMLHttpRequestEventTargetPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXMLHttpRequestEventTargetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestEventTargetPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestEventTargetPrototype>(vm.heap)) JSXMLHttpRequestEventTargetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestEventTargetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestEventTargetPrototype, JSXMLHttpRequestEventTargetPrototype::Base);

using JSXMLHttpRequestEventTargetConstructor = JSDOMConstructorNotConstructable<JSXMLHttpRequestEventTarget>;

template<> JSValue JSXMLHttpRequestEventTargetConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestEventTargetConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequestEventTarget::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("XMLHttpRequestEventTarget"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSXMLHttpRequestEventTargetConstructor::s_info = { "XMLHttpRequestEventTarget", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestEventTargetConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestEventTargetPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetConstructor) } },
    { "onloadstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnloadstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnloadstart) } },
    { "onprogress", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnprogress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnprogress) } },
    { "onabort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnabort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnabort) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnerror) } },
    { "onload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnload) } },
    { "ontimeout", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOntimeout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOntimeout) } },
    { "onloadend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnloadend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnloadend) } },
};

const ClassInfo JSXMLHttpRequestEventTargetPrototype::s_info = { "XMLHttpRequestEventTargetPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestEventTargetPrototype) };

void JSXMLHttpRequestEventTargetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequestEventTarget::info(), JSXMLHttpRequestEventTargetPrototypeTableValues, *this);
}

const ClassInfo JSXMLHttpRequestEventTarget::s_info = { "XMLHttpRequestEventTarget", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestEventTarget) };

JSXMLHttpRequestEventTarget::JSXMLHttpRequestEventTarget(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequestEventTarget>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSXMLHttpRequestEventTarget::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, XMLHttpRequestEventTarget>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSXMLHttpRequestEventTarget::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSXMLHttpRequestEventTargetPrototype::create(vm, &globalObject, JSXMLHttpRequestEventTargetPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSXMLHttpRequestEventTarget::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestEventTarget>(vm, globalObject);
}

JSValue JSXMLHttpRequestEventTarget::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestEventTargetConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSXMLHttpRequestEventTarget* IDLAttribute<JSXMLHttpRequestEventTarget>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSXMLHttpRequestEventTarget*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsXMLHttpRequestEventTargetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestEventTargetPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXMLHttpRequestEventTarget::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSXMLHttpRequestEventTargetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestEventTargetPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsXMLHttpRequestEventTargetOnloadstartGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsXMLHttpRequestEventTargetOnloadstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTargetOnloadstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadstart");
}

static inline bool setJSXMLHttpRequestEventTargetOnloadstartSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadstartEvent, value);
    return true;
}

bool setJSXMLHttpRequestEventTargetOnloadstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTargetOnloadstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadstart");
}

static inline JSValue jsXMLHttpRequestEventTargetOnprogressGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsXMLHttpRequestEventTargetOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTargetOnprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onprogress");
}

static inline bool setJSXMLHttpRequestEventTargetOnprogressSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().progressEvent, value);
    return true;
}

bool setJSXMLHttpRequestEventTargetOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTargetOnprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onprogress");
}

static inline JSValue jsXMLHttpRequestEventTargetOnabortGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsXMLHttpRequestEventTargetOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTargetOnabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onabort");
}

static inline bool setJSXMLHttpRequestEventTargetOnabortSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().abortEvent, value);
    return true;
}

bool setJSXMLHttpRequestEventTargetOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTargetOnabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onabort");
}

static inline JSValue jsXMLHttpRequestEventTargetOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsXMLHttpRequestEventTargetOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTargetOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSXMLHttpRequestEventTargetOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSXMLHttpRequestEventTargetOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTargetOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsXMLHttpRequestEventTargetOnloadGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsXMLHttpRequestEventTargetOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTargetOnloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onload");
}

static inline bool setJSXMLHttpRequestEventTargetOnloadSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadEvent, value);
    return true;
}

bool setJSXMLHttpRequestEventTargetOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTargetOnloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onload");
}

static inline JSValue jsXMLHttpRequestEventTargetOntimeoutGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().timeoutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsXMLHttpRequestEventTargetOntimeout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTargetOntimeoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontimeout");
}

static inline bool setJSXMLHttpRequestEventTargetOntimeoutSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().timeoutEvent, value);
    return true;
}

bool setJSXMLHttpRequestEventTargetOntimeout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTargetOntimeoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontimeout");
}

static inline JSValue jsXMLHttpRequestEventTargetOnloadendGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsXMLHttpRequestEventTargetOnloadend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTargetOnloadendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadend");
}

static inline bool setJSXMLHttpRequestEventTargetOnloadendSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadendEvent, value);
    return true;
}

bool setJSXMLHttpRequestEventTargetOnloadend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTargetOnloadendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadend");
}

void JSXMLHttpRequestEventTarget::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXMLHttpRequestEventTarget*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

XMLHttpRequestEventTarget* JSXMLHttpRequestEventTarget::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXMLHttpRequestEventTarget*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
