/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestUpload.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsXMLHttpRequestUploadConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXMLHttpRequestUploadConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXMLHttpRequestUploadPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXMLHttpRequestUploadPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestUploadPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestUploadPrototype>(vm.heap)) JSXMLHttpRequestUploadPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestUploadPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestUploadPrototype, JSXMLHttpRequestUploadPrototype::Base);

using JSXMLHttpRequestUploadConstructor = JSDOMConstructorNotConstructable<JSXMLHttpRequestUpload>;

template<> JSValue JSXMLHttpRequestUploadConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSXMLHttpRequestEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestUploadConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequestUpload::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("XMLHttpRequestUpload"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSXMLHttpRequestUploadConstructor::s_info = { "XMLHttpRequestUpload", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestUploadConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestUploadPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUploadConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestUploadConstructor) } },
};

const ClassInfo JSXMLHttpRequestUploadPrototype::s_info = { "XMLHttpRequestUploadPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestUploadPrototype) };

void JSXMLHttpRequestUploadPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequestUpload::info(), JSXMLHttpRequestUploadPrototypeTableValues, *this);
}

const ClassInfo JSXMLHttpRequestUpload::s_info = { "XMLHttpRequestUpload", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestUpload) };

JSXMLHttpRequestUpload::JSXMLHttpRequestUpload(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequestUpload>&& impl)
    : JSXMLHttpRequestEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSXMLHttpRequestUpload::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, XMLHttpRequestUpload>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSXMLHttpRequestUpload::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSXMLHttpRequestUploadPrototype::create(vm, &globalObject, JSXMLHttpRequestUploadPrototype::createStructure(vm, &globalObject, JSXMLHttpRequestEventTarget::prototype(vm, globalObject)));
}

JSObject* JSXMLHttpRequestUpload::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestUpload>(vm, globalObject);
}

JSValue JSXMLHttpRequestUpload::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestUploadConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue jsXMLHttpRequestUploadConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestUploadPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXMLHttpRequestUpload::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSXMLHttpRequestUploadConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestUploadPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSXMLHttpRequestUpload::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXMLHttpRequestUpload*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXMLHttpRequestUploadOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsXMLHttpRequestUpload = jsCast<JSXMLHttpRequestUpload*>(handle.slot()->asCell());
    if (jsXMLHttpRequestUpload->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    XMLHttpRequestUpload* root = &jsXMLHttpRequestUpload->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from XMLHttpRequestUpload";
    return visitor.containsOpaqueRoot(root);
}

void JSXMLHttpRequestUploadOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXMLHttpRequestUpload = static_cast<JSXMLHttpRequestUpload*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXMLHttpRequestUpload->wrapped(), jsXMLHttpRequestUpload);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XMLHttpRequestUpload@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20XMLHttpRequestUploadE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XMLHttpRequestUpload>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7XMLHttpRequestUpload@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore20XMLHttpRequestUploadE[2];
#endif

    // If this fails XMLHttpRequestUpload does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<XMLHttpRequestUpload>::value, "XMLHttpRequestUpload is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // XMLHttpRequestUpload has subclasses. If XMLHttpRequestUpload has subclasses that get passed
    // to toJS() we currently require XMLHttpRequestUpload you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<XMLHttpRequestUpload>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XMLHttpRequestUpload& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
