/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathNSResolver.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXPathNSResolverPrototypeFunctionLookupNamespaceURI(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSXPathNSResolverPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXPathNSResolverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathNSResolverPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathNSResolverPrototype>(vm.heap)) JSXPathNSResolverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathNSResolverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathNSResolverPrototype, JSXPathNSResolverPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSXPathNSResolverPrototypeTableValues[] =
{
    { "lookupNamespaceURI", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXPathNSResolverPrototypeFunctionLookupNamespaceURI), (intptr_t) (0) } },
};

const ClassInfo JSXPathNSResolverPrototype::s_info = { "XPathNSResolverPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathNSResolverPrototype) };

void JSXPathNSResolverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathNSResolver::info(), JSXPathNSResolverPrototypeTableValues, *this);
}

const ClassInfo JSXPathNSResolver::s_info = { "XPathNSResolver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathNSResolver) };

JSXPathNSResolver::JSXPathNSResolver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathNSResolver>&& impl)
    : JSDOMWrapper<XPathNSResolver>(structure, globalObject, WTFMove(impl))
{
}

void JSXPathNSResolver::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, XPathNSResolver>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSXPathNSResolver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSXPathNSResolverPrototype::create(vm, &globalObject, JSXPathNSResolverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSXPathNSResolver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXPathNSResolver>(vm, globalObject);
}

void JSXPathNSResolver::destroy(JSC::JSCell* cell)
{
    JSXPathNSResolver* thisObject = static_cast<JSXPathNSResolver*>(cell);
    thisObject->JSXPathNSResolver::~JSXPathNSResolver();
}

template<> inline JSXPathNSResolver* IDLOperation<JSXPathNSResolver>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSXPathNSResolver*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsXPathNSResolverPrototypeFunctionLookupNamespaceURIBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathNSResolver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto prefix = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, impl.lookupNamespaceURI(WTFMove(prefix))));
}

EncodedJSValue JSC_HOST_CALL jsXPathNSResolverPrototypeFunctionLookupNamespaceURI(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXPathNSResolver>::call<jsXPathNSResolverPrototypeFunctionLookupNamespaceURIBody>(*lexicalGlobalObject, *callFrame, "lookupNamespaceURI");
}

void JSXPathNSResolver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXPathNSResolver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXPathNSResolverOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXPathNSResolverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathNSResolver = static_cast<JSXPathNSResolver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXPathNSResolver->wrapped(), jsXPathNSResolver);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XPathNSResolver>&& impl)
{
    return createWrapper<XPathNSResolver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XPathNSResolver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
